#pragma once
#include "Scene.h"
#include "LightShaftGeometry.h"

namespace osgCloudyDay
{
	/**
	 * Class updates the lightshaft uniforms at runtime
	 */
	class ViewerLightCallback2 : public osg::NodeCallback
	{
	public:
		/**
		 * Constructor
		 */
		ViewerLightCallback2(void)
		{

		}

		/**
		 * Method, which updates the uniforms at runtime
		 */
		virtual void operator()(osg::Node* node, osg::NodeVisitor* nv)
		{
			osgUtil::CullVisitor* cv = dynamic_cast<osgUtil::CullVisitor*>(nv);	   
			osg::ref_ptr<osg::Geode> geometry = dynamic_cast<osg::Geode*> (node);

			if(geometry && cv)
			{
				osg::Matrixd view(cv->getCurrentCamera()->getViewMatrix());
				osg::Matrixd invViewMatrix = osg::Matrixd::inverse(view);
				osg::Matrixd model(*cv->getModelViewMatrix());
				model = model*invViewMatrix;
				osg::Matrixd proj(cv->getCurrentCamera()->getProjectionMatrix());
		
				geometry->getOrCreateStateSet()->getUniform("ModelMatrix")->set(model);
				geometry->getOrCreateStateSet()->getUniform("ViewMatrix")->set(Scene::GetViewMatrix_View());
				geometry->getOrCreateStateSet()->getUniform("ProjectionMatrix")->set(Scene::GetProjectionMatrix_View());					
			
				geometry->getOrCreateStateSet()->addUniform(new osg::Uniform("v3LightPos", Scene::m_skydome->GetLightPosition()));
				Scene::m_skydome->SetupUniform(geometry.get()->getOrCreateStateSet());
				geometry->getOrCreateStateSet()->addUniform(new osg::Uniform("color_tex", 0));					

	#ifdef SHADOW_MAPPING
				geometry->getOrCreateStateSet()->getUniform("light_proj_matrix")->set(Scene::GetProjectionMatrix_Light());
				geometry->getOrCreateStateSet()->getUniform("light_mv_matrix")->set(Scene::GetLightCamera()->getViewMatrix());
	#endif
			}
			traverse(node, nv);
		}
	};

	/**
	 * Class, which creates light shafts (Bruneton approach)
	 */
	class LightShaft
	{
	public:
		/**
		 * Constructor
		 */
		LightShaft(void);
		/**
		 * Deconstructor
		 */
		~LightShaft(void);

		/**
		 * Initialize method
		 */
		void Initialize();
		/**
		 * Returns the camera
		 * @return camera for lightshaft calculation
		 */
		osg::ref_ptr<osg::Camera> GetCamera();

		/**
		 * Returns lightshaft texture
		 * @return lightshaft1 texture
		 */
		osg::ref_ptr<osg::Texture2D> GetLightshaft1();
		/**
		 * Returns lightshaft texture
		 * @return lightshaft2 texture
		 */
		osg::ref_ptr<osg::Texture2D> GetLightshaft2();
		
	protected:
		osg::ref_ptr<osg::Texture2D> fbo_lightshaft1;
		osg::ref_ptr<osg::Texture2D> fbo_lightshaft2;

		osg::ref_ptr<osg::Texture2D> fbo_lightshaft_d;	
		osg::Camera* camera_lightshaft;
	};
}