#pragma once
#include <osg/Array>
#include <osg/Ref_Ptr>
#include <iostream>
#include <stdio.h>
#include <string>

namespace osgCloudyDay
{
	/**
	 * Helper class to save a cloud
	 * Manages a boundingbox of the particles
	 */
	class Box
	{
	public:
		/**
		 * Constructor
		 */
		Box(){};
		/**
		 * Deconstructor
		 */
		~Box(){};

		osg::ref_ptr<osg::Vec3Array> vertices;
		osg::ref_ptr<osg::Vec4Array> color;
		osg::ref_ptr<osg::Vec4Array> rotation;
		osg::ref_ptr<osg::Vec4Array> center;
		osg::ref_ptr<osg::Vec4Array> ids;

		osg::Vec3 box_center;	
	};

	/**
	 * Helper class to save a cloud
	 */
	class Cloud
	{
	public:
		/**
		 * Constructor
		 */
		Cloud()
		{

		};
		/**
		 * Deconstructor
		 */
		~Cloud()
		{
			//delete[] m_boxes;
		};

		std::vector<Box> m_boxes;

		osg::Vec3 cloud_center;		

		osg::ref_ptr<osg::Vec3Array> ambientlight_color;
		osg::ref_ptr<osg::Vec3Array> diffuselight_h;
		osg::ref_ptr<osg::Vec3Array> diffuselight_t;
		
		
		float timeOfDay;
		float fading;

		int num_boxes;
	
	};

	/**
	 * Class, which manages the import and export of the cloud
	 */
	class ImportExport
	{
	public:
		/**
		 * Constructor
		 */
		ImportExport(void);
		/**
		 * Deconstructor
		 */
		~ImportExport(void);

		/**
		 * This method adds a cloud
		 * @param vertices vertices of a cloud
		 * @param rotation rotation array of the cloud
		 * @param center center array of the cloud
		 * @param ids array of the clouds
		 */
		void AddCloud(osg::ref_ptr<osg::Vec3Array> vertices, osg::ref_ptr<osg::Vec4Array> rotation, osg::ref_ptr<osg::Vec4Array> color, osg::ref_ptr<osg::Vec4Array> center, osg::ref_ptr<osg::Vec4Array> ids, osg::ref_ptr<osg::Vec4Array> box_centers, int num_boxes);
		/**
		 * This method adds a cloud
		 * @param c cloud
		 */
		void AddCloud(Cloud c);
		/**
		 * Returns the cloud array
		 * @param vertices vertices array
		 * @param rotation rotation array
		 * @param center center array
		 * @param ids ids array
		 */
		void GetData(int at, osg::ref_ptr<osg::Vec3Array> &vertices, osg::ref_ptr<osg::Vec4Array> &rotation, osg::ref_ptr<osg::Vec4Array> &color, osg::ref_ptr<osg::Vec4Array> &center, osg::ref_ptr<osg::Vec4Array> &ids, osg::ref_ptr<osg::Vec4Array> &boxcenter);
		/**
		 * Returns the number of clouds
		 * @param number of clouds
		 */
		unsigned int NumClouds();

		/**
		 * Import/export the cloud (abstract)
		 */
		virtual void Perform() = 0;

	protected:
		std::vector<Cloud> m_cloud;
	};
}