#pragma once
#include "Scene.h"
#include "Terrain.h"
#include <osg/Geometry>
#include <osg/State>
#include <osg/ArrayDispatchers>
#include <osg/PrimitiveSet>
#include <osg/Shader>
#include <osg/Program>

#include <osg/ClearNode>
#include <osgViewer/Viewer>
#include <osg/GL>
#include <osgUtil/RenderStage>
#include <osg/PolygonOffset>
#include <osg/BlendFunc>
#include <osg/BlendEquation>
#include <osg/Depth>

#include <osg/Shader>
#include <osg/Vec3>
#include <osg/Matrix>

namespace osgCloudyDay
{
	/**
	 * NOT USED NOW
	 */
	class GrassLightCallback : public osg::NodeCallback
	{
	public:
		GrassLightCallback(void)
		{

		}

		virtual void operator()(osg::Node* node, osg::NodeVisitor* nv)
		{
			osgUtil::CullVisitor* cv = dynamic_cast<osgUtil::CullVisitor*>(nv);	   
			osg::ref_ptr<osg::Geode> geometry = dynamic_cast<osg::Geode*> (node);

			if(geometry && cv)
			{
				osg::Matrixd view(cv->getCurrentCamera()->getViewMatrix());
				osg::Matrixd invViewMatrix = osg::Matrixd::inverse(view);
				osg::Matrixd modelview(*cv->getModelViewMatrix());
				osg::Matrixd model = modelview*invViewMatrix;
				osg::Matrixd proj(cv->getCurrentCamera()->getProjectionMatrix());
		
				geometry->getOrCreateStateSet()->getUniform("ModelMatrix")->set(model);
				geometry->getOrCreateStateSet()->getUniform("ViewMatrix")->set(view);
				geometry->getOrCreateStateSet()->getUniform("ProjectionMatrix")->set(proj);		

				geometry->getOrCreateStateSet()->getUniform("light_mv_matrix")->set(osgCloudyDay::Scene::GetLightCamera()->getViewMatrix());		
		

	#ifdef SHADOW_MAPPING
				geometry->getOrCreateStateSet()->getUniform("light_proj_matrix")->set(osgCloudyDay::Scene::GetProjectionMatrix_Light());
				geometry->getOrCreateStateSet()->getUniform("light_mv_matrix")->set(osgCloudyDay::Scene::GetLightCamera()->getViewMatrix());
	#endif
			}
			traverse(node, nv);
		}
	};

	/**
	 * NOT USED NOW
	 */
	class Grass
	{
	public:
		Grass(void);
		~Grass(void);

		void Initialize(osgCloudyDay::TerrainConfig* m_config);

		static void CreateTexture();
		static void CreateShader();
		static void SetDefinitionOfTerrain(osg::Texture* definition);
		static void SetHeightofTerrain(osg::Texture* heightmap);

		static osg::ref_ptr<osg::Program> m_grassProg;
		static osg::ref_ptr<osg::Texture2D> tex_tree;
		static float* heightmap_data;
		static osg::Vec4* definition_data;
		static int heightmap_height;
		static int heightmap_width;

		osg::MatrixTransform* GetGeode();	
	
	protected:
		void SetArrays();	
		void SetUniforms(osg::ref_ptr<osg::StateSet> nodess4);

		osg::ref_ptr<osg::Geode> geode;
		osg::ref_ptr<osg::Geometry> geometry;
		osg::ref_ptr<osg::Vec3Array> m_vertices;
		osg::ref_ptr<osg::UIntArray> m_indices;	

		osg::ref_ptr<osg::MatrixTransform> trans;

	};
}