#pragma once
#include <osg/Vec3>
#include <osg/StateSet>

namespace osgCloudyDay
{
	/**
	 * Class to create a fog effect
	 */
	class Fog
	{
	public:
		/**
		 * Constructor: Initialize Fog with predefined values
		 */
		Fog(void);
		/*
		 * Standard deconstrutor
		 */
		~Fog(void);

		/**
		 * Returns the Fog density
		 * @return density of the fog
		 */
		float GetFogDensity();
		/**
		 * This method sets the density of the fog
		 * @param density density of the fog
		 */
		void SetFogDensity(float density);

		/**
		 * Returns the maximum height of the fog
		 * @return maximum height of the fog
		 */
		float GetFogHeight();
		/**
		 * This method sets the density of the fog
		 * @param height maximum height of the fog
		 */
		void SetFogHeight(float height);

		/**
		 * Returns the Fog color
		 * @return color of the fog
		 */
		osg::Vec3 GetFogColor();
		/**
		 * This method sets the density of the fog
		 * @param color color of the fog
		 */
		void SetFogColor(osg::Vec3 color);

		/**
		 * This method sets the uniforms of the geode
		 * @param states states of the geode
		 */
		void SetupUniform(osg::ref_ptr<osg::StateSet>& states);

	private:
		float m_fogdensity;
		float m_fogheight;
		osg::Vec3 m_fogcolor;
	};
}