#pragma once
#include "CloudGenerator.h"

namespace osgCloudyDay
{
	/**
	 * CloudGenerator, which manages the import/export of the cloud
	 */
	class DataCloud : public CloudGenerator
	{
	public:
		/**
		 * Standardconstructor
		 */
		DataCloud(osg::ref_ptr<osg::Vec3Array> vertices, osg::ref_ptr<osg::Vec4Array> rotation, osg::ref_ptr<osg::Vec4Array> color, osg::ref_ptr<osg::Vec4Array> center, osg::ref_ptr<osg::Vec4Array> ids, osg::ref_ptr<osg::Vec4Array> boxcenter);
		/**
		 * Standarddeconstructor
		 */
		~DataCloud(void);

	protected:
		/**
		 * Initialize creates the boxes and sprites which are needed to create a cloud.
		 */
		void Initialize();	

		/**
		 * Updates the cloud
		 */
		bool Update();

		osg::ref_ptr<osg::Vec3Array> vertices;
		osg::ref_ptr<osg::Vec4Array> rotation;
		osg::ref_ptr<osg::Vec4Array> color;
		osg::ref_ptr<osg::Vec4Array> center;
		osg::ref_ptr<osg::Vec4Array> ids;
		osg::ref_ptr<osg::Vec4Array> boxcenter;
	};
}