#pragma once
#include "CloudGenerator.h"

namespace osgCloudyDay
{
	/**
	 * Cumulous Generator: Generates static cumulous cloud
	 */
	class CumulusGenerator : public CloudGenerator
	{
	public:
		enum CumulusGeneratorType
		{
			CCT_HUMILIS,
			CCT_MEDIOCRIS,
			CCT_CONGESTUS
		};

	public:
		/**
		 * Standardconstructor
		 * @param color color of the cloud.
		 */
		CumulusGenerator(osg::Vec4 layer);
		/**
		 * Deconstructor
		 */
		~CumulusGenerator(void);

	protected:
		/**
		 * Initialize creates the boxes and sprites which are needed to create a Cumulus cloud.
		 */
		void Initialize();

		/**
		 * Updates the cloud
		 */
		bool Update();

		int m_type;
	};
}
