#pragma once
#include "CloudGenerator.h"

namespace osgCloudyDay
{
	/**
	 * Cumulonimbus Generator: Generates static cumulonimbus cloud
	 */
	class CumolonimbusGenerator : public CloudGenerator
	{
	public:
		/**
		 * Standardconstructor
		 * @param color color of the cloud.
		 */
		CumolonimbusGenerator(osg::Vec4 layer);

		/**
		 * Deconstructor
		 */
		~CumolonimbusGenerator(void);

	protected:
		/**
		 * Initialize creates the boxes and sprites which are needed to create a Cumulus cloud.
		 */
		void Initialize();

		/**
		 * Updates the cloud
		 */
		bool Update();

		int m_type;
	};
}