#pragma once
#include <osg/Vec3>
#include <osg/Array>
#include <osg/Geometry>
#include <osg/Geode>
#include <osg/FrameBufferObject>
#include <osg/Texture2D>
#include <osg/StateAttribute>

#include "Fog.h"
#include "SkydomeMie.h"

namespace osgCloudyDay
{
	/**
	 * NOT USED NOW
	 */
	class Contrail
	{
	public:
		Contrail(void);
		~Contrail(void);

		void Create(osg::Vec3 start, osg::Vec3 end);

		static void CreateShader();

		osg::Geode* contrail_obj;
		static osg::Texture2D* m_tex_contrail;
		static osg::Program* m_shader;

	private:
		osg::ref_ptr<osg::Vec3Array> m_vertices;
		osg::ref_ptr<osg::Vec4Array> m_additional;
		osg::ref_ptr<osg::IndexArray> m_indices;
		osg::ref_ptr<osg::Geometry> m_geometry;	

	public:
		static float timeOfDay;
		static float fading;
		static float dens;
		static osg::Vec3 ambientLight_h0;
		static osg::Vec3 ambientLight_h1;
		static osg::Vec3 ambientLight_t0;
		static osg::Vec3 ambientLight_t1;
		static osg::Matrix3 directionalColors;
		static float time;

		static osgCloudyDay::Skydome* m_skydome;
		static osgCloudyDay::Fog* m_fog;

		static osg::Vec3 sunLightColor;
		static osg::ref_ptr<osg::Texture2D> tex_clouds;
	
		static osg::FrameBufferObject* fbo_viewer;
		static osg::FrameBufferObject* fbo_light;

	};
}