#pragma once
#include "Create2DCloud.h"
#include "ObjectModel.h"
#include "Ground.h"
#include "HUD.h"
#include "Blur.h"
#include "PostProcess.h"
#include "LuminanceCalculation.h"
#include "AtmosphereMie.h"
#include "AtmosphereHimmel.h"
#include "TerrainMIE.h"
#include "TerrainHimmel.h"
#include "TerrainGeometry.h"
#include "ReflectionCamera.h"
#include "CloudCreator.h"
#include "Atmosphereprecompute.h"

#include "PerlinCloudState.h"
#include "CirrusCloudState.h"
#include "CirrusStratusCloudState.h"
#include "CirrusCumulusCloudState.h"
#include "AltStratusCloudState.h"

#include "Night.h"

#include "Fog.h"

#include "ObjCloud.h"
#include "DataCloud.h"

#include "Export.h"
#include "SkydomeMie.h"
#include "PerlinNoiseCloud.h"
#include "Cirrus.h"
#include "CirrusCumulus.h"
#include "CSGObject.h"
#include "Contrail.h"
#include "ContrailUpdate.h"
#include "LuminanceCalculation.h"

#include <osg/PolygonMode>
#include <osg/ShapeDrawable>
#include <osg/Depth>
#include <osg/Program>
#include <osg/Shader>
#include <osg/Uniform>

#include "Forest.h"
#include "Grass.h"

#include "Rain.h"

#include "BlurShadow.h"
#include "LightShaft.h"
#include "LightShaft2.h"

#define TERRAIN
#define ATMOSPHERE

namespace osgCloudyDay
{
	class PostDrawCallBack : public osg::Camera::DrawCallback
{
public:
	PostDrawCallBack(osgCloudyDay::CloudCreator*& cloudcreator) : m_cloudcreator(cloudcreator)
	{	
	}

	virtual void operator () (const osg::Camera& /*camera*/) const
	{
		m_cloudcreator->UpdateAddClouds();
	}

protected:
	osgCloudyDay::CloudCreator*& m_cloudcreator;
};

	

	class CloudyDay
	{
	public:
		CloudyDay(osgCloudyDay::TerrainConfig* config, bool add_rain=false, bool add_forest=false, bool add_grass=false, bool bloom=false, bool star=false);
		/**
		 * Deconstructor
		 */
		~CloudyDay(void); 

		void Initialize(int width, int size, osgCloudyDay::CloudState*& clouds, std::vector<osgCloudyDay::Cloud2DState> cloud2dstates, std::vector<int> m_ids, std::vector<std::string> reflection_models, std::vector<std::string> reflection_tex, osgCloudyDay::Fog* fog, std::vector<std::string> luds, RainState* rainstate);

		/**
		 * Returns the number of reflected objects
		 * @return reflected objects
		 */
		int GetNumberOfReflectionObjects();
		/**
		 * Return the camera for reflection objects
		 * @param id reflection object
		 * @return camera
		 */
		osg::Camera**& GetReflectionCamerasAt(int id);

		/**
		 * Update light position for clouds
		 */
		void UpdateLightForClouds();

		/**
		 * Return the camera for the HUD
		 * @return camera
		 */
		osg::ref_ptr<osg::Camera> GetHUD();
		/**
		 * Return the camera for horizontal glare & star blur
		 * @return camera
		 */
		osg::ref_ptr<osg::Camera> GetBlurProcess();
		/**
		 * Return the camera for vertical glare & star blur
		 * @return camera
		 */
		osg::ref_ptr<osg::Camera> GetBlur2Process();
		/**
		 * Return the camera for post-processing effect
		 * @return camera
		 */
		osg::ref_ptr<osg::Camera> GetPostProcess();

		osg::ref_ptr<osg::Node> GetObjectModel(int);
		//osg::ref_ptr<osg::Node> GetAtmosphere();
		//osg::ref_ptr<osg::Node> GetTerrain();

		static Scene* m_scene;
		
		/**
		 * Returns the camera from the light source
		 * @return camera from light soucxre
		 */
		osg::ref_ptr<osg::Camera> GetLightCamera();
		/**
		 * Returns the cloud camera
		 * @return camera for cloud
		 */
		osg::ref_ptr<osg::Camera> GetLightCloudCamera();
		/**
		 * Returns scene node
		 * @return scene node
		 */
		osg::ref_ptr<osg::Node> GetScene();
		/**
		 * Returns camera from viewer
		 * @return viewer camear
		 */
		osg::ref_ptr<osg::Camera> GetViewCamera();
		/**
		 * Returns camera from viewer
		 * @return viewer camear
		 */
		osg::ref_ptr<osg::Camera> GetViewCamera2();
		/**
		 * Returns camera from viewer (render depth)
		 * @return viewer camear
		 */
		osg::ref_ptr<osg::Camera> GetViewDepthCamera();

		static osgCloudyDay::LightShaft* m_lightshaft;
		/**
		 * Returns camera for lightshaft camera (Bruneton approach, maybe an error)
		 * @return camera
		 */
		static 	osg::ref_ptr<osg::Camera> GetLightshaftCamera();

		/**
		 * Create atmosphere object
		 */
		void CreateAtmosphere();	
		/**
		 * Create terrain object
		 */
		void CreateTerrain();

		/**
		 * Create night objects. Not used now. 
		 */
		void CreateNight();
		/**
		 * Create forst objects. Not used now. 
		 */
		void CreateForest();
		/**
		 * Create grasst objects. Not used now. 
		 */
		void CreateGrass();
		/**
		 * Create rain effect
		 * @param rainstate state of the rain effect
		 */
		void CreateRain(RainState* rainstate);
		/**
		 * Create 2D clouds
		 * @param cloud2dstates 2D cloud configuration
		 */
		void Create2DClouds(std::vector<osgCloudyDay::Cloud2DState> cloud2dstates);
		/**
		 * Create post-processing effects
		 * @param luds luds for color graining
		 * @param hdr_mapping hdr mapping algorithm
		 * @param use_avglum should the average luminance be calculated
		 */
		void CreatePostProcessing(std::vector<std::string> luds, int hdr_mapping, bool use_avglum);
		/**
		 * Create 3D clouds
		 * @param clouds 3D cloud configuration
		 */
		void CreateClouds(osgCloudyDay::CloudState*& clouds);
	
		/**
		 * Create luminance calcuation camera
		 * @return camera
		 */
		osg::ref_ptr<osg::Camera> GetLuminanceCalculation();
		/**
		 * Create camera for shadow map blurring
		 * @return camera
		 */
		osg::ref_ptr<osg::Camera> GetBlurShadowMapCamera();

		/**
		 * Should the bloom effect be calculated?
		 * @return true, if the bloom effect should be created
		 */
		bool UseBloom();
		/**
		 * Should the star effect be calculated?
		 * @return true, if the star effect should be created
		 */
		bool UseStar();

	protected:
		LightShaft2* m_lightshaft2;

		osgCloudyDay::AtmospherePrecompute* m_precompute;

		osgCloudyDay::CloudCreator* m_cloudcreator;	
		ObjectModel** m_object;
		osgCloudyDay::Atmosphere* m_atmopshere;
		osgCloudyDay::MyTerrain* m_terrain;	
	
		osg::ref_ptr<osg::Camera> camera_lightshaft;
		osg::ref_ptr<osg::Group> lightView_scene;

		osg::ref_ptr<osg::Group> scene;
		osg::ref_ptr<osg::Group> cube_scene;	
		osg::ref_ptr<osg::Group> hud;	

		ReflectionCamera** m_reflection;
		int num_reflections;

	
		osg::ref_ptr<osg::Texture2D> tex_ortho;		

		Ground* m_ground;
		Scene* my_scene;
		osg::ref_ptr<osg::Group> scene2;

		osgCloudyDay::HUD* m_hud;	
		osgCloudyDay::PostProcess* m_postprocess;
		osgCloudyDay::Blur* m_blur;	
		osgCloudyDay::Blur* m_blur2;	
		osgCloudyDay::LuminanceCalculation* m_luminance;

		osgCloudyDay::TerrainConfig* m_terrainconfig;

		osgCloudyDay::Rain* m_rain;
		Night* m_night;
		Forest* m_forrest;
		Grass* m_grass;
		bool m_add_forest;
		bool m_add_grass;
		bool m_add_rain;	
		bool m_bloom;
		bool m_star;

		osg::ref_ptr<osg::Geode> debug_geode;
		osg::ref_ptr<osg::Geode> debug_geode2;
		osg::ref_ptr<osg::Geode> debug_geode3;

		osgCloudyDay::Create2DCloud* m_create2dcloud;

		osgCloudyDay::Fog* m_fog;	
		osgCloudyDay::BlurShadow* blurShadow;
	};
}
