#pragma once
#include "cloudgenerator.h"

namespace osgCloudyDay
{
	/**
	 * This class creates a cloud resulting from a 3D model
	 */
	class CloudVoxel :	public CloudGenerator
	{
	public:
		/**
		 * Constructor to create a cloud, which looks like a watertight 3D model
		 * @param path path of the 3D model
		 * @param middlepos position of the cloud
		 * @param sx with of the volume
		 * @param sy height of the volume
		 * @param sz depth of the volume
		 * @param type type of the cloud
		 * @param color color of the cloud
		 */
		CloudVoxel(std::string path, osg::Vec3 middlepos, int sx, int sy, int sz, int type, osg::Vec4 color);

		/**
		 * Deconstructor
		 */
		~CloudVoxel(void);

	protected:
		/**
		 * Initialize creates the boxes and sprites which are needed to create a Cumulus cloud.
		 */
		void Initialize();	

		/**
		 * Updates the cloud
		 */
		bool Update();

		osg::Vec3 m_middlepos;
		std::string m_path;
		int m_type;

		int slicex;
		int slicey; 
		int slicez;
	};
}