#pragma once
#include <iostream>
#include <algorithm>
#include <string>
#include <vector>
#include <map>
#include <osg/Vec2>
#include <osg/Vec3>
#include <osg/Vec4>
#include <osg/Referenced>

namespace osgCloudyDay
{
	class CloudState
{
public:
	enum CloudState_Generation
	{
		CStG_Standard,
		CStG_Simulation,
		CStG_Voxel,
		CStG_Objs,
		CStG_Wang,
		CStG_XML
	};

	/**
	 * Constructor
	 */
	CloudState(void);

	/**
	 * Deconstructor
	 */
	~CloudState(void);
	
	/**
	 * Method to add a cloud
	 * @param type type of the cloud
	 * @param middlepoint position of the cloud
	 * @param size size of the cloud
	 * @param color color of the cloud
	 */
	void AddCloud(int type, osg::Vec3 middlepoint, osg::Vec3 size, osg::Vec4 color);
	/**
	 * Method to add a cloud
	 * @param type type of the cloud
	 * @param middlepoint position of the cloud
	 * @param size size of the cloud
	 * @param color color of the cloud
	 * @param gentype Generation type of the cloud
	 */
	void AddCloud(int type, std::string path, osg::Vec3 middlepoint, osg::Vec3 size, int gentype, osg::Vec4 color);

	/**
	 * Method returns the cloud type
	 * @return cloud type
	 */
	int GetCloudType(int at);

	/**
	 * Method returns the position of the cloud
	 * @return position of the cloud
	 */
	osg::Vec3 getMiddlePoint(int cloud_type);
	/**
	 * Method sets the position of the cloud
	 * @param cloud_type type of the cloud
	 * @param middlepoint position of the cloud
	 */
	void setMiddlePoint(int cloud_type, osg::Vec3 middlepoint);

	/**
	 * Method returns the size of the cloud
	 * @return size of the cloud
	 */
	osg::Vec3 getSize(int cloud_type);
	/**
	 * Method sets the size of the cloud
	 * @param cloud_type type of the cloud
	 * @param size size of the cloud
	 */
	void setSize(int cloud_type, osg::Vec3 size);

	/**
	 * Method returns the color of the cloud
	 * @return color of the cloud
	 */
	osg::Vec4 getColor(int cloud_type);
	/**
	 * Method color the size of the cloud
	 * @param cloud_type type of the cloud
	 * @param color color of the cloud
	 */
	void setColor(int cloud_type, osg::Vec4 size);

	/**
	 * Method returns the number of clouds
	 * @return number of clouds
	 */
	int GetNumberOfClouds();

	/**
	 * Returns the cloud generation method
	 * @param at cloud type
	 * @return cloud generation type
	 */
	int GetCloudGenerationType(int at);

	/**
	 * Returns the path
	 * @param at cloud type
	 * @return path to cloud
	 */
	std::string GetPath(int at);

private:	
	std::map<int, osg::Vec3> m_middlepoint;
	std::map<int, osg::Vec3> m_size;
	std::map<int, osg::Vec4> m_color;
	std::map<int, int> m_type;
	std::map<int, std::string> m_path;
	std::map<int, int> m_type_generation;
	int num_of_clouds;
};
}
