#pragma once
#include "Scene.h"
#include <osg/ref_ptr>
#include <osg/Geode>
#include <iostream>
#include <algorithm>

namespace osgCloudyDay
{
	class AABox 
	{

	public:
		osg::Vec3 corner;
		float x,y,z;

		AABox( osg::Vec3 &corner, float x, float y, float z);
		AABox(void);
		~AABox();

		void setBox( osg::Vec3 &corner, float x, float y, float z);

		// for use in frustum computations
		osg::Vec3 getVertexP(osg::Vec3 &normal);
		osg::Vec3 getVertexN(osg::Vec3 &normal);
	};



	class Plane  
	{

	public:
		osg::Vec3 normal,point;
		float d;

		Plane::Plane( osg::Vec3 &v1,  osg::Vec3 &v2,  osg::Vec3 &v3);
		Plane::Plane(void);
		Plane::~Plane();

		void set3Points( osg::Vec3 &v1,  osg::Vec3 &v2,  osg::Vec3 &v3);
		void setNormalAndPoint(osg::Vec3 &normal, osg::Vec3 &point);
		void setCoefficients(float a, float b, float c, float d);
		float distance(osg::Vec3 &p);
	};


	/**
	 * Class, which upadates the states of the clouds at runtime.
	 * Sorts the indices after the depth, add some clouds and so on.
	 */
	class CloudLayerUpdate : public osg::NodeCallback
	{
	public:
		/**
		 * Standardconstructor
		 */
		CloudLayerUpdate(void);
		/**
		 * Standarddeconstructor
		 */
		~CloudLayerUpdate(void);

		/**
		 * Update callback. Sorts the particle (before culling).
		 */
		virtual void operator()(osg::Node* node, osg::NodeVisitor* nv);
		/**
		 * Operator to sort the sprites within the cloud.
		 */
		bool operator() (unsigned short i,unsigned short j) 
		{ 
			return (depth[i]<depth[j]); 	
		};

		/**
		 * Helper array to sort the indices after depth
		 */
		float* depth;		

		/**
		 * Returns true, if a cloud is added in the last call of CloudLayerUpdate. Otherwise, false
		 * @return is a cloud added?
		 */
		bool CloudAdded();
		 
		osg::ref_ptr<osg::Geometry> bb_geo;		

	private:
		void setCamInternals(float angle, float ratio, float nearD, float farD);
		void SetCamDef(osg::Vec3 &p, osg::Vec3 &l, osg::Vec3 &u);
		int SphereInFrustum(osg::Vec3f p, float raio);
		int BoxInFrustum(osgCloudyDay::AABox &b);

		Plane pl[6];
		osg::Vec3 ntl,ntr,nbl,nbr,ftl,ftr,fbl,fbr;
		float nearD, farD, ratio, angle,tang;
		float nw,nh,fw,fh;


		unsigned int layerid;

		bool cloud_added;
		int iteration;	

		/**
		 * Method updates the shader
		 */
		void UpdateShader(osg::ref_ptr<osg::Geode> geode);
	};	
}