#pragma once
#include "Scene.h"

#include <osg/Geometry>
#include <osg/State>
#include <osg/ArrayDispatchers>
#include <osg/PrimitiveSet>
#include <osg/Shader>
#include <osg/Program>

#include <osg/ClearNode>
#include <osgViewer/Viewer>
#include <osg/GL>
#include <osgUtil/RenderStage>
#include <osg/PolygonOffset>
#include <osg/BlendFunc>
#include <osg/BlendEquation>
#include <osg/Depth>

#include <iostream>
#include <algorithm>

#define SHADOW_MAPPING
namespace osgCloudyDay 
{
	/**
	 * Cloud geometry class. Overloads the osg::Geometry class to render the 3D clouds
	 */
	class CloudGeometry : public osg::Geometry
	{
	public:
		/**
		 * Constructor
		 * @param _tex_clouds cloud texture
		 */
		CloudGeometry(  osg::ref_ptr<osg::Texture2D> _tex_clouds,
						osg::ref_ptr<osg::Texture2D> _fbo_light_texture,
						osg::ref_ptr<osg::Texture2D> _fbo_light_depth,
						osg::ref_ptr<osg::Texture2D> _fbo_blur_texture,
						osg::ref_ptr<osg::FrameBufferObject> _fbo_shadow,
						osg::ref_ptr<osg::FrameBufferObject> _fbo_vert_linear_blur,
						osg::ref_ptr<osg::FrameBufferObject> _fbo_hori_linear_blur,
						osg::ref_ptr<osg::FrameBufferObject> _fbo_hori_blur,
						osg::ref_ptr<osg::FrameBufferObject> _fbo_vert_blur,
						osg::ref_ptr<osg::FrameBufferObject> _fbo_cloud_viewer,
						osg::ref_ptr<osg::FrameBufferObject> _fbo_hori_blur2,
						osg::ref_ptr<osg::Program> viewer,
						osg::ref_ptr<osg::Program> light,
						osg::ref_ptr<osg::Program> blur_vert,
						osg::ref_ptr<osg::Program> blur_hori,
						osg::ref_ptr<osg::Program> blur_linear_vert,
						osg::ref_ptr<osg::Program> blur_linear_hori,
						osg::ref_ptr<osg::Program> shadow_map);
		~CloudGeometry(void);

		void AddLayer(int type);
		void AddPrimitive(int type);
		void SetActiveLayer(int layer);
		void DeletePrimitives();

		osg::ref_ptr<osg::FrameBufferObject> fbo_cloud_viewer;

		osg::ref_ptr<osg::Program> sh_viewer;
		osg::ref_ptr<osg::Program> sh_light;
		osg::ref_ptr<osg::Program> sh_blur_vert;
		osg::ref_ptr<osg::Program> sh_blur_hori;
		osg::ref_ptr<osg::Program> sh_blur_linear_vert;
		osg::ref_ptr<osg::Program> sh_blur_linear_hori;
		osg::ref_ptr<osg::Program> sh_shadow_map;

		osg::ref_ptr<osg::Texture2D> tex_clouds;
		osg::ref_ptr<osg::Texture2D> fbo_light_texture;
		osg::ref_ptr<osg::Texture2D> fbo_light_depth;
		osg::ref_ptr<osg::Texture2D> fbo_blur_texture;
		osg::ref_ptr<osg::FrameBufferObject> fbo_shadow;
		osg::ref_ptr<osg::FrameBufferObject> fbo_vert_linear_blur;
		osg::ref_ptr<osg::FrameBufferObject> fbo_hori_linear_blur;
		osg::ref_ptr<osg::FrameBufferObject> fbo_hori_blur;
		osg::ref_ptr<osg::FrameBufferObject> fbo_vert_blur;
		osg::ref_ptr<osg::FrameBufferObject> fbo_hori_blur2;

		osg::ref_ptr<osg::Uniform> projectuniform;
		osg::ref_ptr<osg::Uniform> modelViewMatrixuniform;
		osg::ref_ptr<osg::Uniform> viewMatrixuniform;
		osg::ref_ptr<osg::Uniform> viewMatrixInvuniform;

		osg::ref_ptr<osg::Uniform> project_lightuniform;
		osg::ref_ptr<osg::Uniform> modelViewMatrix_lightuniform;
		osg::ref_ptr<osg::Uniform> viewMatrix_lightuniform;
		osg::ref_ptr<osg::Uniform> viewMatrixInv_lightuniform;
		
		void Active(bool type);
		bool processing;
		std::vector<int> m_layers;

		bool m_slicingViewVectorTransformed;		

		unsigned int m_active_layer;

		osg::ref_ptr<osg::UIntArray> m_primitive2Layer;		

		osg::ref_ptr<osg::IntArray> m_numPrimitiveArrays;
		osg::ref_ptr<osg::IntArray> m_CloudsIterArrays;				

		virtual void CloudGeometry::drawImplementation(osg::RenderInfo& renderInfo) const;

		static bool blur;
	};
}