#pragma once
#include "Scene.h"
#include "Export.h"
#include "ImportClouds.h"
#include "WangCloud.h"
#include <osg/Vec2>

#define PI 3.14159265
inline float frand()
{
    return rand() / (float) RAND_MAX;
}

namespace osgCloudyDay
{
	/**
	 * This abstract class is used to create a cloud. 
	 * @author Michael Beham
	 **/
	class CloudGenerator
	{
	public:
		/**
		 * Standard constructor
		 */
		CloudGenerator(osg::Vec4 density);
		/**
		 * Standard deconstructor
		 */
		virtual ~CloudGenerator(void)=0;

		/**
		 * This method creates a cloud. 
		 */
		WangCloud* Create();

		/**
		 * This method creates a cloud. 
		 * @param middlepoint middlepoint of cloud layer
		 * @param size boundingboxsize of cloud layer
		 * @param numClouds Number of clouds
		 */
		WangCloud* Create(osg::Vec3 middlepoint);

		/**
		 * This method specifies the boxes and uses AddBox to define the Sprites
		 */
		virtual void Initialize() = 0;
		
		/**
		 * This method updates the cloud
		 */
		virtual bool Update() = 0;
	
		/**
		 * Method sets a billboard to inside/outside
		 */
		void DecideInsideOutside();

		/** 
		 * This method creates the sprites within the specified box.
		 * @param box_iter index of the box
		 * @param origin origin of the box
		 * @param sizes number of sprites which should be created
		 * @param cloud_size size of the box
		 * @param jitter_sizes defines the range of the jitter
		 * @param buttom is true, if the box is at the buttom
		 * @param s defines the size of the sprite (this size is used for width and height)
		 * @param min_max_scale defines the minium size maximum size
		 */
		void AddCloudBox(int box_iter, osg::Vec3 origin, osg::Vec3 sizes, osg::Vec3 cloud_size, osg::Vec3 jitter_sizes, bool buttom, float s, osg::Vec4 min_max_scale, osg::Vec4 density = osg::Vec4(1.0f,1.0f,1.0f,1.0f));

		/** 
		 * This method creates the sprites within the specified box.
		 * @param volume control polygon
		 * @param box_iter index of the box
		 * @param origin origin of the box
		 * @param sizes number of sprites which should be created
		 * @param cloud_size size of the box
		 * @param jitter_sizes defines the range of the jitter
		 * @param buttom is true, if the box is at the buttom
		 * @param s defines the size of the sprite (this size is used for width and height)
		 * @param min_max_scale defines the minium size maximum size
		 */
		void AddCloudBox(CloudCreateVolume* volume, int box_iter,  osg::Vec3 origin, osg::Vec3 sizes, osg::Vec3 cloud_size, osg::Vec3 jitter_sizes, bool buttom, osg::Vec4 density = osg::Vec4(1.0f,1.0f,1.0f,1.0f));
	
		/**
		 * This method reject redundant sprites (sprites which are too close to other sprites).
		 */
		void EliminateRedudantSprites();
	
		/**
		 * This method creates a box, which is used for debugging and creating of a cloud
		 */
		void AddBox(osg::ref_ptr<osg::Vec3Array> box_triangles, osg::Vec3 posHelper, osg::Vec3 size);

		/**
		 * This method exports the clouds
		 */
		static void DoExport();

		static Export* ex;
		static int numClouds;
		WangCloud* m_cloud;	

		osg::ref_ptr<osg::Geode> dBoxes;
	protected:	
		static float* m_frands;
		/**
		 * Generate the random numbers
		 */
		static void GenerateRandomNumber();
		/**
		 * Returns a random number
		 * @return random number
		 */
		static float GetRandomFloat();
		static int m_iterFloatRand;

		osg::ref_ptr<osg::Vec3Array> dBoxes_vertices;
		std::vector<unsigned short> dBoxes_indices;
		osg::ref_ptr<osg::Geometry> dBoxes_geometry;
	
		int m_category;

		osg::Vec3 m_middlepoint;
		osg::Vec4 m_density;
	};
}