#pragma once
#include "cloudgenerator.h"
#include <osg/BoundingBox>
#include <vector>
#include <iostream>
#include <string>

namespace osgCloudyDay
{
	/**
	 * Class, which travese the mesh
	 */
	class  TraverseMesh : public osg::NodeVisitor 
{
public:
	/**
	 * Constructor
	 */
     TraverseMesh() : NodeVisitor( NodeVisitor::TRAVERSE_ALL_CHILDREN ) 
	 {
		 // ----------------------------------------------------------------------
		 //
		 //     Default Public Class Constructor
		 //
		 // ----------------------------------------------------------------------
         m_transformMatrix.makeIdentity();
    }

	 /**
	  * Deconstructor
	  */
    virtual ~TraverseMesh() {}
	
	/**
	 * apply, if node is geode
	 * @param geode
	 */
    virtual void apply( osg::Geode &geode ) 
	{
		// -------------------------------------------
		//
		//   Handle nodes of the type osg::Geode
		//
		// -------------------------------------------        
       
        //
        // update bounding box for each drawable
        //
        for(  unsigned int i = 0; i < geode.getNumDrawables(); ++i )
		{           

            osg::BoundingBox bbox;
            bbox.expandBy( geode.getDrawable( i )->getBound());


			//
			// transform corners by current matrix
			//
			osg::BoundingBox bboxTrans;
			for( unsigned int i = 0; i < 8; ++i ) 
			{      
				osg::Vec3 xvec = bbox.corner( i ) * m_transformMatrix;
				bboxTrans.expandBy( xvec );				
			}			

			m_boundingBox.push_back(bboxTrans);
        }        

        //
        // update the overall bounding box size
        //
        //m_boundingBox.expandBy( bboxTrans ); 

        //
        // continue traversing through the graph
        //
	    traverse( geode );
       
    } // ::apply(osg::Geode &geode)
     
	/**
	 * apply, if node is a matrix transformation
	 */
    virtual  void apply( osg::MatrixTransform &node ) 
	{
		// ---------------------------------------------------------
		//
		//   Handle nodes of the type osg::MatrixTransform
		//
		// ---------------------------------------------------------
		m_transformMatrix *= node.getMatrix(); 
        
		//
        // continue traversing through the graph
        //
        traverse( node ); 

	} // ::apply(osg::MatrixTransform &node)

	/**
	 * apply, if node is a billboard node
	 */
    virtual void apply( osg::Billboard &node )
	{
		// -----------------------------------------------
		//
		//    Handle nodes of the type osg::Billboard
		//
		// -----------------------------------------------

        //
        // important to handle billboard so that its size will
        // not affect the geode size continue traversing the graph
        //
        traverse( node );
    } // ::apply(osg::MatrixTransform &node)

    
	//
    // return teh bounding box     
    //
    std::vector<osg::BoundingBox> &getBoundBox() { return m_boundingBox; }  
	
protected :
    std::vector<osg::BoundingBox> m_boundingBox;          // the overall resultant bounding box
    osg::Matrix      m_transformMatrix;      // the current transform matrix 

};  // class  CcalculateBoundingBox
	
	/**
	Class which creates a cloud layer. It implements the approach from Wang.
	*/
	class CloudCreatorWang :	public CloudGenerator
	{
	public:
		/**
		 * Constructor
		 * @param path path to the 3d model
		 * @param middlepos position of the cloud layer
		 * @param type type of the cloud layer
		 * @param color color of the cloud layer
		 */
		CloudCreatorWang(std::string path, osg::Vec3 middlepos, int type, osg::Vec4 color);
		/**
		 * Deconstructor
		 */
		~CloudCreatorWang(void);

	protected:
		/**
		 * Initialize creates the boxes and sprites which are needed to create a Cumulus cloud.
		 */
		void Initialize();

		/**
		 * Updates the cloud
		 */
		bool Update();

		osg::Vec3 m_middlepos;

		int m_type;
		std::string m_path;
	};
}