#pragma once
#include "Scene.h"
#include "CloudLayerState.h"
#include "CelluarAutomataGenerator.h"
#include "CloudState.h"
#include "CumulusGenerator.h"
#include "StratusGenerator.h"
#include "NimbostratusGenerator.h"
#include "CumolonimbusGenerator.h"
#include "StratoCumulusGenerator.h"
#include "AltCumulusGenerator.h"
#include "AltStratusGenerator.h"
#include "CloudScene.h"
#include "CloudCreateVolume.h"
#include "CloudCreatorWang.h"
#include "CloudVoxel.h"

namespace osgCloudyDay
{
	class CullDebugGeometryCallback : public osg::NodeCallback
{
	public:
	CullDebugGeometryCallback(void)
	{

	}

	virtual void operator()(osg::Node* node, osg::NodeVisitor* nv)
	{
		osgUtil::CullVisitor* cv = dynamic_cast<osgUtil::CullVisitor*>(nv);	   
		osg::ref_ptr<osg::Geode> geometry = dynamic_cast<osg::Geode*> (node);

		if(geometry && cv)
		{
			//geometry->getOrCreateStateSet()->getUniform("ModelMatrix")->set(model);
			geometry->getOrCreateStateSet()->getUniform("viewMatrix")->set(Scene::GetViewMatrix_View());
			geometry->getOrCreateStateSet()->getUniform("viewMatrixInv")->set(osg::Matrix::inverse(Scene::GetViewMatrix_View()));
			geometry->getOrCreateStateSet()->getUniform("project")->set(Scene::GetProjectionMatrix_View());		

#ifdef SHADOW_MAPPING
			geometry->getOrCreateStateSet()->getUniform("project_light")->set(Scene::GetProjectionMatrix_Light());
			geometry->getOrCreateStateSet()->getUniform("inv_project_light")->set(osg::Matrix::inverse(Scene::GetProjectionMatrix_Light()));
			geometry->getOrCreateStateSet()->getUniform("viewMatrix_light")->set(Scene::GetLightCamera()->getViewMatrix());
			geometry->getOrCreateStateSet()->getUniform("viewMatrixInv_light")->set(osg::Matrix::inverse(Scene::GetLightCamera()->getViewMatrix()));
			geometry->getOrCreateStateSet()->getUniform("modelViewMatrix_light")->set(Scene::GetLightCamera()->getViewMatrix());
#endif
			geometry->getOrCreateStateSet()->addUniform(new osg::Uniform("color_tex", 0));
			geometry->getOrCreateStateSet()->addUniform(new osg::Uniform("shadow_tex", 1));
			geometry->getOrCreateStateSet()->addUniform(new osg::Uniform("depth_tex", 2));

			geometry->getOrCreateStateSet()->setTextureAttribute( 0, osgCloudyDay::CloudScene::tex_clouds );
			geometry->getOrCreateStateSet()->setTextureAttribute( 1, Scene::GetBlurTexture());
			geometry->getOrCreateStateSet()->setTextureAttribute( 2, Scene::GetShadowDepthTexture() );
		}

		traverse(node, nv);
		
		//Scene::GetViewCamera()->setViewMatrix(Scene::GetViewDepthCamera()->getViewMatrix());
		//Scene::GetViewCamera()->setProjectionMatrix(Scene::GetViewDepthCamera()->getProjectionMatrix());
	}

};

	class DebugGeometry : public osg::Geometry
	{
	public:
		DebugGeometry()
		{
		}

		~DebugGeometry()
		{

		}

		void drawImplementation(osg::RenderInfo& renderInfo) const
		{	
			if (_internalOptimizedGeometry.valid())
			{
				_internalOptimizedGeometry->drawImplementation(renderInfo);
				return;
			}

			osg::State& state = *renderInfo.getState();

			bool checkForGLErrors = state.getCheckForGLErrors()==osg::State::ONCE_PER_ATTRIBUTE;
			if (checkForGLErrors) state.checkGLErrors("start of Geometry::drawImplementation()");
    
			bool useFastPath = areFastPathsUsed();
			// useFastPath = false;

			bool usingVertexBufferObjects = _useVertexBufferObjects && state.isVertexBufferObjectSupported();
			bool handleVertexAttributes = !_vertexAttribList.empty();

			osg::ArrayDispatchers& arrayDispatchers = state.getArrayDispatchers();

			arrayDispatchers.reset();
			arrayDispatchers.setUseVertexAttribAlias(useFastPath && state.getUseVertexAttributeAliasing());
			arrayDispatchers.setUseGLBeginEndAdapter(!useFastPath);

			arrayDispatchers.activateNormalArray(_normalData.binding, _normalData.array.get(), _normalData.indices.get());
			arrayDispatchers.activateColorArray(_colorData.binding, _colorData.array.get(), _colorData.indices.get());
			arrayDispatchers.activateSecondaryColorArray(_secondaryColorData.binding, _secondaryColorData.array.get(), _secondaryColorData.indices.get());
			arrayDispatchers.activateFogCoordArray(_fogCoordData.binding, _fogCoordData.array.get(), _fogCoordData.indices.get());

			if (handleVertexAttributes)
			{
				for(unsigned int unit=0;unit<_vertexAttribList.size();++unit)
				{
					arrayDispatchers.activateVertexAttribArray(_vertexAttribList[unit].binding, unit, _vertexAttribList[unit].array.get(), _vertexAttribList[unit].indices.get());
				}
			}

			// dispatch any attributes that are bound overall
			arrayDispatchers.dispatch(BIND_OVERALL,0);

			state.lazyDisablingOfVertexAttributes();

			if (useFastPath)
			{
				// set up arrays
				if( _vertexData.array.valid() )
					state.setVertexPointer(_vertexData.array.get());

				if (_normalData.binding==BIND_PER_VERTEX && _normalData.array.valid())
					state.setNormalPointer(_normalData.array.get());

				if (_colorData.binding==BIND_PER_VERTEX && _colorData.array.valid())
					state.setColorPointer(_colorData.array.get());

				if (_secondaryColorData.binding==BIND_PER_VERTEX && _secondaryColorData.array.valid())
					state.setSecondaryColorPointer(_secondaryColorData.array.get());

				if (_fogCoordData.binding==BIND_PER_VERTEX && _fogCoordData.array.valid())
					state.setFogCoordPointer(_fogCoordData.array.get());

				for(unsigned int unit=0;unit<_texCoordList.size();++unit)
				{
					const osg::Array* array = _texCoordList[unit].array.get();
					if (array) state.setTexCoordPointer(unit,array);
				}

				if( handleVertexAttributes )
				{
					for(unsigned int index = 0; index < _vertexAttribList.size(); ++index )
					{
						const osg::Array* array = _vertexAttribList[index].array.get();
						const AttributeBinding ab = _vertexAttribList[index].binding;
						if( ab == BIND_PER_VERTEX && array )
						{
							state.setVertexAttribPointer( index, array, _vertexAttribList[index].normalize );
						}
					}
				}
			}
			else
			{
				for(unsigned int unit=0;unit<_texCoordList.size();++unit)
				{
					arrayDispatchers.activateTexCoordArray(BIND_PER_VERTEX, unit, _texCoordList[unit].array.get(), _texCoordList[unit].indices.get());
				}

				arrayDispatchers.activateVertexArray(BIND_PER_VERTEX, _vertexData.array.get(), _vertexData.indices.get());
			}

			state.applyDisablingOfVertexAttributes();

			bool bindPerPrimitiveSetActive = arrayDispatchers.active(BIND_PER_PRIMITIVE_SET);
			bool bindPerPrimitiveActive = arrayDispatchers.active(BIND_PER_PRIMITIVE);			

			if (checkForGLErrors) state.checkGLErrors("Geometry::drawImplementation() after vertex arrays setup.");

			
			///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			//
			// draw the primitives themselves.
			//	
					
			for(unsigned int primitiveSetNum=0; primitiveSetNum!= _primitives.size() ; ++primitiveSetNum)
			{				
				// dispatch any attributes that are bound per primitive
				if (bindPerPrimitiveSetActive) 				
					arrayDispatchers.dispatch(BIND_PER_PRIMITIVE_SET, primitiveSetNum);
				
				const osg::PrimitiveSet* primitiveset = _primitives[primitiveSetNum].get();									
												
				//glDisable(GL_BLEND);
				//glDisable(GL_DEPTH_TEST);								
				//glDisable(GL_CULL_FACE);

				osg::State& state = *renderInfo.getState();				

				//osg::Depth* depth2 = new osg::Depth(osg::Depth::ALWAYS, 0.0, 1.0, false);	//MIT DEPTH => FEHLER	
				//depth2->apply(state);
						
				//sh_blur_linear_vert1->apply(state);
				//state.applyTextureAttribute(0, Scene::fbo_glare_texture);
				//Scene::fbo_V1_blur->apply(state, osg::FrameBufferObject::READ_DRAW_FRAMEBUFFER);								
				primitiveset->draw(state, usingVertexBufferObjects);				

				
			}

			// unbind the VBO's if any are used.
			state.unbindVertexBufferObject();
			state.unbindElementBufferObject();
	
			if (checkForGLErrors) state.checkGLErrors("end of Geometry::drawImplementation().");
		}
	};

	/**
	 * This class creates the 3D clouds.
	 */
	class CloudCreator
	{
	public:
		/**
		 * Constructor
		 * @param scene scene object
		 */
		CloudCreator(osg::ref_ptr<osg::Group>& scene);
		/**
		 * Deconstructor
		 */
		~CloudCreator(void);

		/**
		 * Returns the cloud scene node
		 * @return cloud scene
		 */
		osgCloudyDay::CloudScene*& GetCloudScene();

		/**
		 * This method initialize the 3D clouds
		 * @param clouds cloud configuration
		 * @param fog fog
		 */
		void Initialize(CloudState* clouds, Fog* fog);
		/**
		 * This method returns the boxes
		 * @return group with all debug boxes
		 */
		osg::Group* GetDebugBoxes();	

		/**
		 * This method updates the cloud and add a cloud
		 */
		void UpdateAddClouds();

		void CreateDummyObjectForShader(osg::ref_ptr<osg::Group> root);

	protected:
		CloudScene* m_cloudscene;
		osg::ref_ptr<osg::Group> cloud;
		osg::ref_ptr<osg::Group> scene;

		osg::ref_ptr<osg::Program> debugProg;
		osg::ref_ptr<osg::Group> nodes_debug;
	};
}