#pragma once
#include <map>
#include <stdlib.h>
#include <algorithm>
#include <osg/Vec3>
#include <osg/Vec2>

namespace osgCloudyDay
{
	/**
	 * Class to configure a 2D cloud
	 */
	class Cloud2DState
	{
	public:
		enum Cloud2D_Type
		{
			C2DT_Perlin,
			C2DT_Cirrus,
			C2DT_CirrusStratus,
			C2DT_CirrusCumulus,
			C2DT_AltStratus
		};

	public:
		/**
		 * Constructor to create a new 2D cloud
		 * @param cat catogory of 2D cloud 
		 */
		Cloud2DState(int cat);
		/**
		 * Deconstructor
		 */
		~Cloud2DState(void);

		/**
		 * Returns the positon of the 2D cloud
		 * @return position of the 2D cloud
		 */
		osg::Vec3 getMiddlePoint();
		/**
		 * Set the position of the 2D cloud
		 * @param middlepoint position of the cloud
		 */
		void setMiddlePoint(osg::Vec3 middlepoint);

		/**
		 * Returns the size of the 2D cloud
		 * @return size of the 2D cloud
		 */
		osg::Vec2 getSize();
		/**
		 * Set the positsizeion of the 2D cloud
		 * @param size size of the cloud
		 */
		void setSize(osg::Vec2 size);

		/**
		 * Returns the category of the 2D cloud
		 * @return category of the 2D cloud
		 */
		int GetCategory();

	protected:
		osg::Vec3 m_middlepoint;
		osg::Vec2 m_size;
		int m_type;
	};
}