#pragma once
#include "Scene.h"
#include <osg/Geometry>
#include <osg/Geode>
#include <osg/Texture2D>
#include <osg/Image>
#include <osgUtil/SmoothingVisitor>
#include <osgUtil/TangentSpaceGenerator>
#include <osg/BlendFunc>
#include <osgDB/ReadFile>

#define PI 3.14159265

namespace osgCloudyDay
{
	/**
	 * Parent class to create a 2D cloud
	 * Provides methods, which are needed to create a 2D cloud (like normal map creation
	 */
	class Cloud2D
	{
	public:
		/**
		 * Constructor to crate 2D clouds
		 */
		Cloud2D();
		/**
		 * Deconstructor
		 */
		~Cloud2D();

		/**
		 * Setup the geometry to render
		 */
		void Cloud2D::SetGeometry();
		/**
		 * Setup the geometry  to render
		 * @param position position of the 2D cloud
		 * @param size size of the 2D cloud
		 */
		void Cloud2D::SetGeometry(osg::Vec3 position, osg::Vec2 size);

		/**
		 * Create the 2D cloud
		 * @param geode geode of the 2D cloud
		 * @param perlinImg texture of the 2D cloud
		 */
		void Cloud2D::Create(osg::Geode* geode, osg::Image* perlinImg);
		/**
		 * Create the 2D cloud
		 * @param geode geode of the 2D cloud
		 * @param perlinImg texture of the 2D cloud
		 * @param perlinNormalImg normal of the 2D cloud
		 */
		void Create(osg::Geode* geode, osg::Image* perlinImg, osg::Image* perlinNormalImg);	
		/**
		 * Create textures
		 * @param geode geode of the 2D cloud
		 * @param perlinImg texture of the 2D cloud
		 * @param perlinNormalImg normal of the 2D cloud
		 * @param perlinHeightImg height texture of the 2D cloud
		 */
		void Create(osg::Geode* geode, osg::Image* perlinImg, osg::Image* perlinNormalImg, osg::Image* perlinHeightImg);

		/**
		 * Method to creat the Normal map using a Sobel filter
		 * @param img texture
		 * @return normal texture
		 */
		osg::Image* CreateNormalMap(osg::Image* img);

		/**
		 * Creates the geometry to render the 2D cloud
		 * @param position position of the 2D cloud
		 * @param size size of the 2D cloud
		 * @param vertices vertices array
		 * @param tcoords texture coordinates array
		 * @param indices indices array
		 */
		virtual void SetupGeometry(osg::Vec3 position, osg::Vec2 size, osg::Vec3Array* vertices, osg::Vec2Array* tcoords, osg::UIntArray* indices) = 0;

	public:
		osg::Geometry* geom;
		osg::Geode* geode;

		osg::Node* terrain_obj;
		bool m_tesselation;

	protected:
		osg::Vec3Array* coords;		
		osg::Vec2Array* tcoords;
		osg::UIntArray* indices;		
	};
}