#pragma once
#include <GL/glew.h>
#include <carve/interpolator.hpp>
#include <carve/csg_triangulator.hpp>

#include <osg/Vec2>
#include <osg/Vec3>

#include <osg/Geometry>
#include <osg/PrimitiveSet>

struct tex_t {
	  float u;
	  float v;

	  tex_t() : u(0.0f), v(0.0f) { }
	  tex_t(float _u, float _v) : u(_u), v(_v) { }
	};

namespace osgCloudyDay
{
	/**
	 * Class for creation the bounding spheres of a cloud
	 */
	class CSGObject
	{
	public:
		enum CSGOperation{
			CSG_MERGE,
			CSG_UNION,
			CSG_INTERSECT,
			CSG_A_MINUS_B,
			CSG_B_MINUS_A
		};

	public:
		/**
		 * Constructor
		 */
		CSGObject(void);
		/**
		 * Deconstructor
		 */
		~CSGObject(void);

		osg::ref_ptr<osg::Geometry> Perform(osg::Geometry* m1, osg::Geometry* m2, unsigned int operation);
		osg::ref_ptr<osg::Geometry> Perform(osg::ref_ptr<osg::Geometry> m1, std::vector<osg::ref_ptr<osg::Geometry>> m2, unsigned int operation);

		carve::mesh::MeshSet<3> *texturedCube(	carve::interpolate::FaceVertexAttr<tex_t> &fv_tex,
												carve::interpolate::FaceAttr<GLuint> &f_tex_num,
												const carve::math::Matrix &transform = carve::math::Matrix::IDENT());

		osg::Geometry* TestScene();
	
		carve::mesh::MeshSet<3>* SetGeometry(osg::Geometry *mesh);	
		osg::ref_ptr<osg::Geometry> GetGeometry(carve::mesh::MeshSet<3> *mesh);	
	};
}
