#pragma once
#include "hud.h"

namespace osgCloudyDay
{
	/**
	 * Blur class for glare effect. This class has to create 2 times. First, for horicontal blur, than for vertical blur.
	 */
	class Blur : public osgCloudyDay::HUD
	{
	public:
		/**
		 * Constructor
		 * @param renderorder Render order of the camera.
		 */
		Blur(int renderorder);
		/**
		 * Deconstructor
		 */
		~Blur(void);

		/**
		 * Method to set the uniforms of the geode
		 * @param states States of the geode
		 */
		virtual void SetupUniform(osg::ref_ptr<osg::StateSet> states);
		/**
		 * Method to set the textures of the geode
		 * @param states States of the geode
		 */
		virtual void SetupTextures(osg::ref_ptr<osg::StateSet> states);
		/**
		 * Method to create the camera
		 */
		virtual void CreateCamera();
	};
}