#pragma once
#include "cloud2d.h"

namespace osgCloudyDay
{
	/**
	 * Class to create a 2D alt-stratus cloud layer
	 */
	class AltStratus : public osgCloudyDay::Cloud2D
	{
	public:
		/**
		* Constructor
		* @param position middlepoint of the geometry
		* @param size size of the geometry
		*/
		AltStratus(osg::Vec3 position, osg::Vec2 size);
		/**
		* Deconstructor
		*/
		~AltStratus(void);

		/**
		* Sets the texture to the cloud and creates the geometry
		* @param position middlepoint of the geometry
		* @param size size of the geometry
		*/
		void Initialize(osg::Vec3 position, osg::Vec2 size);

		/**
		 * Method, which creates the geometry
		 * @param position middlepoint of the geometry
		 * @param size size of the geometry
		 * @param vertices Vertices array of the geoemtry
		 * @param texcoords Texture coordinates array of the geoemtry
		 * @param indices Indices array of the geoemtry		 
		 */
		virtual void SetupGeometry(osg::Vec3 position, osg::Vec2 size, osg::Vec3Array* vertices, osg::Vec2Array* texcoords, osg::UIntArray* indices);
	};
}