#pragma once
#include "CloudGenerator.h"

namespace osgCloudyDay
{
	/**
	 * Alt Cumulus Generator: Generates static  alt cumulus cloud
	 */
	class AltCumulusGenerator : public CloudGenerator
	{
	public:
		/**
		 * Standardconstructor
		 * @param color color of the cloud.
		 */
		AltCumulusGenerator(osg::Vec4 color);
		/**
		 * Standarddeconstructor
		 */
		~AltCumulusGenerator(void);

	protected:
		/**
		 * Initialize creates the boxes and sprites which are needed to create a Stratus Cumulus cloud.
		 */
		void Initialize();

		/**
		 * Updates the cloud
		 */
		bool Update();
	};
}