﻿#include <GL/glew.h>
#include "CloudyDay.h"

#include <osgViewer/Viewer>
#include <osgViewer/Renderer>

#include <osg/ShapeDrawable>
#include <osgViewer/ViewerEventHandlers>
#include <osgDB/ReadFile>
#include <osgGA/StateSetManipulator>
#include <osg/Program>
#include <osg/PolygonMode>
#include <osg/Notify>
#include <osg/ref_ptr>
#include <osg/Geode>
#include <osg/Geometry>
#include <osg/Point>
#include <osg/Vec3>
#include <osg/Vec4>
#include <osg/BlendFunc>
#include <osg/Depth>
#include <osgViewer/Viewer>
#include <osg/MatrixTransform>
#include <osg/CullFace>
#include <osg/TextureCubeMap>
#include <osg/BlendEquation>
#include <osgGA/TrackballManipulator>

#include <iostream>
#include <algorithm>

osgCloudyDay::CloudyDay* my_scene;

bool project=false;
osg::Matrix oldMatrix;

osg::Vec2f sincosPos = osg::Vec2(0.f, 0.f);
class KeyboardEventHandler : public osgGA::GUIEventHandler
{
public:
	KeyboardEventHandler(osg::StateSet* stateset) //:	_stateset(stateset)
	{		
	}
    
    virtual bool handle(const osgGA::GUIEventAdapter& ea,osgGA::GUIActionAdapter&)
    {
		osg::Matrix RotX1;
		osg::Matrix RotX2;
		osg::Matrix RotY1;
		osg::Matrix RotY2;
		
		RotX1.makeRotate( 0.025f, osg::Vec3f(1.f, 0.f, 0.f));		
		RotX2.makeRotate(-0.025f, osg::Vec3f(1.f, 0.f, 0.f));
		RotY1.makeRotate( 0.025f, osg::Vec3f(0.f, 1.f, 0.f));		
		RotY2.makeRotate(-0.025f, osg::Vec3f(0.f, 1.f, 0.f));

		int helperkey=-1;
		switch(ea.getEventType())
        {
			case(osgGA::GUIEventAdapter::KEYDOWN):
            {
				float b = 0.5f/180.f*3.147f;


				switch(ea.getKey())
				{
				case 'n': 		
					/*
					std::cout << "load n" << std::endl;
					for(int i = 0; i < lightningProg->getNumShaders(); i++)
					{
						if(lightningProg->getShader(i)->getType() == osg::Shader::VERTEX)
						{
							osg::Shader* shader = lightningProg->getShader(i);
							osg::Shader* shad_n = osg::Shader::readShaderFile(osg::Shader::VERTEX, "shaders/lighting.vert");
							shader->setShaderSource(shad_n->getShaderSource());
							shader->dirtyShader();
						}
					}*/
					break;
				case 'm': 										
					/*
					std::cout << "load m" << std::endl;
										
					for(int i = 0; i < lightningProg->getNumShaders(); i++)
					{
						if(lightningProg->getShader(i)->getType() == osg::Shader::FRAGMENT)
						{
							osg::Shader* shader = lightningProg->getShader(i);
							osg::Shader* shad_n = osg::Shader::readShaderFile(osg::Shader::FRAGMENT, "shaders/lighting.frag");
							shader->setShaderSource(shad_n->getShaderSource());
							shader->dirtyShader();
						}
					}*/
					break;
				case 'e': 					
					/*
					for(int i = 0; i < osgCloudyDay::CloudScene::cloudProg->getNumShaders(); i++)
					{
						if(CloudScene::cloudProg->getShader(i)->getType() == osg::Shader::VERTEX)
						{
							osg::Shader* shader = osgCloudyDay::CloudScene::cloudProg->getShader(i);
							osg::Shader* shad_n = osg::Shader::readShaderFile(osg::Shader::VERTEX, "shaders/cloud.vert");
							shader->setShaderSource(shad_n->getShaderSource());
							shader->dirtyShader();
						}
					}*/
					break;
				case 'r': 
					/*
					for(int i = 0; i < osgCloudyDay::CloudScene::cloudProg->getNumShaders(); i++)
					{
						if(CloudScene::cloudProg->getShader(i)->getType() == osg::Shader::GEOMETRY)
						{
							osg::Shader* shader = osgCloudyDay::CloudScene::cloudProg->getShader(i);
							osg::Shader* shad_n = osg::Shader::readShaderFile(osg::Shader::GEOMETRY, "shaders/cloud.geom");
							shader->setShaderSource(shad_n->getShaderSource());
							shader->dirtyShader();
						}
					}
					*/
					/*/
					std::cout << "load r" << std::endl;
					for(int i = 0; i < mieTerrainProg->getNumShaders(); i++)
					{
						if(mieTerrainProg->getShader(i)->getType() == osg::Shader::VERTEX)
						{
							osg::Shader* shader = mieTerrainProg->getShader(i);
							osg::Shader* shad_n = osg::Shader::readShaderFile(osg::Shader::VERTEX, "shaders/lightingMie.vert");
							shader->setShaderSource(shad_n->getShaderSource());
							shader->dirtyShader();
						}
					}//*/
					break;
				case 't': 										
					std::cout << "load t" << std::endl;
					
					/*for(int i = 0; i < mieTerrainProg->getNumShaders(); i++)
					{
					
						if(mieTerrainProg->getShader(i)->getType() == osg::Shader::FRAGMENT)
						{
							osg::Shader* shader = mieTerrainProg->getShader(i);
							osg::Shader* shad_n = osg::Shader::readShaderFile(osg::Shader::FRAGMENT, "shaders/lightingMie.frag");
							shader->setShaderSource(shad_n->getShaderSource());
							shader->dirtyShader();
						}
					}
					/*/
					/*for(int i = 0; i < osgCloudyDay::CloudScene::cloudProg->getNumShaders(); i++)
					{
						if(CloudScene::cloudProg->getShader(i)->getType() == osg::Shader::FRAGMENT)
						{
							osg::Shader* shader = osgCloudyDay::CloudScene::cloudProg->getShader(i);
							osg::Shader* shad_n = osg::Shader::readShaderFile(osg::Shader::FRAGMENT, "shaders/cloud.frag");
							shader->setShaderSource(shad_n->getShaderSource());
							shader->dirtyShader();
						}
					}//*/
					break;
				case 'j' :						
					//Scene::GetLightCamera()->getViewMatrix() = RotX1 * Scene::GetLightCamera()->getViewMatrix();
					//Scene::GetCloudCamera()->getViewMatrix() = Scene::GetLightCamera()->getViewMatrix();
					helperkey=1; sincosPos.x() += b;						
					break;				
				case 'l' :	
					//Scene::GetLightCamera()->getViewMatrix() = RotX2 * Scene::GetLightCamera()->getViewMatrix();
					//Scene::GetCloudCamera()->getViewMatrix() = Scene::GetLightCamera()->getViewMatrix();
					helperkey=2; sincosPos.x() -= b;
					break;
				case 'k' :	
					//Scene::GetLightCamera()->getViewMatrix() = RotY1 * Scene::GetLightCamera()->getViewMatrix();
					//Scene::GetCloudCamera()->getViewMatrix() = Scene::GetLightCamera()->getViewMatrix();
					helperkey=3; sincosPos.y() -= b;
					break;				
				case 'i' :	
					//Scene::GetLightCamera()->getViewMatrix() = RotY2 * Scene::GetLightCamera()->getViewMatrix();
					//Scene::GetCloudCamera()->getViewMatrix() = Scene::GetLightCamera()->getViewMatrix();
					helperkey=4; sincosPos.y() += b;					
					break;		
				case '+' : 
						 osgCloudyDay::CloudScene::timeOfDay += 0.1f;
						//if(m_cloudscene != 0) m_cloudscene->UpdateUniform( osgCloudyDay::CloudScene::WCU_TimeOfDay);
					break;
				case '-' :
						 osgCloudyDay::CloudScene::timeOfDay -= 0.1f;
						//if(m_cloudscene != 0) m_cloudscene->UpdateUniform( osgCloudyDay::CloudScene::WCU_TimeOfDay);
					break;
				case '<' :
						 osgCloudyDay::CloudScene::fading -= 0.1f;
						//if(m_cloudscene != 0)m_cloudscene->UpdateUniform( osgCloudyDay::CloudScene::WCU_Fading);
					break;
				case '>' :	
						 osgCloudyDay::CloudScene::fading += 0.1f;
						//if(m_cloudscene != 0) m_cloudscene->UpdateUniform( osgCloudyDay::CloudScene::WCU_Fading);
					break;
				case 'g' :	
				case 'G' :
						if(ea.getModKeyMask() == osgGA::GUIEventAdapter::MODKEY_LEFT_SHIFT)
							 osgCloudyDay::CloudScene::dens += 0.1f;
						else
							 osgCloudyDay::CloudScene::dens -= 0.1f;
						//if(m_cloudscene != 0) m_cloudscene->UpdateUniform( osgCloudyDay::CloudScene::WCU_Density);
					break;


				case '1':
					switch(ea.getModKeyMask())
					{
					case osgGA::GUIEventAdapter::MODKEY_LEFT_SHIFT: osgCloudyDay::CloudScene::ambientLight_h0.x() += 0.1f;
						break;
					case osgGA::GUIEventAdapter::MODKEY_LEFT_CTRL: osgCloudyDay::CloudScene::ambientLight_h0.y() += 0.1f;
						break;
					case osgGA::GUIEventAdapter::MODKEY_LEFT_ALT: osgCloudyDay::CloudScene::ambientLight_h0.z() += 0.1f;
						break;
					case osgGA::GUIEventAdapter::MODKEY_RIGHT_SHIFT: osgCloudyDay::CloudScene::ambientLight_h0.x() -= 0.1f;
						break;
					case osgGA::GUIEventAdapter::MODKEY_RIGHT_CTRL: osgCloudyDay::CloudScene::ambientLight_h0.y() -= 0.1f;
						break;
					case osgGA::GUIEventAdapter::MODKEY_RIGHT_ALT: osgCloudyDay::CloudScene::ambientLight_h0.z() -= 0.1f;
						break;
					}
					//if(m_cloudscene != 0) m_cloudscene->UpdateUniform(CloudScene::WCU_AmbientLight_H0);
					break;
				case '2':
					switch(ea.getModKeyMask())
					{
					case osgGA::GUIEventAdapter::MODKEY_LEFT_SHIFT: osgCloudyDay::CloudScene::ambientLight_h1.x() += 0.1f;
						break;
					case osgGA::GUIEventAdapter::MODKEY_LEFT_CTRL: osgCloudyDay::CloudScene::ambientLight_h1.y() += 0.1f;
						break;
					case osgGA::GUIEventAdapter::MODKEY_LEFT_ALT: osgCloudyDay::CloudScene::ambientLight_h1.z() += 0.1f;
						break;
					case osgGA::GUIEventAdapter::MODKEY_RIGHT_SHIFT: osgCloudyDay::CloudScene::ambientLight_h1.x() -= 0.1f;
						break;
					case osgGA::GUIEventAdapter::MODKEY_RIGHT_CTRL: osgCloudyDay::CloudScene::ambientLight_h1.y() -= 0.1f;
						break;
					case osgGA::GUIEventAdapter::MODKEY_RIGHT_ALT: osgCloudyDay::CloudScene::ambientLight_h1.z() -= 0.1f;
						break;
					}
					//if(m_cloudscene != 0) m_cloudscene->UpdateUniform(CloudScene::WCU_AmbientLight_H1);
					break;
				case '3':
					switch(ea.getModKeyMask())
					{
					case osgGA::GUIEventAdapter::MODKEY_LEFT_SHIFT: osgCloudyDay::CloudScene::ambientLight_t0.x() += 0.1f;
						break;
					case osgGA::GUIEventAdapter::MODKEY_LEFT_CTRL: osgCloudyDay::CloudScene::ambientLight_t0.y() += 0.1f;
						break;
					case osgGA::GUIEventAdapter::MODKEY_LEFT_ALT: osgCloudyDay::CloudScene::ambientLight_t0.z() += 0.1f;
						break;
					case osgGA::GUIEventAdapter::MODKEY_RIGHT_SHIFT: osgCloudyDay::CloudScene::ambientLight_t0.x() -= 0.1f;
						break;
					case osgGA::GUIEventAdapter::MODKEY_RIGHT_CTRL: osgCloudyDay::CloudScene::ambientLight_t0.y() -= 0.1f;
						break;
					case osgGA::GUIEventAdapter::MODKEY_RIGHT_ALT: osgCloudyDay::CloudScene::ambientLight_t0.z() -= 0.1f;
						break;
					}
					//if(m_cloudscene != 0) m_cloudscene->UpdateUniform(CloudScene::WCU_AmbientLight_T0);
					break;
				case '4':
					switch(ea.getModKeyMask())
					{
					case osgGA::GUIEventAdapter::MODKEY_LEFT_SHIFT: osgCloudyDay::CloudScene::ambientLight_t1.x() += 0.1f;
						break;
					case osgGA::GUIEventAdapter::MODKEY_LEFT_CTRL: osgCloudyDay::CloudScene::ambientLight_t1.y() += 0.1f;
						break;
					case osgGA::GUIEventAdapter::MODKEY_LEFT_ALT: osgCloudyDay::CloudScene::ambientLight_t1.z() += 0.1f;
						break;
					case osgGA::GUIEventAdapter::MODKEY_RIGHT_SHIFT: osgCloudyDay::CloudScene::ambientLight_t1.x() -= 0.1f;
						break;
					case osgGA::GUIEventAdapter::MODKEY_RIGHT_CTRL: osgCloudyDay::CloudScene::ambientLight_t1.y() -= 0.1f;
						break;
					case osgGA::GUIEventAdapter::MODKEY_RIGHT_ALT: osgCloudyDay::CloudScene::ambientLight_t1.z() -= 0.1f;
						break;
					}
					//if(m_cloudscene != 0) m_cloudscene->UpdateUniform(CloudScene::WCU_AmbientLight_T1);
					break;
				case '5':
					switch(ea.getModKeyMask())
					{
					case osgGA::GUIEventAdapter::MODKEY_LEFT_SHIFT: osgCloudyDay::CloudScene::directionalColors[0] += 0.1f;
						break;
					case osgGA::GUIEventAdapter::MODKEY_LEFT_CTRL: osgCloudyDay::CloudScene::directionalColors[1] += 0.1f;
						break;
					case osgGA::GUIEventAdapter::MODKEY_LEFT_ALT: osgCloudyDay::CloudScene::directionalColors[2] += 0.1f;
						break;
					case osgGA::GUIEventAdapter::MODKEY_RIGHT_SHIFT: osgCloudyDay::CloudScene::directionalColors[0] -= 0.1f;
						break;
					case osgGA::GUIEventAdapter::MODKEY_RIGHT_CTRL: osgCloudyDay::CloudScene::directionalColors[1] -= 0.1f;
						break;
					case osgGA::GUIEventAdapter::MODKEY_RIGHT_ALT: osgCloudyDay::CloudScene::directionalColors[2] -= 0.1f;
						break;
					}
					//if(m_cloudscene != 0) m_cloudscene->UpdateUniform(CloudScene::WCU_DirectionalColor);
					break;
				case '6':
					switch(ea.getModKeyMask())
					{
					case osgGA::GUIEventAdapter::MODKEY_LEFT_SHIFT: osgCloudyDay::CloudScene::directionalColors[3] += 0.1f;
						break;
					case osgGA::GUIEventAdapter::MODKEY_LEFT_CTRL: osgCloudyDay::CloudScene::directionalColors[4] += 0.1f;
						break;
					case osgGA::GUIEventAdapter::MODKEY_LEFT_ALT: osgCloudyDay::CloudScene::directionalColors[5] += 0.1f;
						break;
					case osgGA::GUIEventAdapter::MODKEY_RIGHT_SHIFT: osgCloudyDay::CloudScene::directionalColors[3] -= 0.1f;
						break;
					case osgGA::GUIEventAdapter::MODKEY_RIGHT_CTRL: osgCloudyDay::CloudScene::directionalColors[4] -= 0.1f;
						break;
					case osgGA::GUIEventAdapter::MODKEY_RIGHT_ALT: osgCloudyDay::CloudScene::directionalColors[5] -= 0.1f;
						break;
					}
					//if(m_cloudscene != 0) m_cloudscene->UpdateUniform(CloudScene::WCU_DirectionalColor);
					break;
				case '7':
					switch(ea.getModKeyMask())
					{
					case osgGA::GUIEventAdapter::MODKEY_LEFT_SHIFT: osgCloudyDay::CloudScene::directionalColors[6] += 0.1f;
						break;
					case osgGA::GUIEventAdapter::MODKEY_LEFT_CTRL: osgCloudyDay::CloudScene::directionalColors[7] += 0.1f;
						break;
					case osgGA::GUIEventAdapter::MODKEY_LEFT_ALT: osgCloudyDay::CloudScene::directionalColors[8] += 0.1f;
						break;
					case osgGA::GUIEventAdapter::MODKEY_RIGHT_SHIFT: osgCloudyDay::CloudScene::directionalColors[6] -= 0.1f;
						break;
					case osgGA::GUIEventAdapter::MODKEY_RIGHT_CTRL: osgCloudyDay::CloudScene::directionalColors[7] -= 0.1f;
						break;
					case osgGA::GUIEventAdapter::MODKEY_RIGHT_ALT: osgCloudyDay::CloudScene::directionalColors[8] -= 0.1f;
						break;
					}
					//if(m_cloudscene != 0) m_cloudscene->UpdateUniform(CloudScene::WCU_DirectionalColor);
					break;
				case '8':
					break;
				case '9':
					break;
				case '0': osgCloudyDay::CloudGeometry::blur = !osgCloudyDay::CloudGeometry::blur;
					break;
				}

				if(ea.getKey() == 'v') 
				{
					//oldMatrix = Scene::GetViewCamera()->getProjectionMatrix();

					project= true;
					/*osg::Vec3f eye = osg::Vec3f();
					osg::Vec3f center = osg::Vec3f();
					osg::Vec3f up = osg::Vec3f();
					Scene::GetLightCamera()->getViewMatrixAsLookAt(eye, center, up);
					osg::Matrix proj = Scene::GetLightCamera()->getProjectionMatrix();

					Scene::GetViewCamera()->setViewMatrixAsLookAt(eye, center, up);
					Scene::GetViewCamera2()->setViewMatrixAsLookAt(eye, center, up);
					Scene::GetViewDepthCamera()->setViewMatrixAsLookAt(eye, center, up);					
					Scene::GetViewCamera()->setProjectionMatrix(proj);
					Scene::GetViewCamera2()->setProjectionMatrix(proj);
					Scene::GetViewDepthCamera()->setProjectionMatrix(proj);*/
				}
				
				if(ea.getKey() == 'c') 
				{
					project=false;
					oldMatrix = osg::Matrixd().perspective(80.0, (double)(osgCloudyDay::Scene::GetWidth())/(double)(osgCloudyDay::Scene::GetHeight()), 1.0, 500000.0);	
					osgCloudyDay::Scene::GetViewCamera()->setProjectionMatrix(oldMatrix);
					osgCloudyDay::Scene::GetViewCamera2()->setProjectionMatrix(oldMatrix);
					osgCloudyDay::Scene::GetViewDepthCamera()->setProjectionMatrix(oldMatrix);
				}
				
				if(ea.getKey() == 'j' || ea.getKey() == 'l' || ea.getKey() == 'k' || ea.getKey() == 'i') 
				{				
					osg::Vec4 value = osg::Vec4(0.f, 0.f, 0.f, 1.f) * osg::Matrix::inverse(osgCloudyDay::Scene::GetLightCamera()->getViewMatrix());
					std::cout << " LIGHTPOS: " << value.x() << " " << value.y() << " " << value.z() << std::endl;
					
					osg::Vec3f eye = osg::Vec3f();
					osg::Vec3f center = osg::Vec3f();
					osg::Vec3f up = osg::Vec3f();
					osgCloudyDay::Scene::GetLightCamera()->getViewMatrixAsLookAt(eye, center, up);

					center = osg::Vec3(0.f, 0.f, 0.f);
					std::cout << "Eye: " << eye.x() << " " << eye.y() << " " << eye.z() << std::endl;
					std::cout << "Center: " << center.x() << " " << center.y() << " " << center.z() << std::endl;


					osg::Vec3f center2eye = eye-center;
					float length = center2eye.normalize();;					
					center2eye.x() = sinf(sincosPos.y())*cosf(sincosPos.x());
					center2eye.y() = sinf(sincosPos.y())*sinf(sincosPos.x());
					center2eye.z() = cosf(sincosPos.y());				
													
					if(center2eye.x() == 0.f && center2eye.y() == 0.f && center2eye.z() == 1.f) 
					{
						switch(helperkey)
						{
							case 1 :	sincosPos.x() += b;						
								break;				
							case 2 :	sincosPos.x() -= b;
								break;
							case 3 :	sincosPos.y() -= b;
								break;				
							case 4 :	sincosPos.y() += b;					
								break;		
						}
						center2eye.x() = sinf(sincosPos.y())*cosf(sincosPos.x());
						center2eye.y() = sinf(sincosPos.y())*sinf(sincosPos.x());
						center2eye.z() = cosf(sincosPos.y());				
					}
					
					center2eye.normalize();
					center2eye *= length;

					osg::Vec3 binm = osg::Vec3(0.f, 1.f, 0.f);
					osg::Vec3 dir = center2eye;
					binm.normalize();
					osg::Vec3 h = binm^dir;
					h.normalize();

					osg::Vec3f lightPos = center2eye+center;
					osgCloudyDay::Scene::GetLightCamera()->setViewMatrixAsLookAt(lightPos, center, h/*osg::Vec3(0.0, 0.0, 1.0)*/);								
					osgCloudyDay::CloudScene::GetCloudCamera()->setViewMatrixAsLookAt(lightPos, center, h/*osg::Vec3(0.0, 0.0, 1.0)*/);								
					//Scene::GetViewMatrix_Light().lookAt(lightPos, center, h/*osg::Vec3(0.0, 0.0, 1.0)*/);								

//					osg::Vec3f lightPos = eye;
					osgCloudyDay::Scene::m_skydome->SetLightPosition(lightPos);

					std::cout << "LightPos: " << lightPos.x() << " " << lightPos.y() << " " << lightPos.z() << std::endl;

					//nodess7->getUniform("v3LightPos")->set( osgCloudyDay::CloudScene::m_skydome->GetLightPosition());
					//nodessSkydome->getUniform("v3LightPos")->set( osgCloudyDay::CloudScene::m_skydome->GetLightPosition());
					//nodessP->getUniform("un_lightPos")->set( osgCloudyDay::CloudScene::m_skydome->GetLightPosition()); //27.1 (gehört korrigiert)
					
					osgCloudyDay::SkydomeMie* skymie = dynamic_cast<osgCloudyDay::SkydomeMie*>(osgCloudyDay::Scene::m_skydome);
					if(skymie != 0) 
					{
						 osgCloudyDay::CloudScene::sunLightColor = skymie->CalculateSunColor(osgCloudyDay::Scene::GetLightCamera()->getViewMatrix());				
						my_scene->UpdateLightForClouds();					
					}
				}
				
				break;
			}		
            default:
				return false;
        }
		return true;
	}       
};

int main()
{		
	osgCloudyDay::TerrainConfig* terrain_config = new osgCloudyDay::TerrainConfig();
	terrain_config->SetTesselationShader(false);

	terrain_config->SetPath2File("../data/terrain/mountains-Copy.obj");
	//terrain_config->SetPath2File("../data/terrain/mountains.obj");			//FOR Tesselation Shaders
	terrain_config->SetPath2DiffuseTexture("../data/textures/terrain/mountain_diffuse.bmp");
	terrain_config->SetPath2DefinationTexture("../data/textures/terrain/definition1.tga");
	terrain_config->SetPath2HeightTexture("../data/textures/terrain/mountain_heightmap.tga");
	//terrain_config->SetPath2NormalTexture("../data/textures/terrain/mountain_normal.bmp");	
	
	terrain_config->AddPath2Texture("../data/textures/terrain/snow.bmp");
	terrain_config->AddPath2Texture("../data/textures/terrain/terrain_rock4.bmp");
	terrain_config->AddPath2Texture("../data/textures/terrain/terrain_grass.bmp");
	terrain_config->AddPath2Texture("../data/textures/terrain/boulder.bmp");

	terrain_config->AddPath2NormalTexture("../data/textures/terrain/rock_bump6.tga");
	terrain_config->AddPath2NormalTexture("../data/textures/terrain/rock_bump4.tga");	

	osgCloudyDay::Scene::m_skydome = new osgCloudyDay::SkydomeHimmel();	

	osgCloudyDay::Fog* fog = new osgCloudyDay::Fog();
	fog->SetFogColor(osg::Vec3(0.5f, 0.5f, 0.5f));
	fog->SetFogDensity(0.1f);
	
/*	osgCloudyDay::RainState* rain = new osgCloudyDay::RainState();
	rain->SetNumberOfParticles(100000);
	rain->SetVelocity(osg::Vec3(0.f, 0.f, -1.f));
	rain->SetPosition(osg::Vec3(0.f, 0.f, 1000.f));
	rain->SetSize(osg::Vec3(2000.f, 2000.f, 1000.f));
	Scene::m_rain = rain;
	*/

	/*
	//Define Cloud Layers		
	osgCloudyDay::CloudScene::GetStates()->AddLayer(0, osgCloudyDay::CloudScene::CT_Stratus);
	osgCloudyDay::CloudScene::GetStates()->setOvercast(0, 0.00151525f);
	osgCloudyDay::CloudScene::GetStates()->setHeight(0, 10.f);
	osgCloudyDay::CloudScene::GetStates()->setMiddlePoint(0, osg::Vec3(0.f, 0.f, 2000.f));
	osgCloudyDay::CloudScene::GetStates()->setSize(0, osg::Vec3(10000.f, 10000.f, 100.f));
	osgCloudyDay::CloudScene::GetStates()->setMeasureOvercast(0, 0.0f);
	osgCloudyDay::CloudScene::GetStates()->setClot(0, 20);
	osgCloudyDay::CloudScene::GetStates()->setVariance(0, 0.25);	
	osgCloudyDay::CloudScene::GetStates()->setColor(0, osg::Vec4(1.f, 1.f, 1.f, 0.7f));	
	*/
#if 1
	
	 osgCloudyDay::CloudScene::GetStates()->AddLayer(0, osgCloudyDay::CloudScene::CT_Cumulus);
	 osgCloudyDay::CloudScene::GetStates()->setOvercast(0, 0.002551f/1.f);
	// osgCloudyDay::CloudScene::GetStates()->setOvercast(0, 0.05f);
	 osgCloudyDay::CloudScene::GetStates()->setHeight(0, 10.f);
	 osgCloudyDay::CloudScene::GetStates()->setMiddlePoint(0, osg::Vec3(0.f,0.f, 2000.f));
	 osgCloudyDay::CloudScene::GetStates()->setSize(0, osg::Vec3(10000.f, 10000.f, 10.f));
	 osgCloudyDay::CloudScene::GetStates()->setMeasureOvercast(0, 0.0f);
	 osgCloudyDay::CloudScene::GetStates()->setClot(0, 10);
	 osgCloudyDay::CloudScene::GetStates()->setVariance(0, 0.125f);				
	 osgCloudyDay::CloudScene::GetStates()->setColor(0, osg::Vec4(1.f, 1.f, 1.f, 1.f));				
	// osgCloudyDay::CloudScene::GetStates()->setBuffy(0, 1.f);				
	
	/*
	 osgCloudyDay::CloudScene::GetStates()->AddLayer(1, osgCloudyDay::CloudScene::CT_AltCumulusGenerator);
	 osgCloudyDay::CloudScene::GetStates()->setOvercast(1, 0.055525f);
	 osgCloudyDay::CloudScene::GetStates()->setHeight(1, 10.f);
	 osgCloudyDay::CloudScene::GetStates()->setMiddlePoint(1, osg::Vec3(0.f, 0.f, 4000.f));
	 osgCloudyDay::CloudScene::GetStates()->setSize(1, osg::Vec3(10000.f, 10000.f, 10.f));
	 osgCloudyDay::CloudScene::GetStates()->setMeasureOvercast(1, 0.0f);
	 osgCloudyDay::CloudScene::GetStates()->setClot(1, 10);
	 osgCloudyDay::CloudScene::GetStates()->setVariance(1, 0.25);	
	*/
	
	
	 osgCloudyDay::CloudScene::GetStates()->AddLayer(1, osgCloudyDay::CloudScene::CT_Stratus);
	 osgCloudyDay::CloudScene::GetStates()->setOvercast(1, 0.0011525f);
	 osgCloudyDay::CloudScene::GetStates()->setHeight(1, 10.f);
	 osgCloudyDay::CloudScene::GetStates()->setMiddlePoint(1, osg::Vec3(0.f, 0.f, 1000.f));
	 osgCloudyDay::CloudScene::GetStates()->setSize(1, osg::Vec3(20000.f, 20000.f, 10.f));
	 osgCloudyDay::CloudScene::GetStates()->setMeasureOvercast(1, 0.0f);
	 osgCloudyDay::CloudScene::GetStates()->setClot(1, 10);
	 osgCloudyDay::CloudScene::GetStates()->setVariance(1, 0.25);	
	 osgCloudyDay::CloudScene::GetStates()->setColor(1, osg::Vec4(0.75f, 0.75f, 0.75f, 0.5f));				

	/* osgCloudyDay::CloudScene::GetStates()->AddLayer(2, osgCloudyDay::CloudScene::CT_AltCumulusGenerator);
	 osgCloudyDay::CloudScene::GetStates()->setOvercast(2, 0.0155525f);
	 osgCloudyDay::CloudScene::GetStates()->setHeight(2, 10.f);
	 osgCloudyDay::CloudScene::GetStates()->setMiddlePoint(2, osg::Vec3(0.f, 0.f, 6000.f));
	 osgCloudyDay::CloudScene::GetStates()->setSize(2, osg::Vec3(20000.f, 20000.f, 10.f));
	 osgCloudyDay::CloudScene::GetStates()->setMeasureOvercast(2, 0.0f);
	 osgCloudyDay::CloudScene::GetStates()->setClot(2, 10);
	 osgCloudyDay::CloudScene::GetStates()->setVariance(2, 0.25);	
	
	/*/
#endif	
	/*
	 osgCloudyDay::CloudScene::GetStates()->AddLayer(0, osgCloudyDay::CloudScene::CT_AltStratus);
	 osgCloudyDay::CloudScene::GetStates()->setOvercast(0, 0.30525f);
	 osgCloudyDay::CloudScene::GetStates()->setHeight(0, 10.f);
	 osgCloudyDay::CloudScene::GetStates()->setMiddlePoint(0, osg::Vec3(0.f, 0.f, 4000.f));
	 osgCloudyDay::CloudScene::GetStates()->setSize(0, osg::Vec3(20000.f, 20000.f, 100.f));
	 osgCloudyDay::CloudScene::GetStates()->setMeasureOvercast(0, 0.0f);
	 osgCloudyDay::CloudScene::GetStates()->setClot(0, 20);
	 osgCloudyDay::CloudScene::GetStates()->setVariance(0, 0.25);	
	/*/

	
	/* osgCloudyDay::CloudScene::GetStates()->AddLayer(0, osgCloudyDay::CloudScene::CT_Stratus);
	 osgCloudyDay::CloudScene::GetStates()->setOvercast(0, 0.0151525f);
	 osgCloudyDay::CloudScene::GetStates()->setHeight(0, 10.f);
	 osgCloudyDay::CloudScene::GetStates()->setMiddlePoint(0, osg::Vec3(0.f, 0.f, 2000.f));
	 osgCloudyDay::CloudScene::GetStates()->setSize(0, osg::Vec3(10000.f, 10000.f, 100.f));
	 osgCloudyDay::CloudScene::GetStates()->setMeasureOvercast(0, 0.0f);
	 osgCloudyDay::CloudScene::GetStates()->setClot(0, 20);
	 osgCloudyDay::CloudScene::GetStates()->setVariance(0, 0.25);	
	 osgCloudyDay::CloudScene::GetStates()->setColor(0, osg::Vec4(1.f, 1.f, 1.f, 0.7f));				
	/*
	 osgCloudyDay::CloudScene::GetStates()->AddLayer(0, osgCloudyDay::CloudScene::CT_Stratus);
	 osgCloudyDay::CloudScene::GetStates()->setOvercast(0, 0.02525f);
	 osgCloudyDay::CloudScene::GetStates()->setHeight(0, 10.f);
	 osgCloudyDay::CloudScene::GetStates()->setMiddlePoint(0, osg::Vec3(0.f, 0.f, 1000.f));
	 osgCloudyDay::CloudScene::GetStates()->setSize(0, osg::Vec3(10000.f, 10000.f, 10.f));
	 osgCloudyDay::CloudScene::GetStates()->setMeasureOvercast(0, 0.0f);
	 osgCloudyDay::CloudScene::GetStates()->setClot(0, 10);
	 osgCloudyDay::CloudScene::GetStates()->setVariance(0, 0.25);	
	*/
	
	/*
	 osgCloudyDay::CloudScene::GetStates()->AddLayer(0, osgCloudyDay::CloudScene::CT_StratoCumulusGenerator);
	 osgCloudyDay::CloudScene::GetStates()->setOvercast(0, 0.204525f);
	 osgCloudyDay::CloudScene::GetStates()->setHeight(0, 10.f);
	 osgCloudyDay::CloudScene::GetStates()->setMiddlePoint(0, osg::Vec3(0.f, 0.f, 2500.f));
	 osgCloudyDay::CloudScene::GetStates()->setSize(0, osg::Vec3(10000.f, 10000.f, 10.f));
	 osgCloudyDay::CloudScene::GetStates()->setMeasureOvercast(0, 0.0f);
	 osgCloudyDay::CloudScene::GetStates()->setClot(0, 10);
	 osgCloudyDay::CloudScene::GetStates()->setVariance(0, 0.25);	
	*/
	
	/*
	 osgCloudyDay::CloudScene::GetStates()->AddLayer(0, osgCloudyDay::CloudScene::CT_AltCumulusGenerator);
	 osgCloudyDay::CloudScene::GetStates()->setOvercast(0, 0.00156525f);
	 osgCloudyDay::CloudScene::GetStates()->setHeight(0, 1000.f);
	 osgCloudyDay::CloudScene::GetStates()->setMiddlePoint(0, osg::Vec3(0.f, 0.f, 4000.f));
	 osgCloudyDay::CloudScene::GetStates()->setSize(0, osg::Vec3(10000.f, 10000.f, 10.f));
	 osgCloudyDay::CloudScene::GetStates()->setMeasureOvercast(0, 0.0f);
	 osgCloudyDay::CloudScene::GetStates()->setClot(0, 10);
	 osgCloudyDay::CloudScene::GetStates()->setVariance(0, 0.25);	
	 osgCloudyDay::CloudScene::GetStates()->setColor(0, osg::Vec4(1.f,1.f,1.f,1.f));	
	
	
	/*
	 osgCloudyDay::CloudScene::GetStates()->AddLayer(0, osgCloudyDay::CloudScene::CT_Nimbostratus);
	 osgCloudyDay::CloudScene::GetStates()->setOvercast(0, 0.775f);
	 osgCloudyDay::CloudScene::GetStates()->setHeight(0, 100.f);
	 osgCloudyDay::CloudScene::GetStates()->setMiddlePoint(0, osg::Vec3(0.f,0.f, 2500.f));
	 osgCloudyDay::CloudScene::GetStates()->setSize(0, osg::Vec3(5000.f, 5000.f, 10.f));
	 osgCloudyDay::CloudScene::GetStates()->setMeasureOvercast(0, 0.0f);
	 osgCloudyDay::CloudScene::GetStates()->setClot(0, 10);	
	 osgCloudyDay::CloudScene::GetStates()->setVariance(0, 0.5);	
	*/
	/*
	 osgCloudyDay::CloudScene::GetStates()->AddLayer(0, osgCloudyDay::CloudScene::CT_Cumolonimbus);
	 osgCloudyDay::CloudScene::GetStates()->setOvercast(0, 0.0555f);
	 osgCloudyDay::CloudScene::GetStates()->setHeight(0, 10.f);
	 osgCloudyDay::CloudScene::GetStates()->setMiddlePoint(0, osg::Vec3(0.f,0.f, 1000.f));
	 osgCloudyDay::CloudScene::GetStates()->setSize(0, osg::Vec3(10000.f, 10000.f, 10.f));
	 osgCloudyDay::CloudScene::GetStates()->setMeasureOvercast(0, 0.0f);
	 osgCloudyDay::CloudScene::GetStates()->setClot(0, 10);
	 osgCloudyDay::CloudScene::GetStates()->setVariance(0, 0.5);
	*/

	osgCloudyDay::CloudState* clouds = new osgCloudyDay::CloudState();
	//clouds->AddCloud((int)( osgCloudyDay::CloudScene::CT_Cumulus), "../data/models/standford_bunny.obj", osg::Vec3(   0.f,   0.f,2125.f), osg::Vec3(100.f, 100.f, 100.f), osgCloudyDay::CloudState::CStG_Simulation, osg::Vec4(1.f, 1.f, 1.f, 1.f));
	//clouds->AddCloud((int)( osgCloudyDay::CloudScene::CT_Cumulus), "../data/models/standford_bunny.obj", osg::Vec3(   0.f,   0.f,2125.f), osg::Vec3(100.f, 100.f, 100.f), osgCloudyDay::CloudState::CStG_Voxel, osg::Vec4(1.f, 1.f, 1.f, 1.f));
	//clouds->AddCloud((int)( osgCloudyDay::CloudScene::CT_Cumulus), "../data/models/wangcloudtest.obj" /*../data/models/cloud_model.obj"*/, osg::Vec3(   0.f,   0.f,2125.f), osg::Vec3(100.f, 100.f, 100.f), CloudState::CStG_Wang);
	//clouds->AddCloud((int)( osgCloudyDay::CloudScene::CT_Cumulus), osg::Vec3(   0.f,   0.f, 1000.f), osg::Vec3(100.f, 100.f, 100.f));
	//clouds->AddCloud((int)( osgCloudyDay::CloudScene::CT_Cumulus), osg::Vec3( 500.f,   0.f, 1000.f), osg::Vec3(100.f, 100.f, 100.f));
	//clouds->AddCloud((int)( osgCloudyDay::CloudScene::CT_Cumulus), osg::Vec3(   0.f, 500.f, 1000.f), osg::Vec3(100.f, 100.f, 100.f));
	//clouds->AddCloud((int)( osgCloudyDay::CloudScene::CT_Cumulus), osg::Vec3(   0.f,-500.f, 1000.f), osg::Vec3(100.f, 100.f, 100.f));		
	//clouds->AddCloud((int)( osgCloudyDay::CloudScene::CT_Cumulus), "foo.obj", osg::Vec3(   0.f,   0.f,2125.f), osg::Vec3(100.f, 100.f, 100.f), osgCloudyDay::CloudState::CStG_XML, osg::Vec4(1.f, 1.f, 1.f, 1.f));

	std::vector<osgCloudyDay::Cloud2DState> cloud2dstates;
	
	//osgCloudyDay::CirrusCloudState cirrus = osgCloudyDay::CirrusCloudState();
	//osgCloudyDay::CirrusStratusCloudState cirrus = osgCloudyDay::CirrusStratusCloudState();
	osgCloudyDay::PerlinCloudState cirrus = osgCloudyDay::PerlinCloudState();
	//osgCloudyDay::CirrusCumulusCloudState cirrus = osgCloudyDay::CirrusCumulusCloudState();
	//osgCloudyDay::AltStratusCloudState cirrus = osgCloudyDay::AltStratusCloudState();

	//cirrus.setMiddlePoint(osg::Vec3(0.f, 0.f, 7500.0f));
	//cirrus.setMiddlePoint(osg::Vec3(0.f, 0.f, 1000.0f));
	//cirrus.setSize(osg::Vec2(10000.0f, 10000.0f));

	cirrus.setSharpness(0.9f);
	cirrus.setCover(0.25f);

	//cirrus.setMiddlePoint(osg::Vec3(0.f, 0.f, 7500.0f))	;
	cirrus.setMiddlePoint(osg::Vec3(0.f, 0.f, 5000.0f))	;
	cirrus.setSize(osg::Vec2(50000.0f, 50000.0f));

	cloud2dstates.push_back(cirrus);

	//Export* exp = new Export();;	

	std::vector<std::string> reflection_models;
	reflection_models.push_back("../data/models/bx2/bx2.obj");	
	//reflection_models.push_back("../data/models/bx2/box.obj");	

	std::vector<std::string> reflection_tex;
	reflection_tex.push_back("../data/models/bx2/bx2.bmp");	
	//reflection_tex.push_back("../data/models/bx2/bx2.bmp");	

	std::vector<int> ids_model;
	ids_model.push_back(1);
	//ids_model.push_back(1);
	

	std::vector<std::string> luds;
	luds.push_back("../data/lud/neutralLUT.bmp");
	luds.push_back("../data/lud/yellowLUT.bmp");


	/////////////////////////

	osgCloudyDay::RainState* rainstate = new osgCloudyDay::RainState();
	rainstate->SetSize(osg::Vec3(20000.f, 20000.f, 20000.f));
	rainstate->SetPosition(osg::Vec3(0.f, 0.f, 10000.f));
	rainstate->SetVelocity(osg::Vec3(0.f, 0.f, -1.f));

	my_scene = new osgCloudyDay::CloudyDay(terrain_config, false, false, false, true, true);	
	my_scene->Initialize(800,600,clouds, cloud2dstates, ids_model, reflection_models, reflection_tex, fog, luds, rainstate);	

	osg::ref_ptr<osg::Group> root (new osg::Group);		
	
#ifdef SHADOW_MAPPING	
	root->addChild(my_scene->GetLightCamera().get());			
#endif				
	
	root->addChild(my_scene->GetViewCamera2());	

	/*
	std::cout << "my_scene->GetNumberOfReflectionObjects(): " << my_scene->GetNumberOfReflectionObjects() << std::endl;
	for(int j = 0; j < my_scene->GetNumberOfReflectionObjects(); j++)
	{
		osg::Camera** tmp_cam = my_scene->GetReflectionCamerasAt(j);
		for(int i = 0; i < 6; i++)		
			root->addChild(tmp_cam[i]);			
	}*/

#ifdef SHADOW_MAPPING		
	root->addChild(my_scene->GetLightCloudCamera().get());	
	root->addChild(my_scene->GetBlurShadowMapCamera().get());
			
	//root->addChild(my_scene->GetLightshaftCamera());
#endif			

	root->addChild(my_scene->GetViewCamera());
	
#ifndef SHADOW_MAPPING
	root->addChild(m_lightCloudCamera.get());
#endif
		
	root->addChild(my_scene->GetHUD().get());	
	if(my_scene->UseBloom() || my_scene->UseStar()) root->addChild(my_scene->GetBlurProcess().get());
	if(my_scene->UseBloom() || my_scene->UseStar()) root->addChild(my_scene->GetBlur2Process().get());
	root->addChild(my_scene->GetLuminanceCalculation().get());	
	root->addChild(my_scene->GetPostProcess().get());	
	
	osgViewer::Viewer viewer;
	viewer.setCamera(my_scene->GetViewDepthCamera());
	
	// add the state manipulator to the viewer
	viewer.addEventHandler( new 		osgGA::StateSetManipulator(viewer.getCamera()->getOrCreateStateSet()) );
	
	// register the handler for modifying the point size
    viewer.addEventHandler(new KeyboardEventHandler(viewer.getCamera()->getOrCreateStateSet()));

	//Stats Event Handler s key
	viewer.addEventHandler(new osgViewer::StatsHandler);
	viewer.setSceneData( root.get() );

	bool _firstFrame = true;	
	while(!viewer.done()) 
	{		
		if(!viewer.getCameraManipulator() && viewer.getCamera()->getAllowEventFocus())
			viewer.setCameraManipulator(new osgGA::TrackballManipulator());	    
	
	    viewer.setReleaseContextAtEndOfFrameHint(false);
				
		//if(_done) return;

		if(_firstFrame)
		{
			viewer.init();	       
		    if(!viewer.isRealized())
				viewer.realize();
       
		    _firstFrame = false;
		}

		viewer.advance(USE_REFERENCE_TIME);   		
		viewer.eventTraversal();

		osg::Vec3 eye, center, up;
		osg::Vec3 eye_light, center_light, up_light;			
	
		viewer.updateTraversal();

		
		osgCloudyDay::Scene::GetViewDepthCamera()->getViewMatrixAsLookAt(eye, center, up);
		osgCloudyDay::Scene::GetLightCamera()->getViewMatrixAsLookAt(eye_light, center_light, up_light);		

		if(project) 
		{			
			osg::Vec3f eye = osg::Vec3f();
			osg::Vec3f center = osg::Vec3f();
			osg::Vec3f up = osg::Vec3f();
			osgCloudyDay::Scene::GetLightCamera()->getViewMatrixAsLookAt(eye, center, up);
			osg::Matrix proj = osgCloudyDay::Scene::GetProjectionMatrix_Light();

			osgCloudyDay::Scene::GetViewCamera()->setViewMatrixAsLookAt(eye, center, up);
			osgCloudyDay::Scene::GetViewCamera2()->setViewMatrixAsLookAt(eye, center, up);
			osgCloudyDay::Scene::GetViewDepthCamera()->setViewMatrixAsLookAt(eye, center, up);					
			osgCloudyDay::Scene::GetViewCamera()->setProjectionMatrix(proj);
			osgCloudyDay::Scene::GetViewCamera2()->setProjectionMatrix(proj);
			osgCloudyDay::Scene::GetViewDepthCamera()->setProjectionMatrix(proj);
		}						
				
		viewer.renderingTraversals();					
	}
	
	//delete my_scene;
	delete clouds;
	delete terrain_config;
	delete osgCloudyDay::Scene::m_skydome;
	 osgCloudyDay::CloudScene::DeleteStates();
	
	return 1;
}