# Create a RGB lookup table with the given dimension
# The final dimension of the image will be (width * depth) x height


import argparse
import numpy as np
from PIL import Image


parser = argparse.ArgumentParser()
parser.add_argument("file",
	help = "path of the output file. This file will be created or overwritten.")
parser.add_argument("size",
	help = "LUT is cubic with the shape a x a x a where a is the specified image size.",
	type = int)
parser.add_argument("gamma",
	help = "Gamme value used for creation. Values are powered with it. Common values are 1.0 or 2.2",
	type = float)
args = parser.parse_args()

outputFile = args.file
size = 32
if (args.size):
	size = args.size

gamma = 1.0
if (args.gamma):
	gamma = args.gamma



def applyGamma(value, gamma):
	value = value / 255.0
	value = pow(value, 1.0 / gamma)
	return (value * 255.0)




img = np.empty((size * size, size), np.uint32)
img.shape = (size, size * size) # numpy is a bit "different" when it comes to shapes


increment = (255.0) / (size - 1)
for i in range(size * size):
	for j in range(size):
		r = int(applyGamma((i % size) * increment, gamma))
		g = int(applyGamma((i / size) * increment, gamma))
		b = int(applyGamma(((size - 1) - j) * increment, gamma))
		
		pix = (0xff << 24) + (b << 16) + (g << 8) + r
		img[j, i] = pix

pilImg = Image.frombuffer('RGBA', (size * size, size), img, 'raw', 'RGBA', 0, 1)
# pilImg.show()
pilImg.save(outputFile)



