/** \file
 * 
 * Implements the gui script parsing program which makes use of the vuGuiParser
 * class.
 *
 * It takes as an argument the text file with the gui script, and creates the
 * parsing object which generates the corresponding gui.
 *
 * Syntax:
 *
 * vuTextGui <guiTextFile>
 *
 * where <guiTextFile> is the name of the file which has the gui script.
 *
 * For more information, see the vuTextGui documentation.
 *
 * \sa vuGuiParser
 */
  
#include "vuGuiParser.h"
#include <iostream.h>

int main(int argc, char* argv[])
{
    vuGuiParser p;

    try
    {
        if (argc < 2) throw("Need filename as argument");  

        p.Parse(argv[1]);
        return 0;
    }
    catch(const char* str)
    {
        cout << "Error: " << str << endl;
        return -1;
    }
    return 0;
}
