#include "vuSplat.h"
#include "../../wxUIElements/vuGLCanvas.h"
#include "../../wxUIElements/vuTFDialogSpec.h"
#include "vuColourRGBa.h"

//----------------------------------------------------------------------------
//------------------------- The vuSplat event table --------------------------
//----------------------------------------------------------------------------

enum
{
    idCANVAS
};


BEGIN_EVENT_TABLE(vuSplat, vuBasicUtility)
END_EVENT_TABLE();



//----------------------------------------------------------------------------
//------------------------- The constructor ----------------------------------
//----------------------------------------------------------------------------

vuSplat::vuSplat() : m_TFunc(4), m_TFDialog(this,m_TFunc)
{
    m_Data = 0;
    m_ViewScale = 1.0f;
}

//----------------------------------------------------------------------------
//------------------------- The destructor -----------------------------------
//----------------------------------------------------------------------------

vuSplat::~vuSplat()
{
    if (m_Data != 0) delete m_Data;
}

//----------------------------------------------------------------------------
//------------------------- public: getFileType() ----------------------------
//----------------------------------------------------------------------------

const char* vuSplat::getFileType()
{
    return "11121";
}

//----------------------------------------------------------------------------
//------------------------- public: init() -----------------------------------
//----------------------------------------------------------------------------

bool vuSplat::init(const char* DataFile)
{
    //Set up the window for the splatter.
    SetTitle("vuSplat");
    CreateStatusBar();
    
    //Create a volume data instance.
    m_Data = new vu1112111;
    m_Data->setFileName(DataFile);
    
    //Set the transfer function for the data.

    m_TFunc.addOpacity(0,0.0);
    m_TFunc.addOpacity(255,1.0);
    m_TFunc.addColour(128,vuColourRGBa(0.f));
    m_TFunc.addColour(255,vuColourRGBa(1.f));
    m_TFunc.setOpacitySmoothing(0);
    m_TFunc.setColourSmoothing(1);

/* // the old original transfer function for hipiph
    m_TFunc.addOpacity(1,0.01);
    m_TFunc.addOpacity(11,0.01);
    m_TFunc.addOpacity(12,1);
    m_TFunc.addOpacity(32,1);
    m_TFunc.addColour(1,vuColourRGBa(0.f));
    m_TFunc.addColour(11,vuColourRGBa(1.f));
    m_TFunc.addColour(32,vuColourRGBa(0.f,0.f,0.6f));
    m_TFunc.setOpacitySmoothing(0);
    m_TFunc.setColourSmoothing(0);
*/
    m_TFunc.generateFunction();
    m_Data->setTransferFunc(m_TFunc);

    //Read in the data.
    bool success = m_Data->read();
    if (success)
    {
        m_glCanvas->SetSize(512,512);
        Fit();
    }
    else
    {
        wxMessageDialog dlg(this,m_Data->getErrorMessage(),"vuSplat",wxOK);
        dlg.ShowModal();
    }
    
    return success;
};

void vuSplat::DrawAgain ()

{
	m_glCanvas->redraw();
}

void vuSplat::DrawFromImage ()

{
	m_Data->drawPic ();
}

vuImage* vuSplat::getCurrentImage ()

{
	return m_Data->getBuffer ();
}

vuCamera* vuSplat::getCamera ()

{
	return &m_Camera;
}

//----------------------------------------------------------------------------
//------------------------- protected: glInit() ------------------------------
//----------------------------------------------------------------------------

bool vuSplat::glInit(void)
{
    if (m_Data == 0) return false;
    
    glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
    
    glEnable(GL_LIGHTING);
    glEnable(GL_LIGHT0);
    glLightModeli(GL_LIGHT_MODEL_TWO_SIDE, GL_TRUE);
    
    m_Data->initOpenGL();
    return true;
};


//----------------------------------------------------------------------------
//------------------------- protected: glRender() ----------------------------
//----------------------------------------------------------------------------

void vuSplat::glRender()
{
    wxStopWatch watch;
    watch.Start();

    glClear(GL_COLOR_BUFFER_BIT);

    glLoadIdentity();
    m_Camera.gluLookAt();
    glTranslatef((float)m_Data->getDim1Size()/(-2.0f),
                 (float)m_Data->getDim2Size()/(-2.0f),
                 (float)m_Data->getDim3Size()/(-2.0f));

    m_Data->setViewVectors(m_Camera.getLookAtVector(),
                           m_Camera.getUpVector(),
                           m_Camera.getRightVector());

    //this is not necessary every frame, but done anyways,
    //because the non-modal tfuncDlg might have changed it
    
    cout << m_TFunc[20][0]<<", "<<m_TFunc[20][1]<<", "<<m_TFunc[20][2]<<", "<<m_TFunc[20][3]<<endl;
    cout << "components: "<<m_TFunc.getNComponents()<<endl;
    m_Data->setTransferFunc(m_TFunc);
    
    m_Data->render();

    watch.Pause();
    SetStatusText(wxString("Render Time: ") + vuString(watch.Time()).c_str() + "ms");
};

//---------------------------------------------------------------------------
void vuSplat::notifyDataChanged()
{
    m_glCanvas->redraw();
}

//----------------------------------------------------------------------------
//------------------------- protected: glResize() ----------------------------
//----------------------------------------------------------------------------

void vuSplat::glResize()
{
    //Set the viewport.
    glViewport(0, 0, (GLint)m_glCanvas->getWidth(),(GLint)m_glCanvas->getHeight());
    
    //Find the largest dimension of the data.
    dword max = m_Data->getDim1Size();
    if (m_Data->getDim2Size() > max)
        max = m_Data->getDim2Size();
    if (m_Data->getDim3Size() > max)
        max = m_Data->getDim3Size();

    //Set the opengl projection matrix.
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    glOrtho((float)max/(-1.0f*m_ViewScale), (float)max/m_ViewScale,
            (float)max/(-1.0f*m_ViewScale), (float)max/m_ViewScale,
            10000.0f, -10000.0f);
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
    
    //Set the opengl light info.
    float lpos[4] = {0.0, 0.0, 1024.0, 1.0};
    glLightfv(GL_LIGHT0, GL_POSITION, lpos);
}

//----------------------------------------------------------------------------
//------------------------- protected: glOnMouse() ---------------------------
//----------------------------------------------------------------------------

void vuSplat::glOnMouse(wxMouseEvent &ev)
{
    if (ev.LeftDown() || ev.RightDown())
    {
        //Store the click position.
        m_x = (int) ev.GetX();
        m_y = (int) ev.GetY();
    }
    else if (ev.LeftIsDown() && ev.Moving())
    {
        //Rotate the volume
        vuVector t = m_Camera.getPosition();
        float d = t.norm();

        m_Camera.translateXYZ(0.0f, 0.0f, d);
        m_Camera.rotateAboutUp(ev.GetX() - m_x);
        m_Camera.rotateAboutRight(ev.GetY() - m_y);
        m_Camera.translateXYZ(0.0f, 0.0f, -d);
        m_glCanvas->redraw();

        //Store the click position.
        m_x = (int) ev.GetX();
        m_y = (int) ev.GetY();
    }
    else if (ev.RightIsDown() && ev.Moving())
    {
        //Zoom the volume.
        m_ViewScale -= ((float)ev.GetY() - m_y)/500.0f;
        glResize();
        m_glCanvas->redraw();

        //Store the click position.
        m_x = (int) ev.GetX();
        m_y = (int) ev.GetY();
    }
    else if (ev.LeftDClick())
    {
        //Pop up the transfer function editor
	m_TFDialog.Show(true);
/*	
        if (dlg.ShowModal() == wxID_OK)
        {
	    m_TFunc = (vuTFDesignSpec&)dlg.getTransferFunc();
            m_Data->setTransferFunc(m_TFunc);
            m_glCanvas->redraw();
        }
*/
    }
}

bool vuSplat::IsReRendering ()

{
	return m_Data->IsReRendering ();
}

void vuSplat::setIsReRendering (bool isit)

{
	m_Data->setIsReRendering (isit);
}


