//!A utility window for the spectral splatter

/*!
*/

#ifndef _vuSpecSplatUtility_h_
#define _vuSpecSplatUtility_h_

#include "../vuBasicUtility.h"
#include "../../wxUIElements/vuTFDialogSpec.h"
#include "../../wxUIElements/vuLightDial.h"
#include "vuCamera.h"
#include "Volume/Regular/Unimodal/3d/1B/Intensity/SpecSplat/specsplat.h"
#include "vuTFunc/vuTFDesignSpec.h"

class vuSpecSplat : public vuBasicUtility
{
public:
    //!Constructor
    vuSpecSplat();
    //!Destructor
    ~vuSpecSplat();

    //!Returns the type of vu Datafile that the utility works with
    static const char* getFileType();

    //!Initializes the splatter utility.
    /*!Initializes the utility window.  A splatting object is created and
       the volume data is read.  The window appears when finished.
    */
    bool init(const char* DataFile);

    //! Updates the view by calling m_glCanvas->redraw()
    virtual void notifyDataChanged();

    /** Rerenders the screen from the current camera position. */
    virtual void DrawAgain ();

    /** Draws on the screen the image contained in the image buffer. */
    virtual void DrawFromImage ();

    /** This will return a pointer to the image buffer that is being
        used by the method to draw images to... */
    virtual vuImage* getCurrentImage ();

    /** This will return a poiunter to the camera that the method is using
        (note that this may be derived from vuCamera...) */
    virtual vuCamera* getCamera ();
    
 protected:
    //!Initializes open gl for the splatter utility.
    /*!The method calls the splatter initgl() method so it can do the
       proper initialization.
    */
    bool glInit();
    //!Calls on the splatter to render the volume.
    /*!The method calls the splatter render() method, setting it up to
       render to the window's gl canvas.
    */
    void glRender();
    //!Resizes the gl viewport and renders the volume.
    void glResize();
    //!Handles mouse commands from the user.
    /*!The mouse is the main interface between the user and the utility
       at the moment.  This method receives mouse events from the window,
       and carries out commands.
    */
    void glOnMouse(wxMouseEvent &ev);

private:
    //!The splatter owned by the utility.
    vu1112115 *m_Data;
    //!A camera class for storing the user's current view.
    vuCamera m_Camera;
    //!The zoom magnification of the splatter.
    float m_ViewScale;
    //!the transfer function
    vuTFDesignSpec m_TFunc;
    //!The dialog to edit the transfer function
    vuTFDialogSpec m_TFDialog;
    //!The light dialer.
    vuLightDial m_LightDial;

    //!The width of the window.
    int m_x;
    //!The height of the window.
    int m_y;
    
    DECLARE_EVENT_TABLE()
};

#endif
