// Author:	Steven Bergner
// Created:	Oct01

#ifndef _vuSpectralFVRUtility_h_
#define _vuSpectralFVRUtility_h_

#include "../vuBasicUtility.h"
#include "../../wxUIElements/vuTransferCanvas.h"
#include "../../wxUIElements/vuTFDialogSpec.h"
#include "../../wxUIElements/vuLightDial.h"
#include "../../wxUIElements/vuSpecPalette.h"
#include "vuCamera.h"
#include "Volume/Regular/Unimodal/3d/1B/Intensity/SpecFVR/specfvr.h"
#include "vuTFunc/vuTFDesignSpec.h"
#include "vuPreviewWin.h"

//!A utility window for fourier volume rendering with a spectral color model
class vuSpecFVR : public vuBasicUtility
{
    enum {
	idDOSPECULAR,
	idDRAWPREV,
    };
public:
    //!Constructor
    vuSpecFVR();
    //!Destructor
    ~vuSpecFVR();

    //!Returns the type of vu Datafile that the utility works with
    static const char* getFileType();

    /*!Initializes the utility window.  A object is created and
       the volume data is read.  The window appears when finished.
    */
    bool init(const char* DataFile);

    //! external update trigger, virtual from some parent class
    void notifyDataChanged();

    virtual vuCamera* getCamera ();
    virtual vuImage* getCurrentImage ();
    virtual void DrawFromImage ();
    virtual void DrawAgain();

    //! handle some GUI events (idDOSPECULAR, idDRAWPREV)
    void handleGUIevent(wxCommandEvent& ev);
public:
    //The following methods are overridden to add controls to the window.
    //!This method adds controls to the bottom of the window.
    virtual void addRight(wxSizer *sizer);

protected:
    /**Initializes open gl for the utility.
       The method calls the initgl() method so it can do the
       proper initialization.
    */
    bool glInit();

    /*!The method calls the render() method, setting it up to
       render to the window's gl canvas.
    */
    void glRender();
    //!Resizes the gl viewport and renders the volume.
    void glResize();
    //!Handles mouse commands from the user.
    /*!The mouse is the main interface between the user and the utility
       at the moment.  This method receives mouse events from the window,
       and carries out commands.
    */
    void glOnMouse(wxMouseEvent &ev);

    /** keyboard handler */
    void OnChar(wxKeyEvent& event);

    /** event handler for the light property sliders. */
    void OnSlideLight( wxScrollEvent& event);
    /** initiate a refresh of the rendering */
    void OnButtonRender( wxCommandEvent& event);
    /** initiate a refresh of the rendering */
    void OnButtonTransform( wxCommandEvent& event);
    /** set light direction from current observer to centre of the volume */
    void OnButtonLightPos(wxCommandEvent& ev);
	
private:
    //!The spectral raycaster owned by the utility.
    vu1112118 *m_Data;
    /** The transfer function.  This is not yet used because 
        the TF don't yet operate on spectral colours.*/
    vuTFDesignSpec m_TFunc;
    vuTFDialogSpec m_TFuncDlg;
    vuLightDial	   m_LightDial;
        
    
    /** Slider to control the properties of the light.
	Calls the event handler OnSlideLight(). */
    wxSlider *m_LightColour, *m_LightIntensity;

    //!The width of the window.
    int m_x;
    //!The height of the window.
    int m_y;

    /** bounging box flag. 
	Draw a bounding box (using OpenGL) instead of blitting 
	the scene view. OLD because of vuPreviewWin. */
    bool m_DrawBBox;

    //!This is a handle for a preview box.
    vuPreviewWin *m_Preview;

    DECLARE_EVENT_TABLE()
};

#endif
