#include <wx/wx.h>
#include <wx/button.h>

#include "vuSpecFVR.h"
#include "vuColourRGBa.h"
#include "vuMatrix.h"
#include "vuArcBall.h"
#include "vuPreviewWin.h"
#include "vuColour31a.h"
#include "vuColour7a.h"

//----------------------------------------------------------------------------
//------------------------- The vuSpecFVR event table -----------------------
//----------------------------------------------------------------------------

enum
{
    idCANVAS,
    idRENDER,
    idLOADSETUP,
    idLGTINT,
    idLGTCOL,
    idLIGHTPOS,
    idTRANSFORM,
};

BEGIN_EVENT_TABLE(vuSpecFVR, vuBasicUtility)
    EVT_COMMAND_SCROLL(idLGTINT, vuSpecFVR::OnSlideLight)
    EVT_COMMAND_SCROLL(idLGTCOL, vuSpecFVR::OnSlideLight)
    EVT_BUTTON  (idRENDER, vuSpecFVR::OnButtonRender)
    EVT_BUTTON  (idLIGHTPOS, vuSpecFVR::OnButtonLightPos)
    EVT_BUTTON  (idTRANSFORM, vuSpecFVR::OnButtonTransform)
END_EVENT_TABLE();

//----------------------------------------------------------------------------
//------------------------- The constructor ----------------------------------
//----------------------------------------------------------------------------

vuSpecFVR::vuSpecFVR() : m_TFunc(32), m_TFuncDlg(this, m_TFunc),
			   m_LightDial(this, m_TFunc)
{
    m_Data = NULL;
    m_DrawBBox = false;
}

//----------------------------------------------------------------------------
//------------------------- The destructor -----------------------------------
//----------------------------------------------------------------------------

vuSpecFVR::~vuSpecFVR()
{
    if (m_Data != 0) delete m_Data;
}

//----------------------------------------------------------------------------
//------------------------- public: getFileType() ----------------------------
//----------------------------------------------------------------------------

const char* vuSpecFVR::getFileType()
{
    return "11121";
}

//----------------------------------------------------------------------------
//------------------------- public: init() -----------------------------------
//----------------------------------------------------------------------------

bool vuSpecFVR::init(const char* DataFile)
{
    //Set up the window
    SetTitle("Spectral Volume Rendering");
    CreateStatusBar();


    //Create a volume data instance.
    m_Data = new vu1112118;
    m_Data->setFileName(DataFile);

    //Set the transfer function for the data.
    m_TFunc.addOpacity(  0, 0.0f);
    m_TFunc.addOpacity(255, 1.0f);
    m_TFunc.addColour(  0,vuColour31a(0.0f));
    m_TFunc.addColour(255,vuColour31a(1.0f));
    m_TFunc.setOpacitySmoothing(0);
    m_TFunc.setColourSmoothing(1.0f);
    m_TFunc.generateFunction();
    //don't set it yet
    //m_Data->setTransferFunc(m_TFunc);

    //Read in the data.
    bool success = m_Data->read();
    if (success)
    {
        m_glCanvas->SetSize(512,512);
        Fit();
/*
	m_Preview->attachCamera(&m_Data->getCamera());
	m_Preview->setCubeSize(m_Data->getDim1Size(),
			       m_Data->getDim2Size(),
			       m_Data->getDim3Size());
*/
    }
    else
    {
        wxMessageDialog dlg(this,m_Data->getErrorMessage(),"vuSpecFVRVR",wxOK);
        dlg.ShowModal();
    }

    return success;
}

//----------------------------------------------------------------------------
//------------------------- public: addRight() -------------------------------
//----------------------------------------------------------------------------

void vuSpecFVR::addRight(wxSizer *sizer)
{
  //Add some control elements
    sizer->Add( new wxButton(this, idRENDER, "Render"),
		0,           // make horizontally unstretchable
		wxALL,       // make border all around (implicit top alignment)
		10 );        // set border width to 10
    sizer->Add( new wxButton(this, idLIGHTPOS, "Place Light"),
		0, wxALL, 10 );
    sizer->Add( new wxButton(this, idTRANSFORM, "Preprocess"),
		0, wxALL, 10 );
}

//----------------------------------------------------------------------------
//------------------------- public: OnSlideLight() -----------------
//----------------------------------------------------------------------------

void vuSpecFVR::OnSlideLight( wxScrollEvent& event)
{
    // int w = m_LightColour->GetValue();
    //int l = m_LightIntensity->GetValue();
  m_glCanvas->redraw();
}

//----------------------------------------------------------------------------
//------------------------- public: OnButtonRender() -------------------------
//----------------------------------------------------------------------------

void vuSpecFVR::OnButtonRender( wxCommandEvent& event)
{
    m_Data->doRefresh();
    m_glCanvas->redraw();
}

void vuSpecFVR::OnButtonTransform( wxCommandEvent& event)
{
    m_Data->doSpectral();	// enable spectral transfer functions
    m_Data->setTransferFunc(m_TFunc);
    m_Data->preprocess();
    m_Data->doRefresh();
    m_glCanvas->redraw();
}

/** keyboard handler */
void vuSpecFVR::OnChar(wxKeyEvent& event)
{
    m_Data->keyboard(event.GetKeyCode(),0,0);
    m_glCanvas->redraw();
}

void vuSpecFVR::notifyDataChanged()
{
    m_glCanvas->redraw();
}

//----------------------------------------------------------------------------
//------------------------- protected: glInit() ------------------------------
//----------------------------------------------------------------------------

bool vuSpecFVR::glInit(void)
{
    if (m_Data == 0) return false;
  /*
    glClearColor(0.0f, 0.0f, 0.0f, 0.0f);

    glEnable(GL_LIGHTING);
    glEnable(GL_LIGHT0);
    glLightModeli(GL_LIGHT_MODEL_TWO_SIDE, GL_TRUE);
  */
    glEnable(GL_DEPTH_TEST);
    glDepthFunc(GL_LESS);

    return true;
};

//----------------------------------------------------------------------------
//------------------------- protected: glRender() ----------------------------
//----------------------------------------------------------------------------
void vuSpecFVR::glRender()
{
    if(m_TFuncDlg.isUpdated() || m_LightDial.isUpdated()) {
	m_TFuncDlg.unsetUpdated();
	vuColour31a light(m_TFunc.getLight());
	//light /= vuColourXYZa(light)[1]; no constant light intensity
	m_Data->setLight(light);
	m_Data->doSpectral();	//enable spectral transfer function
	m_Data->setTransferFunc(m_TFunc);
    }
    
    wxStopWatch watch;
    watch.Start();
    
    glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    glOrtho(0,m_glCanvas->getWidth(),
	        0,m_glCanvas->getHeight(),-1,1);
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
    
    m_Data->render();
    
    watch.Pause();
    SetStatusText(wxString("Render Time: ") + vuString(watch.Time()).c_str() + "ms");
}


//----------------------------------------------------------------------------
//------------------------- protected: glResize() ----------------------------
//----------------------------------------------------------------------------

void vuSpecFVR::glResize()
{
    glViewport(0, 0, (GLint)m_glCanvas->getWidth(),(GLint)m_glCanvas->getHeight());
    m_Data->resize(m_glCanvas->getWidth(),m_glCanvas->getHeight());
}

//----------------------------------------------------------------------------
//------------------------- protected: glOnMouse() ---------------------------
//----------------------------------------------------------------------------

void vuSpecFVR::glOnMouse(wxMouseEvent &ev)
{
    if(!m_Data) return;
    if (ev.LeftDown() || ev.RightDown())
    {
        //Store the click position.
        m_x = (int) ev.GetX();
        m_y = (int) ev.GetY();
    }
    else if (ev.LeftIsDown() && ev.Moving())
    {
        //Rotate the volume
        vuVector t = m_Data->getCamera().getPosition()-m_Data->getCenter();
        float d = t.norm();
        m_Data->getCamera().translateXYZ(0.0f, 0.0f, d);
	t = m_Data->getCamera().getPosition();
	//use the arc ball
	vuArcBall ball;
	ball.attachCamera(m_Data->getCamera());
	ball.setWinSize(m_glCanvas->getWidth(),m_glCanvas->getHeight());
	ball.turn(m_x, m_y, ev.GetX(), ev.GetY());
        //m_Data->getCamera().rotateAboutUp(ev.GetX() - m_x);
        //m_Data->getCamera().rotateAboutRight(ev.GetY() - m_y);
        m_Data->getCamera().translateXYZ(0.0f, 0.0f, -d);
	m_Data->doRefresh();
        m_glCanvas->redraw();
	
        //Store the click position.
        m_x = (int) ev.GetX();
        m_y = (int) ev.GetY();
    }
    else if (ev.LeftDClick())
    {
        m_TFuncDlg.Show(true);
    } else if (ev.RightDClick())
    {
        m_LightDial.Show(true);
    } 
}

vuCamera* vuSpecFVR::getCamera ()
{
    return &m_Data->getCamera();
}

vuImage* vuSpecFVR::getCurrentImage ()

{
	return m_Data->getImage ();
//	return NULL;
}

void vuSpecFVR::DrawAgain()

{
//	cout << "vuRaycast::notifyDataChanged ()" << endl;

    m_Data->doRefresh();
    m_glCanvas->redraw();
    
//	glRender ();
}

void vuSpecFVR::DrawFromImage ()

{
//	m_Data->displayFromImage ();
//	m_Data->render ();
	m_glCanvas->redraw ();
}

void vuSpecFVR::handleGUIevent(wxCommandEvent& ev)
{
    switch(ev.GetId()) {
	default:
	    break;
    }
}

void vuSpecFVR::OnButtonLightPos(wxCommandEvent& ev) {
    vuVector v(m_Data->getCenter());
    v-=getCamera()->getPosition();
    v.makeUnit();
    v*=-1.0f;
    m_Data->setLightDir(v);
}
