// Author:	Steven Bergner
// Created:	Jan02

#ifndef _vuSlicerUtility_h_
#define _vuSlicerUtility_h_

#include "../vuBasicUtility.h"
#include "../../wxUIElements/vuTransferCanvas.h"
#include "Volume/Regular/Unimodal/3d/1B/Intensity/Slicer/Slicer.h"

//!A utility window for the slicer
class vuSlicer : public vuBasicUtility
{
public:
    //!Constructor
    vuSlicer();
    //!Destructor
    ~vuSlicer();

    //!Returns the type of vu Datafile that the utility works with
    static const char* getFileType();

    /*!Initializes the utility window.  A object is created and
       the volume data is read.  The window appears when finished.
    */
    bool init(const char* DataFile);

    virtual vuCamera* getCamera ();
    virtual vuImage* getCurrentImage ();
    virtual void DrawFromImage ();
    virtual void DrawAgain();

public:
    //The following methods are overridden to add controls to the window.
    //!This method adds controls to the bottom of the window.
    virtual void addRight(wxSizer *sizer);

protected:
    /**Initializes open gl for the utility.
       The method calls the initgl() method so it can do the
       proper initialization.
    */
    bool glInit();

    /*!The method calls the render() method, setting it up to
       render to the window's gl canvas.
    */
    void glRender();
    //!Resizes the gl viewport and renders the volume.
    void glResize();
    //!Handles mouse commands from the user.
    /*!The mouse is the main interface between the user and the utility
       at the moment.  This method receives mouse events from the window,
       and carries out commands.
    */
    void glOnMouse(wxMouseEvent &ev);

    /** Keyboard handler.
	Overridden from vuBasicUtility. As implemented so far 'V' will write out
	file viewpoint.def containing current viewpoint information and 'v' will
	read in this file to restore viewpoint.
    */
    void OnChar(wxKeyEvent& event);

    /** event handler for the slice slider. */
    void OnSlideSlice( wxScrollEvent& event);

 private:
    //!The spectral raycaster owned by the utility.
    vu1112116 *m_Data;
    /** The transfer function. */
    vuTFDesign m_TFunc;

    /** Slider to select a slice
	Calls the event handler OnSlideSlice(). */
    wxSlider *m_SliceSlider;

    //! mouse x
    int m_x;
    //! mouse y
    int m_y;

    DECLARE_EVENT_TABLE()
};

#endif
