#include "vuSlicer.h"

#include "vuPreviewWin.h"
#include "vuCamera.h"

#include "../../wxUIElements/vuTransferDialog.h"

#define SLIDER_MAX 10000
//----------------------------------------------------------------------------
//------------------------- The vuSlicer event table --------------------------
//----------------------------------------------------------------------------

enum
{
  idCANVAS,
  idSLIDESLICE
};

BEGIN_EVENT_TABLE(vuSlicer, vuBasicUtility)
   EVT_COMMAND_SCROLL(idSLIDESLICE, vuSlicer::OnSlideSlice)
END_EVENT_TABLE();

//----------------------------------------------------------------------------
//------------------------- The constructor ----------------------------------
//----------------------------------------------------------------------------

vuSlicer::vuSlicer()
{
    m_Data = NULL;
}

//----------------------------------------------------------------------------
//------------------------- The destructor -----------------------------------
//----------------------------------------------------------------------------

vuSlicer::~vuSlicer()
{
    if (m_Data != 0) delete m_Data;
}

//----------------------------------------------------------------------------
//------------------------- public: getFileType() ----------------------------
//----------------------------------------------------------------------------

const char* vuSlicer::getFileType()
{
    return "11121";
}

//----------------------------------------------------------------------------
//------------------------- public: init() -----------------------------------
//----------------------------------------------------------------------------

bool vuSlicer::init(const char* DataFile)
{
    SetEvtHandlerEnabled(true);

    //Set up the window
    SetTitle("Slicer");
    CreateStatusBar();

    //Create a volume data instance.
    m_Data = new vu1112116;
    m_Data->setFileName(DataFile);


    //make a colourful transfer function
    m_TFunc.addOpacity(1,0.0);
    m_TFunc.addOpacity(255,1.0);
    m_TFunc.addColour(0,vuColourRGBa(0.0f));
    m_TFunc.addColour(64,vuColourRGBa(0,0,1));
    m_TFunc.addColour(128,vuColourRGBa(0,1,1));
    m_TFunc.addColour(196,vuColourRGBa(1,1,0));
    m_TFunc.addColour(255,vuColourRGBa(1,0,0));
    m_TFunc.setOpacitySmoothing(0);
    m_TFunc.setColourSmoothing(0.25);
    m_TFunc.generateFunction();
    m_Data->setTransferFunc(m_TFunc);

    //Read in the data.
    bool success = m_Data->read();
    if (success)
    {
        m_glCanvas->SetSize(512,512);
        Fit();
    }
    else
    {
        wxMessageDialog dlg(this,m_Data->getErrorMessage(),"vuSlicer",wxOK);
        dlg.ShowModal();
    }

    return success;
}

//----------------------------------------------------------------------------
//------------------------- public: addRight() -------------------------------
//----------------------------------------------------------------------------

void vuSlicer::addRight(wxSizer *sizer)
{
  //Add some control elements
  sizer->Add( new wxStaticText( this, -1, "Slice", wxDefaultPosition, wxSize(50,20)),
	      0,            // make vertically stretchable
	      wxEXPAND,     // make horizontally stretchable
	      5 );         // set border width to
  
  sizer->Add( m_SliceSlider = new wxSlider(this, idSLIDESLICE, 0, 0, SLIDER_MAX, 
					   wxDefaultPosition, wxSize(30,300), wxSL_VERTICAL, 
					   wxDefaultValidator, "slider"),1,wxALL,10 );
}

//----------------------------------------------------------------------------
//------------------------- protected: glInit() ------------------------------
//----------------------------------------------------------------------------

bool vuSlicer::glInit(void)
{
    if (m_Data == 0) return false;
    m_Data->initOpenGL();
    return true;
};

//----------------------------------------------------------------------------
//------------------------- protected: glRender() ----------------------------
//----------------------------------------------------------------------------

void vuSlicer::glRender()
{
    
    m_Data->render();
    
};

//----------------------------------------------------------------------------
//------------------------- protected: glResize() ----------------------------
//----------------------------------------------------------------------------

void vuSlicer::glResize()
{
    m_Data->setImageSize(m_glCanvas->getWidth(),m_glCanvas->getHeight());
    m_glCanvas->redraw();
}

//----------------------------------------------------------------------------
//------------------------- protected: glOnMouse() ---------------------------
//----------------------------------------------------------------------------

void vuSlicer::glOnMouse(wxMouseEvent &ev)
{
    if(!m_Data) return;
    if (ev.LeftDown() || ev.RightDown())
    {
        //Store the click position.
        m_x = (int) ev.GetX();
        m_y = (int) ev.GetY();
	vuVector pos;
	m_Data->getPosition(pos);
	pos[0] = m_x;
	pos[1] = m_glCanvas->getHeight()-m_y;
	m_Data->setPosition(pos);
    }
    else if (ev.LeftIsDown() && ev.Moving())
    {
        //Store the click position.
        m_x = (int) ev.GetX();
        m_y = (int) ev.GetY();
    }
    else if (ev.LeftDClick())
    {
        //Pop up the transfer function editor
        vuTransferDialog dlg(this,m_TFunc);

        if (dlg.ShowModal() == wxID_OK)
        {
	    m_TFunc = dlg.getTransferFunc();
            m_Data->setTransferFunc(m_TFunc);
            m_glCanvas->redraw();
        }
    } else 
      {
	vuVector pos;
	m_Data->getPosition(pos);
        m_x = (int) ev.GetX();
        m_y = (int) ev.GetY();
	pos[0] = m_x;
	pos[1] = m_glCanvas->getHeight()-m_y;
	if(m_Data->isInside(pos))
	{
	    char msg[1024];
	    sprintf(msg,"pos %0.0fx %0.0fy %0.0fz  value %d",pos[0],pos[1],pos[2],
		    (int)m_Data->getValue(pos));
	    SetStatusText(wxString(msg));
	}
      }
}

//------------------------------------------------------------------------------
// event handler for the slice slider
void vuSlicer::OnSlideSlice( wxScrollEvent& event)
{
    vuVector pos;
    m_Data->getPosition(pos);
    pos[2] = m_SliceSlider->GetValue()*m_Data->getDim3Size()/SLIDER_MAX;
    m_Data->setPosition(pos);
    m_glCanvas->redraw();	    
    
    if(m_Data->isInside(pos))
    {
	char msg[1024];
	sprintf(msg,"pos %0.0fx %0.0fy %0.0fz  value %d",pos[0],pos[1],pos[2],
		(int)m_Data->getValue(pos));
	SetStatusText(wxString(msg));
    }
}

//--------------------------------------------------------------------------------------
/** keyboard handler */
void vuSlicer::OnChar(wxKeyEvent& event)
{
    vuVector pos;
    switch(event.GetKeyCode()) {
	case '+' :
	    m_Data->getPosition(pos);
	    pos += vuVector(0,0,1);
	    m_Data->setPosition(pos);
	    m_glCanvas->redraw();	    
	    break;
	case '-' :
	    m_Data->getPosition(pos);
	    pos -= vuVector(0,0,1);
	    m_Data->setPosition(pos);
	    m_glCanvas->redraw();	    
	    break;
    }

    if(m_Data->isInside(pos))
    {
	char msg[1024];
	sprintf(msg,"pos %0.0fx %0.0fy %0.0fz  value %d",pos[0],pos[1],pos[2],
		(int)m_Data->getValue(pos));
	SetStatusText(wxString(msg));
	m_SliceSlider->SetValue(int(pos[2]*SLIDER_MAX/m_Data->getDim3Size()));
    }
}

vuCamera* vuSlicer::getCamera ()
{
    return NULL;
}

vuImage* vuSlicer::getCurrentImage ()

{
//	return m_Data->getImage ();
	return NULL;
}

void vuSlicer::DrawAgain()

{
//	cout << "vuRaycast::notifyDataChanged ()" << endl;

//	m_Data->doRefresh();
//	m_glCanvas->redraw();

//	glRender ();
}

void vuSlicer::DrawFromImage ()

{
//	m_Data->displayFromImage ();
//	m_Data->render ();
//	m_glCanvas->redraw ();
}
