//!A utility window for shear-warp
// Author:	Sebastian Zambal
// Created:	Feb02
/*!
   Derived from vuSplat Utility.
*/

#ifndef _vuShearWarpUtility_h_
#define _vuShearWarpUtility_h_

#include "../vuBasicUtility.h"
#include "../../wxUIElements/vuTransferCanvas.h"
#include "vuCamera.h"
#include "Volume/Regular/Unimodal/3d/1B/Intensity/ShearWarp/shearWarp.h"

class vuShearWarp : public vuBasicUtility
{
public:
    //!Constructor
    vuShearWarp();
    //!Destructor
    ~vuShearWarp();

    //!Returns the type of vu Datafile that the utility works with
    static const char* getFileType();

    /*!Initializes the utility window.  An object is created and
       the volume data is read.  The window appears when finished.
    */
    bool init(const char* DataFile);

public:
    //The following methods are overridden to add controls to the window.
    //!This method adds controls to the bottom of the window.
    virtual void addBottom(wxSizer *sizer);
    //The following methods are overridden to add controls to the window.
    //!This method adds controls to the left part of the window.
    virtual void addLeft(wxSizer *sizer);

    virtual void DrawAgain();
    virtual void DrawFromImage();
    virtual vuCamera *getCamera();
    virtual vuImage *getCurrentImage();

protected:
    //!Initializes open gl for the utility.
    /*!The method calls the initgl() method so it can do the
       proper initialization.
    */
    bool glInit();

    /*!The method calls the render() method, setting it up to
       render to the window's gl canvas.
    */
    void glRender();
    //!Resizes the gl viewport and renders the volume.
    void glResize();
    //!Handles mouse commands from the user.
    /*!The mouse is the main interface between the user and the utility
       at the moment.  This method receives mouse events from the window,
       and carries out commands.
    */
    void glOnMouse(wxMouseEvent &ev);
    void OnButtonTransferFunction( wxCommandEvent& event);
    void OnButtonApplyViewing( wxCommandEvent& event);
    void OnRadioBoxProjection( wxCommandEvent& event);
#if wxMINOR_VERSION < 5
    void OnScrollPerspective( wxCommandEvent& event);
#else
    void OnScrollPerspective( wxScrollEvent& event);
#endif
    void OnCheckBoxFastClassification( wxCommandEvent& event);
    void OnCheckBoxSpecular( wxCommandEvent& event);
    void OnCheckBoxWarpOpenGL( wxCommandEvent& event);

private:
    //!The shear-warp owned by the utility.
    vu111211A *m_Data;
    //!Text-fields for X-, Y- and Z-Coordinates of the viewing vector
    wxTextCtrl *viewXTextCtrl;
    wxTextCtrl *viewYTextCtrl;
    wxTextCtrl *viewZTextCtrl;
    //!Text-fields for X-, Y- and Z-Coordinates of the up vector
    wxTextCtrl *upXTextCtrl;
    wxTextCtrl *upYTextCtrl;
    wxTextCtrl *upZTextCtrl;
    //!Button for applying the viewing settings
    wxButton *applyViewingButton;
    //!CheckBox for turning on/off fast classification
    wxCheckBox *fastClassCheckBox;
    //!CheckBox for turning on/off specular light
    wxCheckBox *specularCheckBox;
    //!2 Radio Boxes for choosing beetween orthogonal and perspective projection
    wxRadioBox *projectionRadioBox;
    //!A camera class for storing the user's current view
    vuCamera m_Camera;
    //!The zoom magnification of the shear-warp.
    float m_ViewScale;
    //!The transfer function to be applied to the shear-warp.
    vuTFDesign m_TFunc;

    wxSlider *m_LightColour, *m_LightIntensity;

    //!The width of the window.
    int m_x;
    //!The height of the window.
    int m_y;
    
    DECLARE_EVENT_TABLE()
};

#endif









