// Author:	Steven Bergner
// Created:	Oct01

#ifndef _vuRaycastUtility_h_
#define _vuRaycastUtility_h_

#include <wx/textctrl.h>
#include <wx/checkbox.h>

#include "../vuBasicUtility.h"
#include "../../wxUIElements/vuTransferDialog.h"
#include "vuCamera.h"
#include "Volume/Regular/Unimodal/3d/1B/Intensity/Raycast/Raycast.h"
#include "vuTFunc/vuTFDesign.h"
#include "vuPreviewWin.h"

//using namespace ns_vu1112113;

//!A utility window for RGBa raycasting
class vuRaycast : public vuBasicUtility
{
public:
    //!Constructor
    vuRaycast();
    //!Destructor
    ~vuRaycast();

    //!Returns the type of vu Datafile that the utility works with
    static const char* getFileType();

    /*!Initializes the utility window.  A object is created and
       the volume data is read.  The window appears when finished.
    */
    bool init(const char* DataFile);

    virtual vuCamera* getCamera ();
    virtual vuImage* getCurrentImage ();
    virtual void DrawFromImage ();
//    virtual void setCamera (vuCamera* cam);

public:
    //The following methods are overridden to add controls to the window.
    //!This method adds controls to the bottom of the window.
    virtual void addRight(wxSizer *sizer);

    virtual void DrawAgain();

protected:
    /**Initializes open gl for the utility.
       The method calls the initgl() method so it can do the
       proper initialization.
    */
    bool glInit();

    /*!The method calls the render() method, setting it up to
       render to the window's gl canvas.

       It "automagically" creates a preview now -ms-.
    */
    void onRender();
    //!Resizes the gl viewport and renders the volume.
    void glResize();
    //!Handles mouse commands from the user.
    /*!The mouse is the main interface between the user and the utility
       at the moment.  This method receives mouse events from the window,
       and carries out commands.
    */
    void onMouse(wxMouseEvent &ev);

    /** initiate a refresh of the rendering */
    void OnButtonRender( wxCommandEvent& event);
    /** Called if sampling distance has been changed. */
#if wxMINOR_VERSION < 5
    void OnChangeSampDist( void );
#else
    void OnChangeSampDist(wxCommandEvent&);
#endif
    /** Called if someone's checking the checkbox. */
#if wxMINOR_VERSION < 5
    void OnCheckBoxPreDraw( void );
#else
    void OnCheckBoxPreDraw(wxCommandEvent&);
#endif
    /** Called if someone's checking the checkbox for specular shading. */
#if wxMINOR_VERSION < 5
    void OnCheckBoxDoSpec( void );
#else
    void OnCheckBoxDoSpec(wxCommandEvent&);
#endif
    /** Changes the method for evaluating the transfer function */
#if wxMINOR_VERSION < 5
    void OnSelectTFunc();
#else
    void OnSelectTFunc(wxCommandEvent&);
#endif
    
    /** Keyboard handler.
	Overridden from vuBasicUtility. As implemented so far 'V' will write out
	file viewpoint.def containing current viewpoint information and 'v' will
	read in this file to restore viewpoint.
    */
    void onKeyboard(wxKeyEvent& event);

    //!returns a pointer to m_Data
    vu1 *vuRaycast::getVolume();

private:
    //!The raycaster owned by the utility.
    vu1112113 *m_Data;
    /** The transfer function. */
    vuTFDesign m_TFunc;
    /** The transfer function dialog. */
    vuTransferDialog m_TFuncDlg;

    //!This is a handle for a preview box.
    vuPreviewWin *m_Preview;

    //! for changing sampling distance
    wxTextCtrl *m_TCsmpDist;
    
    //! setting the state for preview drawing and specular shading
    wxCheckBox *m_CBdoSpec, *m_CBdrawPrev;

    //! list of the different methods for evaluating the transfer function
    wxListBox *m_TFuncList;
    
    DECLARE_EVENT_TABLE()
};

#endif
