#include "vuRaycast.h"

#include <fstream.h>

#include "vuColourRGBa.h"
#include "vuMatrix.h"
#include "vuArcBall.h"
#include "vuPreviewWin.h"
#include "vuCamera.h"

#include "../../wxUIElements/vuTransferDialog.h"
#include <wx/button.h>

//----------------------------------------------------------------------------
//------------------------- The vuRaycast event table --------------------------
//----------------------------------------------------------------------------

enum
{
  idCANVAS,
  idRENDER,
  idPREDRAW,
  idDOSPEC,
  idSMPDIST,
  idTFUNC
};

BEGIN_EVENT_TABLE(vuRaycast, vuBasicUtility)
    EVT_BUTTON  (idRENDER, vuRaycast::OnButtonRender)
    EVT_CHECKBOX(idPREDRAW, vuRaycast::OnCheckBoxPreDraw)
    EVT_CHECKBOX(idDOSPEC, vuRaycast::OnCheckBoxDoSpec)
    EVT_TEXT_ENTER(idSMPDIST, vuRaycast::OnChangeSampDist)
    EVT_LISTBOX(idTFUNC, vuRaycast::OnSelectTFunc) 
END_EVENT_TABLE();

//----------------------------------------------------------------------------
//------------------------- The constructor ----------------------------------
//----------------------------------------------------------------------------

vuRaycast::vuRaycast() : m_TFunc(4,256), m_TFuncDlg(this, m_TFunc)
{
    m_Data = NULL;
}

//----------------------------------------------------------------------------
//------------------------- The destructor -----------------------------------
//----------------------------------------------------------------------------

vuRaycast::~vuRaycast()
{
    if (m_Data != 0) delete m_Data;
}

//----------------------------------------------------------------------------
//------------------------- public: getFileType() ----------------------------
//----------------------------------------------------------------------------

const char* vuRaycast::getFileType()
{
    return "11121";
}

//----------------------------------------------------------------------------
//------------------------- public: init() -----------------------------------
//----------------------------------------------------------------------------

bool vuRaycast::init(const char* DataFile)
{
    SetEvtHandlerEnabled(true);

    //Set up the window
    SetTitle("RGB Raycaster");
    CreateStatusBar();


    //Create a volume data instance.
    m_Data = new vu1112113;
    m_Data->setFileName(DataFile);

    //Set the transfer function for the data.
    m_TFunc.addOpacity(1,0.01);
    m_TFunc.addOpacity(11,0.01);
    m_TFunc.addOpacity(12,1);
    m_TFunc.addOpacity(32,1);
    m_TFunc.addColour(1,vuColourRGBa(0.f));
    m_TFunc.addColour(11,vuColourRGBa(1.f));
    m_TFunc.addColour(32,vuColourRGBa(0.f,0.f,0.6f));
    m_TFunc.setOpacitySmoothing(0);
    m_TFunc.setColourSmoothing(0);

    m_TFunc.generateFunction();
    m_Data->setTransferFunc(m_TFunc);
    m_Data->doPreviewDraw(true);
    m_Data->getCamera().translateXYZ(0.0f, 0.0f, 64);

    //Read in the data.
    bool success = m_Data->read();
    if (success)
    {
        m_glCanvas->SetSize(512,512);
        Fit();
	m_Preview->attachCamera(&m_Data->getCamera());
	m_Preview->setCubeSize(m_Data->getDim1Size(),m_Data->getDim2Size(),m_Data->getDim3Size());
    }
    else
    {
        wxMessageDialog dlg(this,m_Data->getErrorMessage(),"vuRaycastVR",wxOK);
        dlg.ShowModal();
    }
    return success;
}

vuCamera* vuRaycast::getCamera ()

{
	return m_Data->getCameraPtr ();
}

vuImage* vuRaycast::getCurrentImage ()

{
	return m_Data->getImage ();
//	return NULL;
}

/*
void vuRaycast::setCamera (vuCamera* cam)

{

}*/

//----------------------------------------------------------------------------
//------------------------- public: addRight() -------------------------------
//----------------------------------------------------------------------------

void vuRaycast::addRight(wxSizer *sizer)
{
  //Add some control elements
  sizer->Add( new wxButton(this, idRENDER, "Render"),
		 0,           // make horizontally unstretchable
		 wxALL,       // make border all around (implicit top alignment)
		 10 );        // set border width to 10
  wxSize size(35,-1);
  m_TCsmpDist = new wxTextCtrl(this,idSMPDIST,"1.00", wxDefaultPosition,size,
			       wxTE_PROCESS_ENTER|wxTE_PROCESS_TAB,
			       wxTextValidator(wxFILTER_NUMERIC));
  m_CBdoSpec = new wxCheckBox(this,idDOSPEC,"do specular");
  m_CBdoSpec->SetValue(false);
  m_CBdrawPrev = new wxCheckBox(this,idPREDRAW,"draw preview");
  m_CBdrawPrev->SetValue(true);
  m_TFuncList = new wxListBox(this, idTFUNC, wxDefaultPosition,wxSize(150,70),0,
			      NULL,wxLB_SINGLE);
  m_TFuncList->Append("per sample");
  m_TFuncList->Append("per segment");
  m_TFuncList->Append("alpha weighted");
  
  sizer->Add( m_CBdrawPrev,0,wxALL|wxALIGN_LEFT,1);
  sizer->Add( m_CBdoSpec,0,wxALL|wxALIGN_LEFT,1);
  sizer->Add(new wxStaticText(this,-1,"sampling distance:"),0,wxALL|wxALIGN_LEFT,1);
  sizer->Add( m_TCsmpDist,0,wxALL|wxALIGN_LEFT,1);
  sizer->Add(new wxStaticText(this,-1,"transfer function"),0,wxALL|wxALIGN_LEFT,1);
  sizer->Add( m_TFuncList,0,wxALL|wxALIGN_LEFT,1);
  
  m_Preview = new vuPreviewWin(this,200,200);
  sizer->Add( m_Preview, 
	      1,           // make horizontally stretchable
	      wxALL,       // make border all around (implicit top alignment)
	      10 );        // set border width to 10

}

void vuRaycast::DrawAgain()

{
  	m_Data->doRefresh();
	m_glCanvas->redraw();
}

void vuRaycast::DrawFromImage ()

{
//	m_Data->displayFromImage ();
//	m_Data->render ();
	m_glCanvas->redraw();
}

//----------------------------------------------------------------------------
//------------------------- public: OnButtonRender() -------------------------
//----------------------------------------------------------------------------

void vuRaycast::OnButtonRender( wxCommandEvent& event)
{
  m_DrawPreview = false;
  m_Data->doRefresh();
  m_glCanvas->redraw();
}

#if wxMINOR_VERSION < 5
void vuRaycast::OnCheckBoxPreDraw()
#else
void vuRaycast::OnCheckBoxPreDraw(wxCommandEvent&)
#endif
{
  m_Data->doPreviewDraw(m_CBdrawPrev->GetValue());
}

#if wxMINOR_VERSION < 5
void vuRaycast::OnCheckBoxDoSpec()
#else
void vuRaycast::OnCheckBoxDoSpec(wxCommandEvent&)
#endif
{
  m_Data->doSpecular(m_CBdoSpec->GetValue());
}

#if wxMINOR_VERSION < 5
void vuRaycast::OnChangeSampDist()
#else
void vuRaycast::OnChangeSampDist(wxCommandEvent&)
#endif
{
  double val;
  m_TCsmpDist->GetValue().ToDouble(&val);
  m_Data->setSamplingDistance(val);
  m_TCsmpDist->SetValue(wxString::Format("%.2f",val));
}

#if wxMINOR_VERSION < 5
void vuRaycast::OnSelectTFunc()
#else
void vuRaycast::OnSelectTFunc(wxCommandEvent&)
#endif
{
    wxArrayInt sel;
    if(m_TFuncList->GetSelections(sel))
    {
	m_Data->setTFuncMethod(sel[0]);
    }
}

//----------------------------------------------------------------------------
//------------------------- protected: glInit() ------------------------------
//----------------------------------------------------------------------------

bool vuRaycast::glInit(void)
{
    if (m_Data == 0) return false;
  /*
    glClearColor(0.0f, 0.0f, 0.0f, 0.0f);

    glEnable(GL_LIGHTING);
    glEnable(GL_LIGHT0);
    glLightModeli(GL_LIGHT_MODEL_TWO_SIDE, GL_TRUE);
  */
    glEnable(GL_DEPTH_TEST);
    glDepthFunc(GL_LESS);
    m_Data->initOpenGL();
    return true;
};

//----------------------------------------------------------------------------
//------------------------- protected: onRender() ----------------------------
//----------------------------------------------------------------------------

void vuRaycast::onRender()
{
  m_Data->setTransferFunc(m_TFunc);	// better once too often :-|
  glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  glOrtho(0,m_Data->getCamera().getWidth(),
	  0,m_Data->getCamera().getHeight(), -1, 1);
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();

  wxStopWatch watch;
  watch.Start();
  m_Data->render();
  m_Data->displayFromImage();
  watch.Pause();
  SetStatusText(wxString("Render Time: ") + vuString(watch.Time()).c_str() + "ms");
};

//----------------------------------------------------------------------------
//------------------------- protected: glResize() ----------------------------
//----------------------------------------------------------------------------

void vuRaycast::glResize()
{
    glViewport(0, 0, (GLint)m_glCanvas->getWidth(),(GLint)m_glCanvas->getHeight());
    m_Data->setImageSize(m_glCanvas->getWidth(),m_glCanvas->getHeight());
  
	//Set the viewport.
	//glViewport(0, m_glCanvas->getHeight()-m_Data->getCamera().getHeight(), 
	//		   (GLint)m_Data->getCamera().getWidth(), (GLint)m_Data->getCamera().getHeight());

    //Set the viewport.
    
/*
    //Find the largest dimension of the data.
    dword max = m_Data->getDim1Size();
    if (m_Data->getDim2Size() > max)
        max = m_Data->getDim2Size();
    if (m_Data->getDim3Size() > max)
        max = m_Data->getDim3Size();

    //Set the opengl projection matrix.
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    glOrtho((float)max/(-1.0f*m_ViewScale), (float)max/m_ViewScale,
            (float)max/(-1.0f*m_ViewScale), (float)max/m_ViewScale,
            10000.0f, -10000.0f);
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
    
    //Set the opengl light info.
    float lpos[4] = {0.0, 0.0, 1024.0, 1.0};m_Data->m_Camera
    glLightfv(GL_LIGHT0, GL_POSITION, lpos);
  */
}

//----------------------------------------------------------------------------
//------------------------- protected: onMouse() ---------------------------
//----------------------------------------------------------------------------

void vuRaycast::onMouse(wxMouseEvent &ev)
{
  // here is the place for additional mouse bevaviour.
  if(!m_Data) return;

  if (ev.LeftDClick()) {
    m_TFuncDlg.Show(true);
  }
}


//--------------------------------------------------------------------------------------
/** keyboard handler */
void vuRaycast::onKeyboard(wxKeyEvent& event)
{
  static char *filename = "viewpoint.def";

  switch(event.GetKeyCode()) {
  case 'v' :
    {
      //load viewpoint definition
      ifstream file(filename);
      if(file) {
	vuCamera& cam = m_Data->getCamera();
	vuVector v;
	file>>v[0]; file>>v[1]; file>>v[2];
	cam.setPosition(v);
	file>>v[0]; file>>v[1]; file>>v[2];
	cam.setLookAtVector(v);
	file>>v[0]; file>>v[1]; file>>v[2];
	cam.setUpVector(v);
	cout<< "read "<<filename<<endl;
      }
    }
    break;
  case 'V' :
    {
      //save viewpoint definition
      ofstream file(filename);
      if(file) {
	vuCamera& cam = m_Data->getCamera();
	vuVector v = cam.getPosition();
	file<<v[0]<<' '; file<<v[1]<<' '; file<<v[2]<<endl;
	v = cam.getLookAtVector();
	file<<v[0]<<' '; file<<v[1]<<' '; file<<v[2]<<endl;
	v = cam.getUpVector();
	file<<v[0]<<' '; file<<v[1]<<' '; file<<v[2]<<endl;
	cout<< "wrote "<<filename<<endl;
      }
    }
    break;
  }
}

vu1 *vuRaycast::getVolume()
{
  return (vu1 *)m_Data;
}
