#ifndef _VU_SIMPLE_FBR_UTILITY_H_
#define _VU_SIMPLE_FBR_UTILITY_H_

#include <wx/wx.h>
#include "../../vuBasicUtility.h"
#include "vuCamera.h"
#include "Volume/Lightfield/Unimodal/Spheric/IBR/ibr.h"
#include "Volume/Lightfield/Unimodal/Spheric/IBR/vuSphericInteractive.h"
#include "General/vuLightfield/SphericViewFilter/vuSphVwFlt_Fourier.h"
#include "General/vuFourier/vuFourierFilter/vuTorstensFourierFilter.h"
#include "General/vuLightfield/SphericViewFilter/vuSliceFilter.h"
#include "../../../wxUIElements/vuFBRSubViewer.h"

template <int SIZE, class TYPE>
class vuSimpleFBR : public vuBasicUtility
{
protected:
  enum {
    idPREPROCESS,
    idFILTER,
    idFILTERHINT,   // hint for 'Fit Angle' or 'Nearest' lightfield filter
    idFOURIERFILTER,
    idSLICEFILTERKIND,
    idSLICEFILTER,
    idSLICEFILTERSIZE,
    idLOWPASS,
    idRENDERMETHOD,
    idSNAP2VIEW,
    idIMAGESCALE,
    idIMAGEBIAS,
    idFITSCALE,
    idSHOWSUBWINDOW,
    idINTERACT_RECONST,
    idCHANNELS,
    idRESET,
    idFILL,
    idSAVE
  };

public:
    //!Constructor
    vuSimpleFBR();

    //!Destructor
    ~vuSimpleFBR();

    virtual const char *_titleString();

    /*!Initializes the utility window.  A object is created and
       the volume data is read.  The window appears when finished.
    */
    bool init(const char* DataFile);

public:
    //The following methods are overridden to add controls to the window.
    //!This method adds controls to the bottom of the window.
    virtual void addRight(wxSizer *sizer);

protected:
    /**Initializes open gl for the utility.
       The method calls the initgl() method so it can do the
       proper initialization.
    */
    bool glInit();

    //!The method calls the render() method.
    void glRender();

    //!Resizes the gl viewport and renders the volume.
    void glResize();

    //!Handles mouse commands from the user.
    void onMouse(wxMouseEvent &ev);

    //!Keyboard handler.
    void onKeyboard(wxKeyEvent& event);

    //!returns a pointer to m_Data
    vu1 *getVolume();

    /* --- some GUI callbacks ---------------------------------------------- */

    //! Filter Choice callback
    void OnChoiceFilter(wxCommandEvent& event);

    //!Fourier Filter Choice callback
    void OnChoiceFourierFilter(wxCommandEvent& event);

    //!Preprocess Button callback
    void OnButtonPreprocess(wxCommandEvent& event);

    //!Interactive Preprocessing Reset callback
    void OnButtonReset(wxCommandEvent& event);

    //!Interactive Preprocessing Fill callback
    void vuSimpleFBR::OnButtonFill(wxCommandEvent& event);

    //!Snap2View Button callback
    void OnButtonSnap2View(wxCommandEvent& event);

    //!Show subwindow callback
    void OnButtonShowSubWindow(wxCommandEvent& event);

    //! render method choice callback
    void OnChoiceRenderMethod(wxCommandEvent& event);

    //! image scale slider callback
    void OnSliderImageScale(wxScrollEvent& event);

    //! fit scale and bias callback
    void OnButtonFitScale(wxCommandEvent& event);

    //! save to file callback
    void OnButtonSave(wxCommandEvent& event);

    //! interactive reconstruction checkbox callback
    void OnCheckboxInteractiveReconst(wxCommandEvent& event);

    //! channel checkbox list callback
    void OnCheckboxChannels(wxCommandEvent& event);

private:
    vuSphVwFlt_Fourier<SIZE,TYPE> *getFourierViewFilter();
    void _updateFourierFilter();
    bool _updateViewFilter(bool isPreprocess);
    bool _updateSliceFilter();

    void _filterHintTextUpdate();
    void _resetInteractivePreprocessing();
    void _addViewWithIndex(dword idx);

    void _addChannelControls(wxFlexGridSizer *sizer);
    void _interactiveReconstruction();
    void _renderImage();
    void _displayImage();

protected:
    //!The lightfield volume owned by the utility.
    vu1611_2<SIZE,TYPE>             *m_Data;
    vuFixelMap<SIZE,float>          *m_Image;
    vuSphericInteractive<SIZE,TYPE> *m_Interactive;
    vuFBRSubViewer<SIZE,TYPE>       *m_FBRsubViewer;

    vuTorstensFourierFilter *m_FourierFilter; // interpolation while rendering
    vuSliceFilter           *m_SliceFilter;   // interpolation while creating

    bool *m_AlreadyVisisted; // needed for interactive reconstruction

private:
    // Some wxWindows GUI Elements...
    //!Filter Choice
    wxTextCtrl        *m_TEXTfilterHint;
    wxChoice          *m_CHOICEfilter;
    wxChoice          *m_CHOICEfourierFilter;
    wxChoice          *m_CHOICEsliceFilter;
    wxChoice          *m_CHOICEsliceFilterKind;
    wxChoice          *m_CHOICEsliceFilterSize;
    wxChoice          *m_CHOICElowPass;
    wxChoice          *m_CHOICErenderMethod;
    wxCheckBox        *m_CHECKBOXinteractiveReconst;
    wxCheckBox       **m_CHECKBOXchannels;
    wxButton          *m_BUTTONfitScale;
    wxButton          *m_BUTTONpreprocess;
    wxButton          *m_BUTTONreset;
    wxButton          *m_BUTTONfill;
    wxButton          *m_BUTTONsave;
    wxSlider          *m_SLIDERimageScale;
    wxBoxSizer        *m_SIZERpreprocess;
    wxBoxSizer        *m_SIZERhint;

public:
    virtual vuCamera* getCamera();
    virtual vuImage* getCurrentImage();
    virtual void DrawFromImage();
    virtual void DrawAgain();
};


template class vuSimpleFBR<1,byte>;
template class vuSimpleFBR<3,byte>;
//template vuSimpleFBR<1,float>;
//template vuSimpleFBR<2,float>;
//template vuSimpleFBR<3,float>;

#endif /* _VU_SIMPLE_FBR_UTILITY_H_ */
