#ifndef _VU_SPHERIC_REVOLVER_UTILITY_H_
#define _VU_SPHERIC_REVOLVER_UTILITY_H_

#include <wx/wx.h>
#include "../../vuBasicUtility.h"
#include "vuCamera.h"
#include "Volume/Lightfield/Unimodal/Spheric/IBR/ibr.h"

//!A utility window for Image Based Rendering of lightfields
template <int SIZE, class TYPE>
class vuSphericRevolver : public vuBasicUtility
{
protected:
enum
  {
    idNUMBEROFVIEWS,
    idIMAGESCALE,
    idIMAGESCALE2ONE
  };

public:
    //!Constructor
    vuSphericRevolver();

    //!Destructor
    ~vuSphericRevolver();

    virtual const char *_titleString();

    /*!Initializes the utility window.  A object is created and
       the volume data is read.  The window appears when finished.
    */
    bool init(const char* DataFile);

public:
    virtual void addBottom(wxSizer *sizer);

protected:
    /**Initializes open gl for the utility.
       The method calls the initgl() method so it can do the
       proper initialization.
    */
    bool glInit();

    //!The method calls the render() method.
    void glRender();

    //!Resizes the gl viewport and renders the volume.
    void glResize();

    //!Handles mouse commands from the user.
    void onMouse(wxMouseEvent &ev);

    //!Keyboard handler.
    void onKeyboard(wxKeyEvent& event);

    wxString helpText();

    //!returns a pointer to m_Data
    vu1 *getVolume();

    /* --- some GUI callbacks ---------------------------------------------- */
    //!'Choose number of views' - callback
    void OnChoiceNumberOfViews(wxCommandEvent& event);

    /** event handler for image scaler. */
    void OnScaleImage(wxScrollEvent& event);

    /** event handler for scale image to one button */
#if wxMINOR_VERSION < 5
    void OnScaleImage2One(wxScrollEvent& event);
#else
    void OnScaleImage2One(wxCommandEvent& event);
#endif

private:
    void _updateScaleAndRefresh(int scale);

protected:
    //!The lightfield volume owned by the utility.
    vu1611_2<SIZE,TYPE> *m_Data;

private:
    // Some wxWindows GUI Elements...
    wxChoice *m_CHOICEnumberOfViews;
    wxSlider *m_ImageScale;

public:
    virtual vuCamera* getCamera();
    virtual vuImage* getCurrentImage();
    virtual void DrawFromImage();
    virtual void DrawAgain();
};


template class vuSphericRevolver<1,byte>;
template class vuSphericRevolver<2,byte>;
template class vuSphericRevolver<3,byte>;
template class vuSphericRevolver<1,float>;
template class vuSphericRevolver<2,float>;
template class vuSphericRevolver<3,float>;

#endif /* _VU_SPHERIC_REVOLVER_UTILITY_H_ */
