#ifndef _VU_SPHERIC_IBR_UTILITY_H_
#define _VU_SPHERIC_IBR_UTILITY_H_

#include <wx/wx.h>
#include "../../vuBasicUtility.h"
#include "vuCamera.h"
#include "Volume/Lightfield/Unimodal/Spheric/IBR/ibr.h"
#include "../../../wxUIElements/vuSphericViewWin.h"
#include "../../../vuPreviewWin.h"

//!A utility window for Image Based Rendering of lightfields
template <int SIZE, class TYPE>
class vuSphericIBR : public vuBasicUtility
{
protected:
enum
  {
    idFILTER,
    idSUBFILTER
  };

public:
    //!Constructor
    vuSphericIBR();

    //!Destructor
    ~vuSphericIBR();

    virtual const char *_titleString();

    /*!Initializes the utility window.  A object is created and
       the volume data is read.  The window appears when finished.
    */
    bool init(const char* DataFile);

public:
    //The following methods are overridden to add controls to the window.
    //!This method adds controls to the bottom of the window.
    virtual void addRight(wxSizer *sizer);

protected:
    /**Initializes open gl for the utility.
       The method calls the initgl() method so it can do the
       proper initialization.
    */
    bool glInit();

    //!The method calls the render() method.
    void glRender();

    //!Resizes the gl viewport and renders the volume.
    void glResize();

    //!Handles mouse commands from the user.
    void onMouse(wxMouseEvent &ev);

    //!Keyboard handler.
    void onKeyboard(wxKeyEvent& event);

    //!returns a pointer to m_Data
    vu1 *getVolume();

    /* --- some GUI callbacks ---------------------------------------------- */
    //!Filter Choice callback
    void OnChoiceFilter(wxCommandEvent& event);

    //!Filter Choice callback
    void OnChoiceSubFilter(wxCommandEvent& event);

private:
    void _updateSubFilterChoice();

protected:
    //!The lightfield volume owned by the utility.
    vu1611_2<SIZE,TYPE> *m_Data;

private:
    // Some wxWindows GUI Elements...
    //!Filter Choice
    wxChoice         *m_CHOICEfilter;
    wxChoice         *m_CHOICEsubFilter;
    vuSphericViewWin *m_SphericView;
    vuPreviewWin     *m_Preview;

public:
    virtual vuCamera* getCamera();
    virtual vuImage* getCurrentImage();
    virtual void DrawFromImage();
    virtual void DrawAgain();
};


template class vuSphericIBR<1,byte>;
template class vuSphericIBR<2,byte>;
template class vuSphericIBR<3,byte>;
template class vuSphericIBR<1,float>;
template class vuSphericIBR<2,float>;
template class vuSphericIBR<3,float>;

#endif /* _VU_SPHERIC_IBR_UTILITY_H_ */
