#include "vuSphericIBR.h"
#include "Volume/Lightfield/Unimodal/Spheric/vuSphericFilterFactory.h"
#include "General/vuLightfield/vuSphericViewFilterFactory.h"

template <int SIZE, class TYPE>
vuSphericIBR<SIZE,TYPE>::vuSphericIBR()
{
  m_Data = NULL;
}

template <int SIZE, class TYPE>
vuSphericIBR<SIZE,TYPE>::~vuSphericIBR()
{
  CHECKNDELETE(m_Data);
}

template <int SIZE, class TYPE>
const char *vuSphericIBR<SIZE,TYPE>::_titleString()
{
  return "Image Based Renderer";
}

template <int SIZE, class TYPE>
bool vuSphericIBR<SIZE,TYPE>::init(const char* DataFile)
{
  SetEvtHandlerEnabled(true);

  //Set up the window
  SetTitle(_titleString());
  CreateStatusBar();

  //Create a volume data instance.
  // the "m_Data = new vu1611?2" is called by child classes
  m_Data->setFileName(DataFile);

  //Read in the data.
  bool success = m_Data->read();
  if (success) {
    m_glCanvas->SetSize(752,512);
    vuString str;
    str  = _titleString();
    str += ": [";
    str += m_Data->getWidth();
    str += "x";
    str += m_Data->getHeight();
    str += "] x ";
    str += m_Data->getNumberOfViews();
    str += " Views <";
    str += SIZE;
    str += " ";
    str += m_Data->_typeName();
    str += ">";
    SetTitle(str.c_str());
    Fit();
    m_SphericView->setVolume(m_Data);
    //m_Preview->attachCamera(&m_Data->getCamera());
    //m_Preview->setCubeSize(50,50,50);
  }
  else {
    wxMessageDialog dlg(this,m_Data->getErrorMessage(),
			"vuSphericIBR",wxOK);
    dlg.ShowModal();
  }
  return success;
}


/* ------------------------------------------------------------------------ */
/* --- add some ui elements ----------------------------------------------- */
/* ------------------------------------------------------------------------ */

template <int SIZE, class TYPE>
void vuSphericIBR<SIZE,TYPE>::addRight(wxSizer *sizer)
{
  m_CHOICEfilter = 
    new wxChoice(this, idFILTER, wxDefaultPosition, wxSize(100,-1),
		 0, NULL, wxMAXIMIZE_BOX, wxDefaultValidator, "Filter");

  m_CHOICEsubFilter = 
    new wxChoice(this, idSUBFILTER, wxDefaultPosition, wxSize(100,-1),
		 0, NULL, wxMAXIMIZE_BOX, wxDefaultValidator, "SubFilter");

  
  {
    // lightfield filter choice
    dword    count        = 0;
    vuString *filterNames = NULL;

    vuSphericFilterFactory<SIZE,TYPE>::getFilterNames(filterNames, count);
    for (dword i=0; i<count; i++) {
      m_CHOICEfilter->Append(filterNames[i].c_str());    
    }
    m_CHOICEfilter->SetSelection(0);

  
    // view filter choice
    vuSphericViewFilterFactory<SIZE,TYPE>::getFilterNames(filterNames, count);
    for (dword i=0; i<count; i++) {
      m_CHOICEsubFilter->Append(filterNames[i].c_str());    
    }
    m_CHOICEsubFilter->SetSelection(0);
  }


  sizer->Add(new wxStaticText(this, -1, "Filter:", wxDefaultPosition,
			      wxSize(60,-1),wxALIGN_LEFT),0,wxEXPAND, 5);
  sizer->Add(m_CHOICEfilter,0,wxALL|wxALIGN_LEFT,1);

  sizer->Add(new wxStaticText(this, -1, "Sub Filter:", wxDefaultPosition,
			      wxSize(80,-1),wxALIGN_LEFT),0,wxEXPAND, 5);

  sizer->Add(m_CHOICEsubFilter,0,wxALL|wxALIGN_LEFT,1);

  m_SphericView = new vuSphericViewWin(this,200,200);
  sizer->Add( m_SphericView, 
	      1,       // make horizontally stretchable
	      wxALL,   // make border all around (implicit top alignment)
	      10 );    // set border width to 10
#if 0
  m_Preview = new vuPreviewWin(this,200,200);
  sizer->Add( m_Preview, 
	      1,           // make horizontally stretchable
	      wxALL,       // make border all around (implicit top alignment)
	      10 );        // set border width to 10
#endif
}

template <int SIZE, class TYPE>
bool vuSphericIBR<SIZE,TYPE>::glInit()
{
  if (m_Data == NULL) return false;
  m_Data->initOpenGL();
  return true;
}

template <int SIZE, class TYPE>
void vuSphericIBR<SIZE,TYPE>::glRender()
{
  wxStopWatch watch;

  watch.Start();
  m_Data->render();
  watch.Pause();

  m_SphericView->redraw();
  //m_Preview->redraw();

  SetStatusText(wxString("Render Time: ")+vuString(watch.Time()).c_str() +
		"ms");
}

template <int SIZE, class TYPE>
void vuSphericIBR<SIZE,TYPE>::glResize()
{
  m_Data->glResize(m_glCanvas->getWidth(), m_glCanvas->getHeight());
}

template <int SIZE, class TYPE>
void vuSphericIBR<SIZE,TYPE>::onMouse(wxMouseEvent &ev)
{
  // here is the place for additional mouse bevaviour.
}

template <int SIZE, class TYPE>
void vuSphericIBR<SIZE,TYPE>::onKeyboard(wxKeyEvent& event)
{
}

template <int SIZE, class TYPE>
vu1 *vuSphericIBR<SIZE,TYPE>::getVolume()
{
  return (vu1 *)m_Data;
}

/* --------------------------------------------------------------------- */
/* --- some GUI callbacks ---------------------------------------------- */
/* --------------------------------------------------------------------- */

template <int SIZE, class TYPE>
void vuSphericIBR<SIZE,TYPE>::OnChoiceFilter(wxCommandEvent& event)
{
  dword idx = m_CHOICEfilter->GetSelection();
 
  m_Data->setFilter(vuSphericFilterFactory<SIZE,TYPE>::getFilter(idx));

  m_Data->setIsReRendering(true);
  m_glCanvas->redraw();
}

template <int SIZE, class TYPE>
void vuSphericIBR<SIZE,TYPE>::OnChoiceSubFilter(wxCommandEvent& event)
{
  dword idx = m_CHOICEsubFilter->GetSelection();
 
  m_Data->setViewFilter(vuSphericViewFilterFactory<SIZE,TYPE>::getFilter(idx));

  m_Data->setIsReRendering(true);
  m_glCanvas->redraw();
}

template <int SIZE, class TYPE>
vuCamera* vuSphericIBR<SIZE,TYPE>::getCamera()
{
  return m_Data->getCameraPtr ();
}

template <int SIZE, class TYPE>
vuImage* vuSphericIBR<SIZE,TYPE>::getCurrentImage()
{
  return NULL;
}

template <int SIZE, class TYPE>
void vuSphericIBR<SIZE,TYPE>::DrawFromImage()
{
  m_glCanvas->redraw ();
}

template <int SIZE, class TYPE>
void vuSphericIBR<SIZE,TYPE>::DrawAgain()
{
}
