//!A utility template for browsing spherical lightfields

#ifndef _VU_SPHERIC_BROWSER_H_
#define _VU_SPHERIC_BROWSER_H_

#include "../../vuBasicUtility.h"
#include "Volume/Lightfield/Unimodal/Spheric/Browser/browser.h"

template<int SIZE,class TYPE>
class vuSphericBrowser : public vuBasicUtility
{
protected:

enum
{
  idBROWSELIGHTFIELD,
  idIMAGESCALE,
  idIMAGESCALE2ONE
};

public:
    //!Constructor
    vuSphericBrowser();

    //!Destructor
    ~vuSphericBrowser();

    virtual const char *_titleString();

    /*!Initializes the utility window.  A object is created and
       the volume data is read.  The window appears when finished.
    */
    virtual bool init(const char* DataFile);

    // These functions are needed by the keyframer. But since the keyframer
    // should work directly on the render objects and not on the GUI, these
    // functions should be replaced by an additional renderer-API. -ms-
    virtual vuCamera* getCamera();
    virtual vuImage* getCurrentImage();
    virtual void DrawFromImage();
    virtual void DrawAgain();

    //! return own help text
    wxString helpText();

public:
    //The following methods are overridden to add controls to the window.
    //!This method adds controls to the bottom of the window.
    virtual void addRight(wxSizer *sizer);
    virtual void addBottom(wxSizer *sizer);

protected:
    /**Initializes open gl for the utility.
       The method calls the initgl() method so it can do the
       proper initialization.
    */
    bool glInit();

    /*!The method calls the render() method, setting it up to
       render to the window's gl canvas.
    */
    void glRender();

    //!Resizes the gl viewport and renders the volume.

    void glResize();

    void glOnMouse(wxMouseEvent &ev);

    /** additional keyboard handler functionality */
    void OnChar(wxKeyEvent &event);

    /** event handler for the lightfield browser. */
    void OnBrowseViews(wxScrollEvent& event);

    /** event handler for image scaler. */
    void OnScaleImage(wxScrollEvent& event);

    /** event handler for scale image to one button */
#if wxMINOR_VERSION < 5
    void OnScaleImage2One(wxScrollEvent& event);
#else
    void OnScaleImage2One(wxCommandEvent& event);
#endif
    
    /** internal method for refreshing the content */
    void _updateIndexAndRefresh(dword idx);

    /** internal method for refreshing the image scaling */
    void _updateScaleAndRefresh(int scale);

 protected:
    //!The spectral raycaster owned by the utility.
    vu1611_1<SIZE,TYPE> *m_Data;

    /** Slider to select a view
	Calls the event handler OnBrowseViews(). */
    wxSlider     *m_ViewSlider;
    wxSlider     *m_ImageScale;

    //** Static Text -> displays the number of views */
    wxStaticText *m_ViewsText;
};

template class vuSphericBrowser<1,byte>;
template class vuSphericBrowser<2,byte>;
template class vuSphericBrowser<3,byte>;
template class vuSphericBrowser<1,float>;
template class vuSphericBrowser<2,float>;
template class vuSphericBrowser<3,float>;

#endif  /* _VU_SPHERIC_BROWSER_H_ */
