/*	Modified April 2002
	Modified by Christopher Steinbach

	Modified to work on the IRIXes... the casts were causing errors.
*/

#ifndef _vuGUIPARSER_H_
#define _vuGUIPARSER_H_

#include "vuParser.h"

//!Parses gui script files into separate sections and generates the corresponding utility.

/*!This is the main class for the vuTextGui program.  It accepts the filename
   of the gui script file, then parses and interprets the script.  The text
   file is interpreted by sections, with an api section, and widget define
   sections.  The syntax for this is described in the vuTextGui documentation.

   The current implementation outputs the gui utility implementation as it
   read the script file.  This was done to keep the difficulty of the coding
   in line with the importance of the text gui, ie not to overkill on design.
   The parser is therefore relatively simple and keeps to the task at hand.
*/

class vuGuiParser : public vuParser
{
public:
	/** default constructor, does nothing */
    vuGuiParser();
    	/** destrustor, does nothing */
    ~vuGuiParser();

    //!Parses the given gui script file, and generates the corresponding class.
    void Parse(const char* filename) throw (const char *);

private:

    //!Parses a gui declaration.
    void ParseGui();
    //!Parses the different sections of a gui declaration.
    void ParseSections();

    //!Parses the API section of the gui declaration.
    void ParseAPIs();
    //!Parses the init section of the gui declaration.
    void ParseControls(const char *Location);

    //!Parses a listbox declaration.
    /*!The method parses a listbox define statement.  It adds the name of the
       control to the control list, and generates the statements to initialize
       the control.  The initialization statements are returned in a string.

       \return The c++ statements needed to create and initialize the control.
    */
    vuString ParseListBox(const char *Name);
    //!Parses a slider declaration.
    /*!The method parses a slider define statement.  It adds the name of the
       control to the control list, and generates the statements to initialize
       the control.  The initialization statements are returned in a string.

       \return The c++ statements needed to create and initialize the control.
    */
    vuString ParseSlider(const char *Name);
    //!Parses a button declaration.
    /*!The method parses a button define statement.  It adds the name of the
       control to the control list, and generates the statements to initialize
       the control.  The initialization statements are returned in a string.

       \return The c++ statements needed to create and initialize the control.
    */
    vuString ParseButton(const char *Name);
    //!Parse a checkbox declaration.
    /*!The method parses a checkbox define statement.  It adds the name of the
       control to the control list, and generates the statements to initialize
       the control.  The initialization statements are returned in a string.

       \return The c++ statements needed to create and initialize the control.
    */
    vuString ParseCheckBox(const char *Name);
    //!Parse a radiobox declaration.
    /*!The method parses a radiobox define statement.  It adds the name of the
       control to the control list, and generates the statements to initialize
       the control.  The initialization statements are returned in a string.

       \return The c++ statements needed to create and initialize the control.
    */
    vuString ParseRadioBox(const char *Name);

    //!Parses a block of code from the file and writes it as a method to the output file.
    void ParseMethod(const char *Header);
    //!Parses a statement from the file and translates it into a method call.
    /*!\return The c++ statement corresponding to the text scrip statement
    */
    vuString ParseStatement();
    //!Parses a list of identifiers from the file.
    /*!\return A string list of the identifiers.
    */
    StringList ParseList();

    //!Writes the accumulated control data to the files.
    /*!This method writes out the statements common to all controls.  It declares
       the controls in the header file, defines enum identifiers for their
       respective events, and registers the events.
    */
    void WriteData();
   
private:
    //!The output header file for the generated gui class.
    ofstream m_fHeader;
    //!The output implemenation file for the generated gui class.
    ofstream m_fImpl;
    
    //!The name of the gui that is being read.
    vuString m_Name;
    //!The utility base class that the gui is derived from.
    vuString m_Base;
    //!The header files to be included for the gui class.
    StringList m_Apis;
    //!The names of the defined controls
    StringList m_Controls;
};

#endif
