//!A utility template for the standard fourier volume renderin

#ifndef _VU_STANDARD_FVR_H_
#define _VU_STANDARD_FVR_H_

#include "../../vuBasicUtility.h"
#include "Volume/Fourier/Unimodal/3d/StandardFVR/StandardFVR.h"

template<int SIZE>
class vuStandardFVR : public vuBasicUtility
{
protected:

enum
{
  idFILTER,
  idRENDERMETHOD,
  idIMAGESCALE,
  idFITSCALE,
  idCHANNELS
};

public:
    //!Constructor
    vuStandardFVR();

    //!Destructor
    ~vuStandardFVR();

    virtual const char *_titleString();

    /*!Initializes the utility window.  A object is created and
       the volume data is read.  The window appears when finished.
    */
    virtual bool init(const char* DataFile);

    // These functions are needed by the keyframer. But since the keyframer
    // should work directly on the render objects and not on the GUI, these
    // functions should be replaced by an additional renderer-API. -ms-
    virtual vuCamera* getCamera();
    virtual vuImage* getCurrentImage();
    virtual void DrawFromImage();
    virtual void DrawAgain();

    //! return own help text
    wxString helpText();

public:
    //The following methods are overridden to add controls to the window.
    //!This method adds controls to the bottom of the window.
    virtual void addRight(wxSizer *sizer);
    virtual void addBottom(wxSizer *sizer);

protected:
    /**Initializes open gl for the utility.
       The method calls the initgl() method so it can do the
       proper initialization.
    */
    bool glInit();

    /*!The method calls the render() method, setting it up to
       render to the window's gl canvas.
    */
    void glRender();

    //!Resizes the gl viewport and renders the volume.

    void glResize();

    //! Callbacks
    void onKeyboard(wxKeyEvent &event);

    void OnChoiceRenderMethod(wxCommandEvent& event);
    void OnChoiceFilter(wxCommandEvent& event);
    void OnButtonFitScale(wxCommandEvent& event);
    void OnSliderImageScale(wxScrollEvent& event);
    void OnCheckboxChannels(wxCommandEvent& event);

    vu1* getVolume();

    void _addChannelControls(wxFlexGridSizer *sizer);

 protected:
    //!The spectral raycaster owned by the utility.
    vu1712_1<SIZE> *m_Data;

    // UI interface
    wxChoice    *m_CHOICEfilter;
    wxChoice    *m_CHOICErenderMethod;
    wxButton    *m_BUTTONfitScale;
    wxSlider    *m_SLIDERimageScale;
    wxCheckBox **m_CHECKBOXchannels;
};

template class vuStandardFVR<1>;
template class vuStandardFVR<2>;
template class vuStandardFVR<3>;

#endif  /* _VU_STANDARD_FVR_H_ */
