#include "vuStandardFVR.h"
#include "General/vuFourier/vuFourierFilter/vuTorstensFourierFilter.h"

template<int SIZE>
vuStandardFVR<SIZE>::vuStandardFVR()
{
  m_Data = NULL;
}

template<int SIZE>
vuStandardFVR<SIZE>::~vuStandardFVR()
{
  if (m_Data != NULL) {
    delete m_Data;
    m_Data = NULL;
  }
}

template<int SIZE>
const char *vuStandardFVR<SIZE>::_titleString()
{
  return "Standard Fourier Volume Renderer";
}

template<int SIZE>
bool vuStandardFVR<SIZE>::init(const char* DataFile)
{
  SetEvtHandlerEnabled(true);

  //Set up the window
  SetTitle(_titleString());
  CreateStatusBar();

  m_Data = new vu1712_1<SIZE>;
  m_Data->setFileName(DataFile);
  m_Data->setFilter(vuTorstensFourierFilter::getFilter("d0_c0_1ef"));

  //Read in the data.
  bool success = m_Data->read();
  if (success) {
    m_glCanvas->SetSize(512,512);
    vuString str;
    str  = _titleString();
    str += ": [";
    str += m_Data->getXSize() - 2 * m_Data->getWrap();
    str += "x";
    str += m_Data->getYSize() - 2 * m_Data->getWrap();
    str += "x";
    str += m_Data->getZSize() - 2 * m_Data->getWrap();
    str += "] <";
    str += SIZE;
    str += " ";
    str += "float>";
    SetTitle(str.c_str());
    Fit();
  }
  else {
    wxMessageDialog dlg(this,m_Data->getErrorMessage(),
			_titleString(), wxOK);
    dlg.ShowModal();
  }
  return success;
}

template<int SIZE>
vuCamera* vuStandardFVR<SIZE>::getCamera()
{
  return NULL;
}

template<int SIZE>
vuImage* vuStandardFVR<SIZE>::getCurrentImage()
{
  return NULL;
}

template<int SIZE>
void vuStandardFVR<SIZE>::DrawFromImage()
{
}

template<int SIZE>
void vuStandardFVR<SIZE>::DrawAgain()
{
}

template<int SIZE>
wxString vuStandardFVR<SIZE>::helpText()
{
  wxString str("");

  str += 
    "\t ?\t\t\t\t this help window\n"
    "\t UP\t\t\t previous view\n"
    "\t DOWN\t\t\t next view\n"
    "\t LEFT\t\t\t decrease image scaling\n"
    "\t RIGHT\t\t\t increase image scaling\n"
    "\t SHIFT+LEFT\t\t slowly decrease image scaling\n"
    "\t SHIFT+RIGHT\t\t slowly increase image scaling\n"
    "\t SPACE\t\t\t set image scaling to one (same as 'fit' button)\n";

  return str;
}

template<int SIZE>
void vuStandardFVR<SIZE>::addRight(wxSizer *sizer)
{
}

template<int SIZE>
void vuStandardFVR<SIZE>::addBottom(wxSizer *sizer)
{
  wxBoxSizer *horSpacer = new wxBoxSizer(wxHORIZONTAL);
  wxBoxSizer *verSpacer = new wxBoxSizer(wxVERTICAL);

  // --- rendering interface ------------------------------------------------

  wxFlexGridSizer *grid = new wxFlexGridSizer(2,5,5);

  // interpolation filter for slicing
  {
    dword    count        = 0;
    vuString *filterNames = NULL;
    
    m_CHOICEfilter = 
      new wxChoice(this, idFILTER, wxDefaultPosition, wxSize(130,20),
		   0, NULL, wxCAPTION, wxDefaultValidator, "Filter");

    vuTorstensFourierFilter::getFilterNames(filterNames, count);
    for (dword i=0; i< count; i++) {
      if (filterNames[i].hasPrefix("d0"))
	m_CHOICEfilter->Append(filterNames[i].c_str());
    }
    m_CHOICEfilter->SetSelection(0);
  }

  // render method choice
  {
    m_CHOICErenderMethod =
      new wxChoice(this, idRENDERMETHOD, wxDefaultPosition, wxSize(130,20),
		   0, NULL, wxCAPTION, wxDefaultValidator, "RenderMethod");

    m_CHOICErenderMethod->Append("Spatial");
    m_CHOICErenderMethod->Append("Freq. Amplitude ");
    m_CHOICErenderMethod->Append("Freq. Phase");
    m_CHOICErenderMethod->Append("Freq. Real");
    m_CHOICErenderMethod->Append("Freq. Imaginary");

    m_CHOICErenderMethod->SetSelection(0);
  }

  // image scale factor
  {
    m_SLIDERimageScale =
      new wxSlider(this, idIMAGESCALE, 1, 1, 10000, wxDefaultPosition,
		   wxSize(106,16), wxSL_HORIZONTAL, 
		   wxDefaultValidator, "imageScaleSlider");
    m_SLIDERimageScale->SetValue(2550);
  }

  // image scale fit button
  {
    m_BUTTONfitScale = new wxButton(this,idFITSCALE,"fit",
				    wxPoint(0,0),wxSize(20,16));
  }

  wxBoxSizer *scaleSizer = new wxBoxSizer(wxHORIZONTAL);
  scaleSizer->Add(m_SLIDERimageScale);
  scaleSizer->Add(2,0);
  scaleSizer->Add(m_BUTTONfitScale);
  
  grid->Add(80,5);
  grid->Add(0, 5);
  grid->Add(new wxStaticText(this, -1, "Filter:"), 0, wxALIGN_RIGHT);
  grid->Add(m_CHOICEfilter,0,wxALL|wxALIGN_LEFT,1);

  grid->Add(new wxStaticText(this, -1, "Method:"), 0, wxALIGN_RIGHT);
  grid->Add(m_CHOICErenderMethod,0,wxALL|wxALIGN_LEFT,1);

  _addChannelControls(grid); // add r g b checkboxes (only for 3B)

  grid->Add(new wxStaticText(this,-1,"Scale:"),0,wxALIGN_RIGHT|wxALIGN_BOTTOM);
  grid->Add(scaleSizer,0,wxALL|wxALIGN_LEFT,1);
  
  grid->Add(0,3);
  grid->Add(0,3);

  horSpacer->Add(0,15);
  horSpacer->Add(grid);

  // ------------------------------------------------------------------------
  
  verSpacer->Add(10,0);
  verSpacer->Add(horSpacer);
  verSpacer->Add(10,0);

  sizer->Add(verSpacer,0,wxEXPAND, 5);
}


template<int SIZE>
bool vuStandardFVR<SIZE>::glInit()
{
  if (m_Data == NULL) return false;
  //Data->initOpenGL();
  return true;
}

template<int SIZE>
void vuStandardFVR<SIZE>::glRender()
{
  wxStopWatch watch;

  watch.Start();
  m_Data->render();
  watch.Pause();

  wxString statusText = "Render Time: ";

  statusText += vuString(watch.Time()).c_str();
  statusText += "ms";
  SetStatusText(statusText);

  m_Data->glResize(m_glCanvas->getWidth(), m_glCanvas->getHeight());
}

template<int SIZE>
void vuStandardFVR<SIZE>::glResize()
{
  m_Data->glResize(m_glCanvas->getWidth(), m_glCanvas->getHeight());
  m_glCanvas->redraw();
}

template <int SIZE>
vu1 *vuStandardFVR<SIZE>::getVolume()
{
  return m_Data;
}

// --- callbacks -------------------------------------------------------------

template <int SIZE>
void vuStandardFVR<SIZE>::onKeyboard(wxKeyEvent &event)
{
  // this is the place for keyboard behaviour
}

template <int SIZE>
void vuStandardFVR<SIZE>::OnChoiceRenderMethod(wxCommandEvent& event)
{
  dword idx = m_CHOICErenderMethod->GetSelection();
  if (idx == 0) { // spatial domain
    m_SLIDERimageScale->SetValue(255*10);
  }
  else { // frequency domain
    m_SLIDERimageScale->SetValue(1);
  }
  m_Data->setRenderMethod(idx);
  m_Data->setScale(1/(float)(m_SLIDERimageScale->GetValue() * 10));
  m_Data->setIsReRendering(true);
  m_glCanvas->redraw();
}

template <int SIZE>
void vuStandardFVR<SIZE>::OnChoiceFilter(wxCommandEvent& event)
{
  vuFourierFilter *tmp = m_Data->getFilter();
  vuString name = m_CHOICEfilter->GetStringSelection().c_str();

  if (tmp) if (tmp->getFilterName() == name) return;

  m_Data->setFilter(vuTorstensFourierFilter::getFilter(name));
  CHECKNDELETE(tmp);
  m_glCanvas->redraw();  
}

template <int SIZE>
void vuStandardFVR<SIZE>::OnButtonFitScale(wxCommandEvent& event)
{
  m_Data->fitScale();
  m_glCanvas->redraw();
}

template <int SIZE>
void vuStandardFVR<SIZE>::OnSliderImageScale(wxScrollEvent& event)
{
  m_Data->setScale(255.0f/(float)m_SLIDERimageScale->GetValue());
  m_glCanvas->redraw();
}

template <int SIZE>
void vuStandardFVR<SIZE>::OnCheckboxChannels(wxCommandEvent& event)
{
  for (int i=0; i<SIZE; i++) {
    m_Data->setIsChannelActive(i, m_CHECKBOXchannels[i]->GetValue());
  }
  m_glCanvas->redraw();
}


// --------------------------------------------------------------------------

template <int SIZE>
void vuStandardFVR<SIZE>::_addChannelControls(wxFlexGridSizer *sizer)
{
  vuString str;

  if (SIZE == 1)
    return;
  else if (SIZE == 2)
    str = "IA";
  else if (SIZE == 3)
    str = "RGB";
  else
    return;

  wxBoxSizer *channelSpacer = new wxBoxSizer(wxHORIZONTAL);

  m_CHECKBOXchannels = new wxCheckBox*[SIZE];

  for (int i=0; i<SIZE; i++) {
    m_CHECKBOXchannels[i] = new wxCheckBox(this, idCHANNELS, str[(dword)i],
                                      wxDefaultPosition, wxSize(130/SIZE,15));
    m_CHECKBOXchannels[i]->SetValue(true);
    channelSpacer->Add(m_CHECKBOXchannels[i]);
  }

  sizer->Add(new wxStaticText(this, -1, "Channels:"), 0, wxALIGN_RIGHT);
  sizer->Add(channelSpacer,0,wxALL|wxALIGN_LEFT,1);
}
