// $Id: vuFVR.h,v 1.1 2004/05/21 21:04:03 maxx Exp $

/** 	Created September 2002
	By Martin Spindler */

#ifndef _vuFVRUtility_h_
#define _vuFVRUtility_h_

#include "../vuBasicUtility.h"
#include "../../wxUIElements/vuTransferDialog.h"
#include "vuCamera.h"
#include "Volume/Regular/Unimodal/3d/1B/Intensity/FVR/FVR.h"
#include "Volume/Regular/Unimodal/3d/1B/Intensity/FVR/TorstensFilters.h"
#include "vuTFunc/vuTFDesign.h"

class vuFVR : public vuBasicUtility
{
public:
    //!Constructor
    vuFVR();
    //!Destructor
    ~vuFVR();

    //!Returns the type of vu Datafile that the utility works with
    static const char* getFileType();

    /*!Initializes the utility window.  A FVR object is created and
       the volume data is read.  The window appears when finished.
    */
    bool init(const char* DataFile);

    //! Updates the view by calling m_glCanvas->redraw()
    virtual void notifyDataChanged();

    /** Rerenders the screen from the current camera position. */
    virtual void addRight(wxSizer *sizer);
    virtual void DrawAgain ();

    /** Draws on the screen the image contained in the image buffer. */
    virtual void DrawFromImage ();

    /** This will return a pointer to the image buffer that is being
        used by the method to draw images to... */
    virtual vuImage* getCurrentImage ();

    /** This will return a poiunter to the camera that the method is using
        (note that this may be derived from vuCamera...) */
    virtual vuCamera* getCamera ();

    /** This will return whether or not the FVR is rerendering to the
        screen. */
    virtual bool IsReRendering ();

    /** This will set the state of rerendering to be the same as isit. */
    virtual void setIsReRendering (bool isit);

 protected:
    //!Initializes open gl for the FVR utility.
    /*!The method calls the FVR initgl() method so it can do the
       proper initialization.
    */
    bool glInit();
    //!Calls on the FVR to render the volume.
    /*!The method calls the FVR render() method, setting it up to
       render to the window's gl canvas.
    */
    void glRender();
    //!Resizes the gl viewport and renders the volume.
    void glResize();
    //!Handles mouse commands from the user.
    /*!The mouse is the main interface between the user and the utility
       at the moment.  This method receives mouse events from the window,
       and carries out commands.
    */
    void glOnMouse(wxMouseEvent &ev);

    /** Keyboard handler. */
    void onKeyboard(wxKeyEvent& event);



    //! Callbacks for User Interface
    void OnCheckBoxDepthCueing( wxCommandEvent& event);
    void OnCheckBoxDiffuseShading( wxCommandEvent& event);
    void OnChoiceFilter( wxCommandEvent& event);

    void setTitle(const char* _title);

private:
    Filter *m_Filter;
    //!The FVR owned by the utility.
    vu1112117 *m_Data;
    //!A camera class for storing the user's current view.
    vuCamera m_Camera;
    //!The zoom magnification of the FVR.
    float m_ViewScale;
    //!the transfer function
    vuTFDesign m_TFunc;
    //!The dialog to edit the transfer function
    vuTransferDialog m_TFDialog;

#ifdef GL_VERSION_1_1
    GLuint texName;
#endif

    //!Last Mouse Position x
    int m_x;
    //!Last Mouse Position y
    int m_y;

    vuCamera m_CameraLight; // for computing the light (just a hack!!!)
    
    DECLARE_EVENT_TABLE()

    float m_scaleX;
    float m_scaleY;

    bool m_isRefineSlice;

    //!Graphical User Interface Elements
    wxCheckBox *m_CBdepthCueing;
    wxCheckBox *m_CBdiffuseShading;
    wxChoice   *m_CHOICEfilter;
};

#endif
