#include "vuFVR.h"
#include "vuColourRGBa.h"
#include "../../wxUIElements/vuGLCanvas.h"
#include <wx/colordlg.h>


//----------------------------------------------------------------------------
//------------------------- The vuFVR event table --------------------------
//----------------------------------------------------------------------------

enum
{
  idDEPTH_CUEING,
  idDIFFUSE_SHADING,
  idFILTER
};


BEGIN_EVENT_TABLE(vuFVR, vuBasicUtility)
  EVT_CHECKBOX(idDEPTH_CUEING,    vuFVR::OnCheckBoxDepthCueing)
  EVT_CHECKBOX(idDIFFUSE_SHADING, vuFVR::OnCheckBoxDiffuseShading)
  EVT_CHOICE(idFILTER,            vuFVR::OnChoiceFilter)
END_EVENT_TABLE();

//----------------------------------------------------------------------------
//------------------------- The constructor ----------------------------------
//----------------------------------------------------------------------------

vuFVR::vuFVR() : m_TFunc(4), m_TFDialog(this,m_TFunc)
{
    m_Data          = NULL;
    m_ViewScale     = 2.0f;
    m_Filter        = NULL;
}

//----------------------------------------------------------------------------
//------------------------- The destructor -----------------------------------
//----------------------------------------------------------------------------

vuFVR::~vuFVR()
{
    if (m_Data   != NULL) delete m_Data;
    if (m_Filter != NULL) delete m_Filter;
}

//----------------------------------------------------------------------------
//------------------------- public: getFileType() ----------------------------
//----------------------------------------------------------------------------

const char* vuFVR::getFileType()
{
    return "11121";
}

//----------------------------------------------------------------------------
//------------------------- public: init() -----------------------------------
//----------------------------------------------------------------------------

void vuFVR::setTitle(const char* _title)
{
  vuString title(_title);
  if (m_Data) {
    title += " [";
    title += vuString(m_Data->getDim1Size());
    title += "x";
    title += vuString(m_Data->getDim2Size());
    title += "x";
    title += vuString(m_Data->getDim3Size());
    title += "]";
  }
  vuBasicUtility::SetTitle(title.c_str());
}

bool vuFVR::init(const char* DataFile)
{
  //Set up the window for the FVR.
  CreateStatusBar();

  m_isRefineSlice = true;
    
  //Create a volume data instance.
  m_Data   = new vu1112117;
  m_Filter = new TorstensFilters(d0_c0_1ef);
  m_Data->setFilter(m_Filter);
  m_Data->setSliceScale(0.125);
  m_Data->setFileName(DataFile);
  m_Data->setIsDepthCueing(false);
  m_Data->setIsDiffuseShading(false);

  m_CameraLight.setPosition(vuVector(1.0, 0.0, 0.0));
  
  //Read in the data.
  bool success = m_Data->read();
  if (success) {
    m_glCanvas->SetSize(512,512);
    Fit();
  }
  else {
    wxMessageDialog dlg(this,m_Data->getErrorMessage(),"vuFVR",wxOK);
    dlg.ShowModal();
  }
  setTitle("vuFVR");
  return success;
};

void vuFVR::DrawAgain ()
{
  m_glCanvas->redraw();
}

void vuFVR::DrawFromImage ()
{
  cerr << "??? drawFromImage.." << endl;
  //m_Data->drawPic();
}

vuImage* vuFVR::getCurrentImage ()
{
  return m_Data->getBuffer();
}

vuCamera* vuFVR::getCamera ()
{
	return &m_Camera;
}

//----------------------------------------------------------------------------
//------------------------- public: addRight() -------------------------------
//----------------------------------------------------------------------------

void vuFVR::addRight(wxSizer *sizer)
{
  //Add some control elements
  m_CBdepthCueing = new wxCheckBox(this,idDEPTH_CUEING,"Depth Cueing");
  m_CBdepthCueing->SetValue(false);

  m_CBdiffuseShading= new wxCheckBox(this,idDIFFUSE_SHADING,"Diffuse Shading");
  m_CBdiffuseShading->SetValue(false);

  m_CHOICEfilter = 
    new wxChoice(this, idFILTER, wxDefaultPosition, wxSize(-1,-1),
		 0, NULL, wxMAXIMIZE_BOX, wxDefaultValidator, "Filter");

  m_CHOICEfilter->Append("d0_c0_2ef");
  m_CHOICEfilter->Append("d0_c0_3ef");
  m_CHOICEfilter->Append("d0_c0_4ef");
  m_CHOICEfilter->Append("d0_c1_1ef");
  m_CHOICEfilter->Append("d0_c1_2ef");
  m_CHOICEfilter->Append("d0_c1_3ef");
  m_CHOICEfilter->Append("d0_c1_4ef");
  m_CHOICEfilter->Append("d0_c2_1ef");
  m_CHOICEfilter->Append("d0_c2_2ef");
  m_CHOICEfilter->Append("d0_c2_3ef");
  m_CHOICEfilter->Append("d0_c2_4ef");
  m_CHOICEfilter->Append("d0_c3_1ef");
  m_CHOICEfilter->Append("d0_c3_2ef");
  m_CHOICEfilter->Append("d0_c3_3ef");
  m_CHOICEfilter->Append("d0_c3_4ef");
  m_CHOICEfilter->Append("d0_cn_1ef");
  m_CHOICEfilter->Append("d0_cn_2ef");
  m_CHOICEfilter->Append("d0_cn_3ef");
  m_CHOICEfilter->Append("d0_cn_4ef");
  m_CHOICEfilter->SetSelection(0);

  sizer->Add(m_CBdepthCueing,0,wxALL|wxALIGN_LEFT,1);
  sizer->Add(m_CBdiffuseShading,0,wxALL|wxALIGN_LEFT,1);
  sizer->Add(m_CHOICEfilter,0,wxALL|wxALIGN_LEFT,1);
}

//----------------------------------------------------------------------------
//---------------- protected: Callbacks for UserInterface --------------------
//----------------------------------------------------------------------------

void vuFVR::OnCheckBoxDepthCueing( wxCommandEvent& event)
{
  m_Data->setIsDepthCueing(m_CBdepthCueing->GetValue());
  m_Data->setIsReRendering(true);
  m_glCanvas->redraw();
}

void vuFVR::OnCheckBoxDiffuseShading( wxCommandEvent& event)
{
  m_Data->setIsDiffuseShading(m_CBdiffuseShading->GetValue());
  m_Data->setIsReRendering(true);
  m_glCanvas->redraw();
}

void vuFVR::OnChoiceFilter( wxCommandEvent& event)
#define FILTER_SET_SUB(x) { m_Filter = new TorstensFilters((x)); m_Data->setFilter(m_Filter);}
{
  Filter* tmp = m_Filter;

  switch(m_CHOICEfilter->GetSelection()) {
    case 0:  FILTER_SET_SUB(d0_c0_1ef); break;
    case 1:  FILTER_SET_SUB(d0_c0_2ef); break;
    case 2:  FILTER_SET_SUB(d0_c0_3ef); break;
    case 3:  FILTER_SET_SUB(d0_c0_4ef); break;
    case 4:  FILTER_SET_SUB(d0_c1_1ef); break;
    case 5:  FILTER_SET_SUB(d0_c1_2ef); break;
    case 6:  FILTER_SET_SUB(d0_c1_3ef); break;
    case 7:  FILTER_SET_SUB(d0_c1_4ef); break;
    case 8:  FILTER_SET_SUB(d0_c2_1ef); break;
    case 9:  FILTER_SET_SUB(d0_c2_2ef); break;
    case 10: FILTER_SET_SUB(d0_c2_3ef); break;
    case 11: FILTER_SET_SUB(d0_c2_4ef); break;
    case 12: FILTER_SET_SUB(d0_c3_1ef); break;
    case 13: FILTER_SET_SUB(d0_c3_2ef); break;
    case 14: FILTER_SET_SUB(d0_c3_3ef); break;
    case 15: FILTER_SET_SUB(d0_c3_4ef); break;
    case 16: FILTER_SET_SUB(d0_cn_1ef); break;
    case 17: FILTER_SET_SUB(d0_cn_2ef); break;
    case 18: FILTER_SET_SUB(d0_cn_3ef); break;
    case 19: FILTER_SET_SUB(d0_cn_4ef); break;
    default: return;
  }
  if (tmp) delete tmp;
  m_Data->setIsReRendering(true);
  m_glCanvas->redraw();
#undef FILTER_SET_SUB
}

//----------------------------------------------------------------------------
//------------------------- protected: glInit() ------------------------------
//----------------------------------------------------------------------------

bool vuFVR::glInit(void)
{
    if (m_Data == NULL) return false;

    m_Data->initOpenGL();

    return true;
};


//----------------------------------------------------------------------------
//------------------------- protected: glRender() ----------------------------
//----------------------------------------------------------------------------

void vuFVR::glRender()
{
  glClear(GL_COLOR_BUFFER_BIT);
  glPixelZoom(m_scaleX, m_scaleY);

  glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluOrtho2D(0,m_glCanvas->getWidth(),
	     0,m_glCanvas->getHeight());
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();

  if (m_Data->IsReRendering()) {
    wxStopWatch watch;
    watch.Start();

    if (m_isRefineSlice) {
      m_Data->clearSlices();
      m_Data->refineSlice(0, 0, 20, 20);
    }
    else
      m_Data->computeSlice();

    m_Data->setIsReRendering(false);

    watch.Pause();
    SetStatusText(wxString("Render Time: ") + 
		  vuString(watch.Time()).c_str() + "ms");
    m_Data->drawImageFromSlices();
    m_Data->setIsPostProcessing(false);

  }
  if (m_Data->IsPostProcessing()) {
    wxStopWatch watch;
    watch.Start();

    m_Data->drawImageFromSlices();
    m_Data->setIsPostProcessing(false);

    watch.Pause();
    SetStatusText(wxString("Postprocessing Time: ") + 
		  vuString(watch.Time()).c_str() + "ms");
  }
  m_Data->render();
};

//---------------------------------------------------------------------------
void vuFVR::notifyDataChanged()
{
    m_glCanvas->redraw();
}

//----------------------------------------------------------------------------
//------------------------- protected: glResize() ----------------------------
//----------------------------------------------------------------------------

void vuFVR::glResize()
{
    glViewport(0, 0, (GLint)m_glCanvas->getWidth(),(GLint)m_glCanvas->getHeight());

    m_scaleX = (float)m_glCanvas->getWidth()  / (float)m_Data->getSliceWidth();
    m_scaleY = (float)m_glCanvas->getHeight() / (float)m_Data->getSliceWidth();
}

//----------------------------------------------------------------------------
//------------------------- protected: glOnMouse() ---------------------------
//----------------------------------------------------------------------------

void vuFVR::glOnMouse(wxMouseEvent &ev)
{
    if (ev.LeftDown() || ev.RightDown()) {
        //Store the click position.
        m_x = (int) ev.GetX();
        m_y = (int) ev.GetY();
    }
    else if (ev.LeftIsDown() && ev.Moving()) {
        //Rotate the volume
        vuVector t = m_Camera.getPosition();

        m_Camera.rotateAboutUp(ev.GetX() - m_x);
        m_Camera.rotateAboutRight(ev.GetY() - m_y);

	m_Camera.gluLookAt();
#if 0
	m_Data->setViewVectors(vuVector(0,0,1),
			       vuVector(0,1,0),
			       vuVector(1,0,0));
#else
	m_Data->setViewVectors(m_Camera.getLookAtVector(),
			       m_Camera.getUpVector(),
			       m_Camera.getRightVector());
#endif
	m_isRefineSlice = true;
	m_Data->setIsReRendering(true);
        m_glCanvas->redraw();

        //Store the click position.
        m_x = (int) ev.GetX();
        m_y = (int) ev.GetY();
    }
    else if (ev.RightIsDown() && ev.Moving()) {
        //Rotate the volume
        vuVector t = m_CameraLight.getPosition();
        float d = t.norm();

        m_CameraLight.translateXYZ(0.0f, 0.0f, d);
        m_CameraLight.rotateAboutUp(ev.GetX() - m_x);
        m_CameraLight.rotateAboutRight(ev.GetY() - m_y);
        m_CameraLight.translateXYZ(0.0f, 0.0f, -d);

	m_Data->setLightPosition(m_CameraLight.getPosition());

	m_isRefineSlice = false;
	m_Data->setIsReRendering(true);
        m_glCanvas->redraw();

        //Store the click position.
        m_x = (int) ev.GetX();
        m_y = (int) ev.GetY();
    }
    else if (ev.LeftDClick())
    {
        //Pop up the transfer function editor
	m_TFDialog.Show(true);
#if 0	
        if (dlg.ShowModal() == wxID_OK) {
	  m_TFunc = (vuTFDesignSpec&)dlg.getTransferFunc();
	  m_Data->setTransferFunc(m_TFunc);
	  m_glCanvas->redraw();
        }
#endif
    }
    else if (ev.LeftUp() || ev.RightUp()) {
      if (m_isRefineSlice) {
	m_isRefineSlice = false;
	m_Data->setIsReRendering(true);
	m_glCanvas->redraw();
      }
    }
}

/** keyboard handler */
void vuFVR::onKeyboard(wxKeyEvent& event) 
{
  char key = event.GetKeyCode();

  switch(key)
  {
    case 'a':
    case 'd':
    case 'A':
    case 'D':
      {
	wxColourData data;
	vuColourRGBa vuCol;
	wxColour     wxCol;

	if (key == 'a' || key == 'A') 
	  vuCol = m_Data->getAmbientColour();
	else // key = 'd' || key == 'D'
	  vuCol = m_Data->getDiffuseColour();

	wxCol.Set((unsigned char)(vuCol[0]*255),
		  (unsigned char)(vuCol[1]*255),
		  (unsigned char)(vuCol[2]*255));
	data.SetColour(wxCol);
	wxColourDialog dialog(this, &data);
	if (dialog.ShowModal() == wxID_OK) {
	  wxColourData retData = dialog.GetColourData();
	  wxCol   = retData.GetColour();
	  vuCol   = vuColourRGBa(((float)wxCol.Red())/255,
				 ((float)wxCol.Green())/255,
				 ((float)wxCol.Blue())/255);
	  if (key == 'a' || key == 'A')
	    m_Data->setAmbientColour(vuCol);
	  else // key = 'd' || key = 'D'
	    m_Data->setDiffuseColour(vuCol);
	  m_Data->setIsPostProcessing(true);
	  m_glCanvas->redraw();
	}
	break;
      }
    case 'r':
    case 'R':
      {
	m_Data->setIsReRendering(false);
	m_Data->clearSlices();
	m_Data->refineSlice(0, 0, 30, 30);
	m_glCanvas->redraw();
	break;
      }
  }
}

bool vuFVR::IsReRendering() {
  return m_Data->IsReRendering();
}

void vuFVR::setIsReRendering(bool isit) {
  m_Data->setIsReRendering(isit);
}
