/***************************************************************************
                          vuCellProjector.h  -  description
                             -------------------
    begin                : Thu May 1 2003
    copyright            : (C) 2003 by tmeng
    email                : tmeng@sfu.ca
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _vuCellProjectorUtility_h_
#define _vuCellProjectorUtility_h_

//----------------------------------------------------------------------------
#include "../vuBasicUtility.h"
#include "../../wxUIElements/vuTransferDialog.h"
#include "vuCamera.h"
#include "Volume/Regular/Unimodal/3d/1B/Intensity/CellProjector/CellProjector.h"
#include "vuTFunc/vuTFDesign.h"
#include "Volume/volume.h" //for getVolume that returns vu1*

//!A utility window for using Steve's more general cellProjectorter.

/*!
   This class is a utility window wrapper for Steve's general cellProjectorter.
   This cellProjectorter is part of the vuVolume tree, and is meant to be as general
   as possible. (see the included header files).  The utility displays
   an OpenGL window which lets users rotate the object, zoom it, as well
   as edit the transfer function.  All these commands are done using the mouse.

   The class is a good example of a general vuGui utility.  It can be
   used as a model for building other utilities.
*/
class vuCellProjector : public vuBasicUtility
{
 public:
    //!Constructor
    vuCellProjector();

    //!Destructor
    /*virtual*/ ~vuCellProjector();

 public:
    //!Returns the type of vu Datafile that the utility works with
    static const char* getFileType();

 public:

    //! Adds some controls to a right hand panel in utility window.
    /*virtual*/ void addRight(wxSizer* sizer);

    //!Initializes the cellProjector utility.
    /*!Initializes the utility window.  A cellProjector object is created and
       the volume data is read.  The window appears when finished.
    */
    /*virtual*/ bool init(const char* DataFile);

    //! Updates the view by calling m_glCanvas->redraw()
    /*virtual*/ void notifyDataChanged();

    /** Rerenders the screen from the current camera position. */
    /*virtual*/ void DrawAgain();

    /** Draws on the screen the image contained in the image buffer. */
    /*! 
      Can't have const qualifier coz the original pure virtual function
      doesn't have it and if this does the compilor will choke. Overridden
      virtual functions have to have the exact same scope, prototype
      and qualifiers in order for polymorphism to work.
    */
    /*virtual*/ void DrawFromImage();

    /** This will return a pointer to the image buffer that is being
        used by the method to draw images to... */
    /*virtual*/ vuImage* getCurrentImage();

    /** This will return a poiunter to the camera that this class is using
        (note that this may be derived from vuCamera...) */
    /*virtual*/ vuCamera* getCamera();

    /** This will return whether or not the cellProjector is rerendering to the
        screen. */
    /*virtual*/ bool IsReRendering();

    /** This will set the state of rerendering to be the same as isit. */
    /*virtual*/ void setIsReRendering(bool isit);

 protected:
    //!Initializes openGL for the cellProjector utility.
    /*!The method calls the CellProjector initGL() method so it can do the
       proper initialization.
    */
    /*virtual*/ bool glInit();

    //!Calls on the cellProjectorter to render the volume.
    /*!The method calls the cellProjectorter render() method, setting it up to
       render to the window's gl canvas.
    */
    /*virtual*/ void glRender();

    //!Resizes the gl viewport and renders the volume.
    /*virtual*/ void glResize();

    //! Handles additional mouse commands from the user.
    /*!
      onMouse() is the one that vuBasicUtility asks client programmers
      to override, not glOnMouse. But vuBasicUtility::glOnMouse doesn't
      work.
    */
    /*virtual*/ void glOnMouse(wxMouseEvent &ev);

    //! Returns a parent pointer to the current algorithm.
    /*virtual*/ vu1* getVolume();

    //! Overwritten keyboard handler from vuBasicUtility.
    /*!
      If data size is 8, the keys 0~4 will display 5 tets
      If data size is 12, the keys 0~9 will display the 10 tets.

      onKeyboard should be the one overridden, according to vuBasicUtility.
      But vuBasicUtility::OnChar doesn't work.
     */
    /*virtual*/ void OnChar(wxKeyEvent& event);

    //! Controls whether the cell projector sorts and triangulates its tets.
#if wxMINOR_VERSION < 5
    void onCheckBoxIsSort();
#else
    void onCheckBoxIsSort(wxCommandEvent&);
#endif

    //! Controls which subdivision scheme to use.
#if wxMINOR_VERSION < 5
    void onListBoxSubdivScheme();
#else
    void onListBoxSubdivScheme(wxCommandEvent&);
#endif

    //! When user presses this button, renders the data set with current settings.
#if wxMINOR_VERSION < 5
    void onButtonRender();
#else
    void onButtonRender(wxCommandEvent&);
#endif

    //! Add checkbox for whether to sort and triangulate data set.
    void addCheckBoxIsSort(wxSizer* sizer);

    //! Add listbox for subdiv scheme.
    void addListBoxSubdivScheme(wxSizer* sizer);

    //! Adds a button for whether or not to render the data set.
    /*!
      Since the cell projector is so slow, it is desirable to allow the
      user to rotate to a desired location, then render.
     */
    void addButtonRender(wxSizer* sizer);

 private:
    //!The cellProjector owned by the utility.
    vu111211a *m_Data;

    //!A camera class for storing the user's current view.
    vuCamera m_Camera;

    //!The zoom magnification of the cellProjector.
    float m_ViewScale;

    //!the transfer function
    vuTFDesign m_TFunc;

    //!The dialog to edit the transfer function
    vuTransferDialog m_TFDialog;

    //! The x click position of the mouse.
    int m_x;
    //! The y click position of the mouse.
    int m_y;

 private:
    //! Whether or not to perform sorting and triangulation.
    /*!
      For render-timing comparative purposes.
     */
    wxCheckBox* m_checkBoxIsSort;

    //! List of subdivision algorithms currently available.
    /*!
      5-fold, 6-fold, more to come later.
      Should become auto-scrollable if a lot of entries go in here.
     */
    wxListBox* m_listBoxSubdivScheme;

 private:
    
    DECLARE_EVENT_TABLE()
};

#endif
