//!A utility window for using Steve's more general splatter.

/*!
   This class is a utility window wrapper for Steve's general splatter.
   This splatter is part of the vuVolume tree, and is meant to be as general
   as possible. (see the included header files).  The utility displays
   an OpenGL window which lets users rotate the object, zoom it, as well
   as edit the transfer function.  All these commands are done using the mouse.
   
   The class is a good example of a general vuGui utility.  It can be
   used as a model for building other utilities.  
*/

#ifndef _vuBccSplatUtility_h_
#define _vuBccSplatUtility_h_

#include "../vuBasicUtility.h"
#include "vuCamera.h"
#include "Volume/BCC/Unimodal/3d/1B/Intensity/Splat/splat.h"
#include "vuTFunc/vuTFDesign.h"

class vuBccSplat : public vuBasicUtility
{
public:
    //!Constructor
    vuBccSplat();
    //!Destructor
    ~vuBccSplat();

    //!Returns the type of vu Datafile that the utility works with
    static const char* getFileType();

    //!Initializes the splatter utility.
    /*!Initializes the utility window.  A splatting object is created and
       the volume data is read.  The window appears when finished.
    */
    bool init(const char* DataFile);

    virtual void DrawAgain ();
    virtual void DrawFromImage ();
    virtual vuImage* getCurrentImage ();
    virtual vuCamera* getCamera ();

protected:
    //!Initializes open gl for the splatter utility.
    /*!The method calls the splatter initgl() method so it can do the
       proper initialization.
    */
    bool glInit();
    //!Calls on the splatter to render the volume.
    /*!The method calls the splatter render() method, setting it up to
       render to the window's gl canvas.
    */
    void glRender();
    //!Resizes the gl viewport and renders the volume.
    void glResize();
    //!Handles mouse commands from the user.
    /*!The mouse is the main interface between the user and the utility
       at the moment.  This method receives mouse events from the window,
       and carries out commands.
    */
    void glOnMouse(wxMouseEvent &ev);

private:
    //!The splatter owned by the utility.
    vu1512111 *m_Data;
    //!A camera class for storing the user's current view.
    vuCamera m_Camera;
    //!The zoom magnification of the splatter.
    float m_ViewScale;
    //!The transfer function to be applied to the splatter.
    vuTFDesign m_TFunc;

    //!The width of the window.
    int m_x;
    //!The height of the window.
    int m_y;
    
    DECLARE_EVENT_TABLE()
};

#endif
