/*	Modified by Christopher Steinbach
	Modified March 2002
	Modified to add the functions which must be overridden in
	order for the Key Frame Animator to work with the method
	(getcamera, drawagain, drawfromimage, get image).

	Modified By Christopher Steinbach
	Modified April 2002

	Modified to use the IsReRendering functions of the volume
	tree to provide correct behaviour.

	Also modified to add IsReRendering and setIsReRendering
	functions tro this tree so that the key frame animatore will work.

	Will now work with the splatter.
*/

#ifndef _vuBasicUtility_h_
#define _vuBasicUtility_h_

#include "../vuUtilityWindow.h"
#include "../wxUIElements/vuGLCanvas.h"
#include "../wxUIElements/vuHelpPanel.h"
#include "../wxUIElements/vuKeyFramerDialog/vuKeyFramerDialog.h"

#include "vuCamera.h"
#include "vuPerspectiveCamera.h"
#include "vuParallelCamera.h"

#include "vuImage.h"
#include "../../Volume/volume.h"

#include "../wxUIElements/vuTransferCanvas.h" //for transfer function.

class vuBasicGLCanvas;

class vuKeyFramerDialog;

	// this is the namespace of the vuImage class
	// it is needed to properely compile....
//using namespace ns_vu1112113;

//! A minimal implementation of the vuUtilityWindow that can be used to quickly create utility windows.

/*! This class is meant to be a base class for as many utility windows as
    possible.  It implements a basic architecture for utility windows and
    provides hooks to add utility specific code.  By overriding a few of
    the methods, a functional utility window can be created with minimum
    coding.

    The basic window is created on the assumption that most utilities will
    have a main OpenGL canvas, with several widgets to configure the rendering
    to the window.  The basic window creates this central OpenGL canvas, and
    allows widgets to be added above, below, and to the left and right of it.
    This is all done by overriding the add<area> methods (such as addTop()),
    creating controls, and adding them to the wxSizer.  The sizers are set up
    so that the window is automatically laid out by the sizers, and resized
    properly when needed.

    The basic window also makes it easier to render scenes to the main OpenGL
    canvas.  It provides an OpenGL initialization method, initGL(), which can
    be overridden to initialize OpenGL as needed for the canvas.  To render to
    the OpenGL canvas, the render() method is overridden.  All the opengl
    and window draw setting up is handled internally, and the render() method
    needs only to implement the actual rendering code.

    Finally, the basic window implements basic close() and
    DrawAgain() methods, so that these don't need to be implemented
    if they are not needed.

    These functions need to be properely implemented for the key framer to work
    with the volume rendering method:

	virtual void DrawAgain() = 0;
	virtual void DrawFromImage() = 0;
	virtual vuImage* getCurrentImage() = 0;
	virtual vuCamera* getCamera () = 0;

*/
class vuBasicUtility : public vuUtilityWindow
{
public:
    //!Window constructor.
    vuBasicUtility();
    //!Window destructor.
    virtual ~vuBasicUtility();

    //!Initializes the specifics of the utility window after the window itself has been created.
    virtual bool init(const char* DataFile) { return true; };
    //!Closes the utility window.
    /*!It sets the m_Main pointer to NULL and issues a window close request.*/
    virtual void close();

  public:	// functions that need to be overridden for the derived
  		// method to work with the key frame animator.


    /** This function must rerender the scene completely.  This is so that the key frame
        animator can set the camera, and then force a redraw by the method. */
    virtual void DrawAgain() = 0;

    /** This function must take the data vuImage buffer from the last call to
    	getCurrent Image and draw that on the screen.  This is so that prerendered
	video animation can be displayed by the key frame animator by simply setting
	the vuImage returned by getCurrentImage and then calling this function. */
    virtual void DrawFromImage() = 0;

    /** This function must return a pointer to the camera that is taking the picture
        of the scene.  This is so that the key frame animator can read the camera
	when it needs to take a snapshot and change the camera when it wants the
	method to rerender the scene from a predetermined camera position. */
    virtual vuCamera* getCamera () = 0;

    /** This function must return a pointer to the current vuImage buffer that the
        method can write to or read from.  This is how the key framer will update the
	screen. */
    virtual vuImage* getCurrentImage() = 0;

    /** This will return true if the method is rerendering the scene on the screen
        and this will return false otherwise. */
    virtual bool IsReRendering ();

    /** This sets the state of rerending the image on the screen to be the
        same as isit. */
    virtual void setIsReRendering (bool isit);

  public:

    //!Notifies the utility that the volume data has been changed and that it should update its view.
    virtual void notifyDataChanged ();

    //!Returns the file type that the utility works on
    static const char* getFileType() { return ""; };

    /**!En-/disable OpenGL support.
       OpenGL is enabled by default. Deactivate it to get fancy direct framebuffer access.
       Use vuDrawTools then to.
     */
    void useOpenGL(bool yesorno);

public:
    //The following methods are overridden to add controls to the window.
    //!This method adds controls to the top of the window.
    virtual void addTop(wxSizer *sizer) {};
    //!This method adds controls to the bottom of the window.
    virtual void addBottom(wxSizer *sizer) {};
    //!This method adds controls to the left of the window.
    virtual void addLeft(wxSizer *sizer) {};
    //!This method adds controls to the right of the window.
    virtual void addRight(wxSizer *sizer) {};

protected:
    //!Overridden to initialize OpenGL for the window's gl canvas.
    /*!\note This corresponds to the glInit() method of the vuGLCanvas
       member of the instance.
       \sa vuGLCanvas
    */
    virtual bool glInit() { return true; };
    //!Overridden to render the scene using OpenGL.
    /*!\note This corresponds to the render() method of the vuGLCanvas
       member of the instance.
       \note To redraw the contents of the window, m_glCanvas->redraw()
       should be called.
       \sa vuGLCanvas
    */
    virtual void glRender();
    //!Overridden to do any resizing calcuations for the OpenGL canvas.
    /*!\note This corresponds to the resize() method of the vuGLCanvas
       member of the instance.
       \sa vuGLCanvas
    */
    virtual void glResize() {};
    //!Overridden to process any mouse events associated with the gl canvas.
    /*!These are mouse clicks and movements that originate within the gl
       canvas created by the vuBasicWindow.  This method can implement
       tasks such as rotating the camera angle and such.
    */
    virtual void glOnMouse(wxMouseEvent &ev);

    /** Handler for key events.
	Override this function in your Utility to customize reactions.
    */
    virtual void OnChar(wxKeyEvent& event);

private:
    //!The initialization method for the utility window.
    /*!This method initializes the data members for the instance and sets up
       the user interface by calling the add<area>() methods.  It can be
       overridden to initialize other members, but the overriding methods
       should call this one as well.
    */
    bool init(vuMainWindow *main,const char* DataFile);

 public:
    const vuBasicGLCanvas *getCanvas();

protected:
    //!The openGL canvas created by the window.
    vuBasicGLCanvas *m_glCanvas;
    //!The main window that owns this utility.
    vuMainWindow *m_Main;

    //!The camera.
    vuCamera     *m_camera;

    //!The KeyFramer Dialog.
    vuKeyFramerDialog *m_keyframer;

    //!The Help Panel
    vuHelpPanel m_helpPanel;

    //!Make the BasicGLCanvas a friend of the class.
    friend class vuBasicGLCanvas;

    /** The transfer function. */
    vuTFDesign m_TFunc;

protected:
    //!Returns a pointer to the volume object. (usually m_Data)
    virtual vu1 *getVolume();

    //!Stores the last mouse position (used for rotating)
    int m_MouseX, m_MouseY;
    //!Flag that tracks, whether the preview will be rendered or not. 
    bool m_DrawPreview;

    //! Use this function to add your own additional mouse behaviour:
    virtual void onMouse(wxMouseEvent& event);
    // These functions are mouse 'subhandlers':
    //virtual void onLeftDoubleClick(wxMouseEvent &event);
    virtual void onMouseRightMoving(wxMouseEvent &event);
    virtual void onMouseLeftMoving(wxMouseEvent &event);
    //! This function stores the last mouse click position
    void storeMousePosition(wxMouseEvent &event);

    //! Use this function to add your own additional keyboard behaviour:
    virtual void onKeyboard(wxKeyEvent& event);
    // These functions are keyboard 'subhandlers':
    virtual void onKeyboardHelp(wxKeyEvent& event);
    virtual void onKeyboardKeyframer(wxKeyEvent& event);
    virtual void onKeyboardZoom(wxKeyEvent& event);
    virtual void onKeyboardRotate(wxKeyEvent& event);

    /*! This is the place for your rendering code. If you don't want to have
        the default preview behaviour, overwrite glRender() instead of
        onRender() -ms- */
    virtual void onRender();

    //! This callback defines the help text for the HelpPanel. -ms-
    virtual wxString helpText();
};

//----------------------------------------------------------------------------
//------------------------- Internal vuBasicGLCanvas class -------------------
//----------------------------------------------------------------------------

//! The Basic gl canvas class that comes with the vuBasicUtility

/*! This class has the same functionality as the vuGLCanvas.  It's purpose
    is to redirect the gl methods to the vuBasicGLCanvas class.
*/
class vuBasicGLCanvas : public vuGLCanvas
{
public:
    friend class vuBasicUtility;
 protected:
    /**This handler is called on keypress.
       it calls the handler of the parent window vuBasicUtility::OnChar()
       . We have to do this ourselves although
       due to the wxWindows specifications this should happen outomaticly if there would be
       no handler in this class. However...
       To customize the keyboard handler override OnChar in your Utility (which should be
       derived from vuBasicUtility).
    */
    virtual void OnChar(wxKeyEvent& event);
private:
	/** constructor,

	  passes parent to the constructors of vuGLCanvas and m_Parent
	*/
    vuBasicGLCanvas(vuBasicUtility *parent);
	 /** initializes m_Parent, the BasicUtility associated with this class */
    virtual bool glInit();
    	/** renders m_parant */

    /*!
      \note render() starts the rendering process.

      \note If the utility's getVolume() is implemented, it tries to draw
       a preview by using the volume's preview() method.

      \note Otherwise it just calls the utility's glRender().
     */
    virtual void render();
    	/** resizes m_parent */
    virtual void resize();
    	/**  passes the mouse event to OnMouse */
    virtual void OnMouse(wxMouseEvent &ev);

    DECLARE_EVENT_TABLE()

private:

	/** the utility that this is a wrapper for */
    vuBasicUtility *m_Parent;
};

#endif
