#include <wx/wx.h>
#include <iostream.h>
#include "vuBasicUtility.h"
#include "../vuMainWindow.h"
#include "../wxUIElements/vuKeyFramerDialog/vuKeyFramerDialog.h"
#include "../wxUIElements/vuTransferDialog.h"
#include "vuArcBall.h"

//----------------------------------------------------------------------------
//------------------------- The vuBasicGLCanvas implementation ---------------
//----------------------------------------------------------------------------

BEGIN_EVENT_TABLE(vuBasicGLCanvas, vuGLCanvas)
    EVT_MOUSE_EVENTS(vuBasicGLCanvas::OnMouse)
    EVT_CHAR(vuBasicGLCanvas::OnChar)
END_EVENT_TABLE();


vuBasicGLCanvas::vuBasicGLCanvas(vuBasicUtility *parent)
    : vuGLCanvas(parent), m_Parent(parent)

{
//	m_camera = parent->get_camera ();
};

void vuBasicUtility::notifyDataChanged ()

{
}

bool vuBasicGLCanvas::glInit()
{
    return m_Parent->glInit();
}

void vuBasicGLCanvas::render()
{
  m_Parent->glRender();
};

void vuBasicGLCanvas::resize()
{
    m_Parent->glResize();
};

void vuBasicGLCanvas::OnMouse(wxMouseEvent &ev)
{
    m_Parent->glOnMouse(ev);
};

void vuBasicGLCanvas::OnChar(wxKeyEvent& event)
{
  m_Parent->OnChar(event);
}

//----------------------------------------------------------------------------
//------------------------- public: vuBasicUtility ---------------------------
//----------------------------------------------------------------------------

vuBasicUtility::vuBasicUtility() : m_helpPanel(this)
{
    m_Main        = 0;
    m_glCanvas    = NULL;
    m_camera      = NULL;
    m_DrawPreview = true;
    m_keyframer   = NULL;
}

//----------------------------------------------------------------------------
//------------------------- public: ~vuBasicUtility --------------------------
//----------------------------------------------------------------------------

vuBasicUtility::~vuBasicUtility()
{
        //If the main window did not close the utility, then notify
        //that it is closed.  This has to be called from the destructor
        //because the OnClose event for the child window does not work
        //properly (it sets the this pointer to the wxMDIChild and not
        //to the vuBasicWindow, so you can't access data).
    if (m_Main!=0) m_Main->notifyClosed(this);
}
/*
void vuBasicGLCanvas::set_camera (vuCamera *cam)

{
	m_camera = cam;
}

vuCamera* vuBasicGLCanvas::get_camera ()

{
	return m_camera;
}

*/
//----------------------------------------------------------------------------
//------------------------- public: close() ----------------------------------
//----------------------------------------------------------------------------

void vuBasicUtility::close()
{
        //indicate that the main window should not be called anymore
    m_Main = NULL;
        //Call the regular window close function
    Close();
}

/*
void vuBasicUtility::DrawAgain ()

{
	cerr << "vuBasicUtility:;DrawAgain" << endl;
	glRender ();
}

void vuBasicUtility::setCamera (vuCamera *cam)

{
	m_camera = cam;
}

vuCamera* vuBasicUtility::getCamera ()

{
	return m_camera;
}
*/


const vuBasicGLCanvas *vuBasicUtility::getCanvas()
{
  return m_glCanvas;
}

//----------------------------------------------------------------------------
//------------------------- public: init() -----------------------------------
//----------------------------------------------------------------------------

bool vuBasicUtility::init(vuMainWindow *main,const char* DataFile)
{
    m_Main=main;

    //Create the window and show it
    //The parent must be explicitly cast as the proper wxWindow class so
    //that the Create() method can distinguish between MDI and non-MDI.
    bool success = Create((wxPARENTWINDOW*)m_Main,-1,"Utility",
			  wxPoint(-1,-1),wxSize(-1,-1),wxDEFAULT_FRAME_STYLE
			  |wxRESIZE_BORDER,"Utility");

    if (!success) return false;
    Show(false);

    //Create the OpenGL canvas.
    //It doesn't have to be deleted later because ownership is
    //passed to wxWindows
    m_glCanvas = new vuBasicGLCanvas(this);

    //create the window here
    //First the sizers.
    wxBoxSizer *mainSizer = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer *topSizer = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer *midSizer = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer *botSizer = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer *lefSizer = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer *cenSizer = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer *rigSizer = new wxBoxSizer(wxVERTICAL);
    //Add the glCanvas.
    m_glCanvas->SetSize(-1,-1,512,512);
    cenSizer->Add(m_glCanvas,1,wxEXPAND);
    //Add any derived window controls
    addTop(topSizer);
    addBottom(botSizer);
    addLeft(lefSizer);
    addRight(rigSizer);
    //Construct the window architecture.
    /*
    midSizer->Add(lefSizer,0,wxEXPAND);
    midSizer->Add(cenSizer,1,wxEXPAND);
    midSizer->Add(rigSizer,0,wxEXPAND);
    mainSizer->Add(topSizer);
    mainSizer->Add(midSizer,1,wxEXPAND);
    mainSizer->Add(botSizer);
    */
    midSizer->Add(lefSizer,0,wxGROW);
    midSizer->Add(cenSizer,1,wxEXPAND);
    midSizer->Add(rigSizer,0,wxGROW);
    mainSizer->Add(topSizer,0,wxGROW);
    mainSizer->Add(midSizer,1,wxEXPAND);
    mainSizer->Add(botSizer,0,wxGROW);
    //Set the window up to use the sizers
    SetSizer(mainSizer);
    SetAutoLayout(true);
    mainSizer->SetSizeHints( this );

    //Call the utility initialization function
    success = init(DataFile);
    if (success) Show(true);
    return success;
};

void vuBasicUtility::useOpenGL(bool yesorno)
{
  if(m_glCanvas)
    if(yesorno)
      m_glCanvas->enableOpenGL();
    else
      m_glCanvas->disableOpenGL();
}

bool vuBasicUtility::IsReRendering ()

{
	return false;
}

void vuBasicUtility::setIsReRendering (bool isit)
{
}


/* ------------------------------------------------------------------------- */
/* ------------------------- MOUSE handlers -------------------------------- */
/* ------------------------------------------------------------------------- */

/*! This is the main mouse handler. It calls several subhandlers, all starting
    with the prefix 'onMouse', e.g. onMouseRightMoving()

    \note It maps some mouse keys to their default behaviour. Please do NOT
    redefine these default mouse key bindings, since a general behaviour
    style is desired.

    \note Each single behaviour is defined by a special callBack, which
    can be used to define a new behaviour.

    \note Returns true, if it could handle the event, otherwise false. -ms-
*/
void vuBasicUtility::glOnMouse(wxMouseEvent &event)
{
  if (event.LeftDown() || event.RightDown())
    storeMousePosition(event);
  else if (event.LeftIsDown() && event.Moving())
    onMouseLeftMoving(event);
  else if (event.RightIsDown() && event.Moving())
    onMouseRightMoving(event);
  //currently cannot invoke transfer function dialog on left
  //double click because each group of algorithms can have their
  //own type of transfer function, even though only one type
  //of transfer function is currently used in vuVolume. See further
  //comments for volume::m_TFunc (which is commented out right now).

  //else if (event.LeftDClick())
    //invoke the transfer function dialog
    //onLeftDoubleClick(event);
  else
    onMouse(event);
}


//! Use this function to add more mouse behaviour
void vuBasicUtility::onMouse(wxMouseEvent &event)
{
  // this is supposed to be overwritten by subclasses
}

//----------------------------------------------------------------------------

//The following function can only be implemented if volume::m_TFunc
//is to be uncommented during a later architectural revision. Please
//read comments within vuBasicUtility::onMouse() and for volume::m_TFunc.
/*
void vuBasicUtility::onLeftDoubleClick(wxMouseEvent &event)
{
  vu1* volume = this->getVolume(); //invokes child class function.
  //polymorphically gets the volume data from the utility window
  //that inherits from vuBasicUtility.

  vuTransferDialog dlg(this,this->m_TFunc);

  if (dlg.ShowModal() == wxID_OK)
    {
      m_TFunc = dlg.getTransferFunc();
      volume->setTransferFunc(m_TFunc);
      m_glCanvas->redraw();
    }

  //Store the click position. Not quite sure why, but
  //the other mouse handlers do this, so I just copied.
  storeMousePosition(event);
}
*/

//----------------------------------------------------------------------------

/*! This function implements the default zooming behaviour using
    the mouse -ms-
*/
void vuBasicUtility::onMouseRightMoving(wxMouseEvent &event)
{
  vu1 *volume = getVolume();

  if (volume != NULL) {
    vuCamera *camera = volume->getCameraPtr();

    if (camera) {
      float s = ((float)event.GetY() - m_MouseY)/1.0f;
      camera->translateXYZ(0.0f, 0.0f, -s);
      glResize();
      volume->setIsReRendering(true);
      m_glCanvas->redraw();
    }
    else
      cerr << "vuBasicUtility::onMouseRightMoving: camera is not set" << endl;
  }
  //Store the click position.
  storeMousePosition(event);
}

/*! This function implements the default rotating behaviour using
    the mouse -ms-
*/
void vuBasicUtility::onMouseLeftMoving(wxMouseEvent &event)
{
  vu1 *volume = getVolume();

  if (volume) {
    vuCamera *camera = volume->getCameraPtr();

    if (camera) {
      vuVector t = camera->getPosition() - volume->getCenter();
      float d = t.norm();
      camera->translateXYZ(0.0f, 0.0f, d);
      t = camera->getPosition();
      //use the arc ball
      vuArcBall ball;
      ball.attachCamera(volume->getCamera());
      ball.setWinSize(int (camera->getWidth()), int (camera->getHeight()));
      ball.turn(m_MouseX, m_MouseY, event.GetX(), event.GetY());
      camera->translateXYZ(0.0f, 0.0f, -d);
      camera->init();
      volume->setIsReRendering(true);
      m_glCanvas->redraw();
    }
    else
      cerr << "vuBasicUtility::onMouseLeftMoving: camera is not set" << endl;
  }
  //Store the click position.
  storeMousePosition(event);
}

//! This function stores the last mouse click position -ms-
void vuBasicUtility::storeMousePosition(wxMouseEvent &event)
{
  m_MouseX = (int) event.GetX();
  m_MouseY = (int) event.GetY();
}



/* ------------------------------------------------------------------------- */
/* ----------------------- KEYBOARD handlers ------------------------------- */
/* ------------------------------------------------------------------------- */

/*! This is the main keyboard handler. It calls several handlers, all starting
    with the prefix 'onKeyboard', e.g. onKeyboardZoom()

    \note This callback maps some keyboard events to their default behaviour.
    Please do NOT redefine these default keyboard bindings, since a general
    behaviour style is desired.

    \note Each single behaviour is defined by a special callBack, which
    can be used to define a new behaviour.

    \note Returns true, if it could handle the event, otherwise false.  -ms-
*/

void vuBasicUtility::OnChar(wxKeyEvent& event)
{
  switch(event.GetKeyCode()) {
    case '?':
      onKeyboardHelp(event);
      break;
    case 'k':
      onKeyboardKeyframer(event);
      break;
    case 13: {
      SetStatusText("Rendering...");
      Refresh();
      vu1 *volume = getVolume();
      if (volume) volume->setIsReRendering(true);
      m_DrawPreview = false;
      m_glCanvas->redraw();
      break;
    }
    case 316: // left 
    case 317: // up
    case 318: // right 
    case 319: // down 
      onKeyboardRotate(event);
      break;
    case '-':
    case '+':
      onKeyboardZoom(event);
      break;
    default:
      return onKeyboard(event);
  }
}

//! Use this callback to add more keyboard bevaviour -ms-
void vuBasicUtility::onKeyboard(wxKeyEvent &event)
{
  // this is supposed to be overwritten by subclasses
}

//! This function opens a Help Window -ms-
void vuBasicUtility::onKeyboardHelp(wxKeyEvent& event)
{
  m_helpPanel.setTitle("Help");
  m_helpPanel.setHelpText(helpText());
  m_helpPanel.Show(true);
}

//! This function opens the Keyframer Window -ms-
void vuBasicUtility::onKeyboardKeyframer(wxKeyEvent& event)
{
  vu1 *volume = getVolume();

  if (volume != NULL) {
    vuCamera *camera = volume->getCameraPtr();

    if (camera != NULL) {
      if (m_keyframer == NULL) {
	m_keyframer = new vuKeyFramerDialog(this, camera, this);
	m_keyframer->setup(camera, this);
      }
      m_keyframer->Show(true);
    }
  }
  else {
    cerr << "Warning! No camera defined. Can't start the keyframer." << endl;
  }
}

/*! This function implements the default zooming behaviour using
    the keyboard -ms-
*/
void vuBasicUtility::onKeyboardZoom(wxKeyEvent& event)
{
  vu1 *volume = getVolume();

  if (volume != NULL) {
    vuCamera *camera = volume->getCameraPtr();

    if (camera) {
      float speed = (event.GetKeyCode() == '+') ?  10 : -10;
      camera->translateXYZ(0.0f, 0.0f, speed);
      glResize();
      m_glCanvas->redraw();
    }
  }
}

/*! This function implements the default rotating behaviour using
    the keyboard -ms-
*/
void vuBasicUtility::onKeyboardRotate(wxKeyEvent& event)
{
  vu1 *volume = getVolume();

  if (volume) {
    vuCamera *camera = volume->getCameraPtr();

    if (camera) {
      vuVector t = camera->getPosition() - volume->getCenter();
      float d = t.norm();
      camera->translateXYZ(0.0f, 0.0f, d);
      t = camera->getPosition();

      float speed = (event.m_shiftDown) ? 0.2 : 2;

      switch (event.GetKeyCode()) {
      case 316:
	camera->rotateAboutUp(speed);
	break;
      case 317:
	camera->rotateAboutRight(speed);
	break;
      case 318:
        camera->rotateAboutUp(-speed);
	break;
      case 319:
	camera->rotateAboutRight(-speed);
	break;
      }

      volume->setIsReRendering();
      camera->translateXYZ(0.0f, 0.0f, -d);
      camera->init();
      m_glCanvas->redraw();
    }
  }  
}

/* ------------------------------------------------------------------------- */
/* ----------------------- rendering handlers ------------------------------ */
/* ------------------------------------------------------------------------- */

void vuBasicUtility::glRender()
{
  vu1 *volume = getVolume();

  if (volume == NULL) {
    cerr << "Warning: Can't draw preview. ";
    cerr << "Probably the utility's getVolume() was not overwritten. ";
    cerr << endl;
    onRender();
  }
  else if(m_DrawPreview) {
    volume->preview();
    SetStatusText(wxString("Press '?' for Help!"));
  }
  else {
    onRender();
    m_DrawPreview = true;
  }
};

void vuBasicUtility::onRender()
{
  // this is the place for your rendering code. If you don't want to have
  // the default preview behaviour, overwrite glRender() instead of
  // onRender() -ms-
}

/* ------------------------------------------------------------------------- */
/* -------------------------- help text ------------------------------------ */
/* ------------------------------------------------------------------------- */

wxString vuBasicUtility::helpText()
{
  wxString str("");

  str += 
    "\n  Keyboard bindings:\n\n"
    "\t ?\t\t\t this help window\n"
    "\t k\t\t\t Keyframer\n"
    "\t +\t\t\t zoom in\n"
    "\t -\t\t\t zoom out\n"
    "\t enter\t\t\t render volume\n"
    "\t right\t\t\t rotate right\n"
    "\t left\t\t\t rotate left\n"
    "\t up\t\t rotate up\n"
    "\t down\t\t rotate down\n"
    "\t shift-right\t rotate slowly right\n"
    "\t shift-left\t\t rotate slowly left\n"
    "\t shift-up\t\t rotate slowly up\n"
    "\t shift-down\t rotate slowly down\n";
  return str;
}

/* ------------------------------------------------------------------------- */
/* -------------------------- help text ------------------------------------ */
/* ------------------------------------------------------------------------- */

vu1 *vuBasicUtility::getVolume()
{
  cerr << "Warning: the utility's getVolume() was not overwritten. " << endl;
  return NULL;
}
