// Author:	Steven Bergner
// Created:	Oct01

#ifndef _vuBccSheetSplatUtility_h_
#define _vuBCCSheetSplatUtility_h_

#include <wx/textctrl.h>

#include "../vuBasicUtility.h"
#include "vuCamera.h"
#include "Volume/BCC/Unimodal/3d/1B/Intensity/SheetSplat/SheetSplat.h"
#include "vuTFunc/vuTFDesign.h"
#include "vuPreviewWin.h"

class vuBCCSheetSplatter : public vuBasicUtility
{
public:
    //!Constructor
    vuBCCSheetSplatter();
    //!Destructor
    ~vuBCCSheetSplatter();

    //!Returns the type of vu Datafile that the utility works with
    static const char* getFileType();

    /*!Initializes the utility window.  A object is created and
       the volume data is read.  The window appears when finished.
    */
    bool init(const char* DataFile);

    virtual void DrawAgain ();
    virtual void DrawFromImage ();
    virtual vuImage* getCurrentImage ();
    virtual vuCamera* getCamera ();

public:
    //The following methods are overridden to add controls to the window.
    //!This method adds controls to the bottom of the window.
    virtual void addRight(wxSizer *sizer);

protected:
    /**Initializes open gl for the utility.
       The method calls the initgl() method so it can do the
       proper initialization.
    */
    bool glInit();

    /*!The method calls the render() method, setting it up to
       render to the window's gl canvas.
    */
    void glRender();
    //!Resizes the gl viewport and renders the volume.
    void glResize();
    //!Handles mouse commands from the user.
    /*!The mouse is the main interface between the user and the utility
       at the moment.  This method receives mouse events from the window,
       and carries out commands.
    */
    void glOnMouse(wxMouseEvent &ev);

    /** initiate a refresh of the rendering */
    void OnButtonRender( wxCommandEvent& event);
    /** Called if splat radius has been changed. */
#if wxMINOR_VERSION < 5
    void OnChangeSplatSize( void );
#else
    void OnChangeSplatSize(wxCommandEvent& );
#endif
    /** Called if slice width is to be changed. */
#if wxMINOR_VERSION < 5
    void OnChangeSliceWidth( void );
#else
    void OnChangeSliceWidth(wxCommandEvent& );
#endif
    /** Draws an axis aligned box originated at (0,0,0).
	Expired due to the existence of vuPreviewWin. */
    void drawBox(float sx, float sy, float sz);
	
private:
    //!The spectral raycaster owned by the utility.
    vu1512112 *m_Data;
    /** The transfer function.  This is not yet used because 
        the TF don't yet operate on spectral colours.*/
    vuTFDesign m_TFunc;

    //!The width of the window.
    int m_x;
    //!The height of the window.
    int m_y;

    /** bounging box flag. 
	Draw a bounding box (using OpenGL) instead of blitting 
	the scene view. OLD because of vuPreviewWin. */
    bool m_DrawBBox;

    //!This is a handle for a preview box.
    vuPreviewWin *m_Preview;

    //! for changing slice width and splat size
    wxTextCtrl *m_Slicew, *m_Splats;

    DECLARE_EVENT_TABLE()
};

#endif
