#include "vuBCCSheetSplatter.h"
#include <math.h>

#include "vuMatrix.h"
#include "vuArcBall.h"
#include "vuPreviewWin.h"

#include "../../wxUIElements/vuTransferDialog.h"
#include <wx/button.h>

//----------------------------------------------------------------------------
//------------------------- The vuSpectral event table --------------------------
//----------------------------------------------------------------------------

enum
{
  idCANVAS,
  idRENDER,
  idCHANGE_SLICEW,
  idCHANGE_SPLATS
};

BEGIN_EVENT_TABLE(vuBCCSheetSplatter, vuBasicUtility)
  EVT_BUTTON  (idRENDER, vuBCCSheetSplatter::OnButtonRender)
  EVT_TEXT_ENTER(idCHANGE_SLICEW, vuBCCSheetSplatter::OnChangeSliceWidth)
  EVT_TEXT_ENTER(idCHANGE_SPLATS, vuBCCSheetSplatter::OnChangeSplatSize)
END_EVENT_TABLE()

//----------------------------------------------------------------------------
//------------------------- The constructor ----------------------------------
//----------------------------------------------------------------------------

vuBCCSheetSplatter::vuBCCSheetSplatter()
{
    m_Data = NULL;
    m_DrawBBox = false;
}

//----------------------------------------------------------------------------
//------------------------- The destructor -----------------------------------
//----------------------------------------------------------------------------

vuBCCSheetSplatter::~vuBCCSheetSplatter()
{
    if (m_Data != 0) delete m_Data;
}

//----------------------------------------------------------------------------
//------------------------- public: getFileType() ----------------------------
//----------------------------------------------------------------------------

const char* vuBCCSheetSplatter::getFileType()
{
    return "15121";
}

//----------------------------------------------------------------------------
//------------------------- public: init() -----------------------------------
//----------------------------------------------------------------------------

bool vuBCCSheetSplatter::init(const char* DataFile)
{
    //Set up the window
    SetTitle("sheet-based BCC grid splatting");
    CreateStatusBar();

    //Create a volume data instance.
    m_Data = new vu1512112;
    m_Data->setFileName(DataFile);

    /*
    //Set the transfer function for the data.
    m_TFunc.addOpacity(0,0.00);
    m_TFunc.addOpacity(1,0.00);
    m_TFunc.addColour(1,0,0,0);
    
    //m_TFunc.addOpacity(50,.3);
    //m_TFunc.addColour(50,1,1,1);
    //m_TFunc.addOpacity(99,.3);
    //m_TFunc.addColour(99,1,1,1);
    
    m_TFunc.addOpacity(199,0.00);
    m_TFunc.addOpacity(200,1);
    m_TFunc.addColour(200,1,0,0);
    m_TFunc.addOpacity(255,1);
    m_TFunc.addColour(255,1,0,0);
    */

    //Set the transfer function for the data.
    m_TFunc.addOpacity(0,0.00);
    m_TFunc.addOpacity(1,0.00);
    m_TFunc.addColour(1,vuColourRGBa(0.0f));

    m_TFunc.addOpacity(4,0.06);
    m_TFunc.addOpacity(11,0.01);
    m_TFunc.addOpacity(12,1);
    m_TFunc.addOpacity(32,1);
    m_TFunc.addColour(1,vuColourRGBa(0.0f));
    m_TFunc.addColour(11,vuColourRGBa(1.0f));
    m_TFunc.addColour(32,vuColourRGBa(1.f,0.f,0.f,1.f));
 
    m_TFunc.addOpacity(255,1);
    m_TFunc.addColour(255,vuColourRGBa(1,0,0));

    m_TFunc.setOpacitySmoothing(0);
    m_TFunc.setColourSmoothing(0);
    m_TFunc.generateFunction();
    m_Data->setTransferFunc(m_TFunc);

    //Read in the data.
    bool success = m_Data->read();
    if (success)
    {
        m_glCanvas->SetSize(512,512);
        Fit();
	//m_Preview->attachCamera(&m_Data->getCamera());
	//m_Preview->setCubeSize(m_Data->getDim1Size(),m_Data->getDim2Size(),m_Data->getDim3Size());
    }
    else
    {
        wxMessageDialog dlg(this,m_Data->getErrorMessage(),"vuBCCSheetSplatterVR",wxOK);
        dlg.ShowModal();
    }

    return success;
}

void vuBCCSheetSplatter::DrawAgain ()
{
}

void vuBCCSheetSplatter::DrawFromImage ()
{
}

vuImage* vuBCCSheetSplatter::getCurrentImage ()

{
	return NULL;
}

vuCamera* vuBCCSheetSplatter::getCamera ()

{
	return NULL;
}

//----------------------------------------------------------------------------
//------------------------- public: addRight() -------------------------------
//----------------------------------------------------------------------------

void vuBCCSheetSplatter::addRight(wxSizer *sizer)
{
  //Add some control elements
  sizer->Add( new wxButton(this, idRENDER, "Render"),
		 0,           // make horizontally unstretchable
		 wxALL,       // make border all around (implicit top alignment)
		 10 );        // set border width to 10
  wxSize size(35,-1);
  sizer->Add(new wxStaticText(this,-1,"Splat radius:"),0,wxALL|wxALIGN_LEFT,1);
  m_Splats = new wxTextCtrl(this,idCHANGE_SPLATS,"", wxDefaultPosition,size,
			    wxTE_PROCESS_ENTER|wxTE_PROCESS_TAB,wxTextValidator(wxFILTER_NUMERIC));
  sizer->Add( m_Splats,1,wxALL|wxEXPAND,1 );
  sizer->Add(new wxStaticText(this,-1,"Sheet width:"),0,wxALL|wxALIGN_LEFT,1);
  m_Slicew = new wxTextCtrl(this,idCHANGE_SLICEW,"", wxDefaultPosition,wxDefaultSize,
			    wxTE_PROCESS_ENTER|wxTE_PROCESS_TAB,wxTextValidator(wxFILTER_NUMERIC));
  sizer->Add( m_Slicew,1,wxALL|wxEXPAND,1 );
  //m_Splats->SetValue(wxString::Format("%.3f",m_Data->getFootprintSize()));
  m_Splats->Enable(true);
  //m_Slicew->SetValue(wxString::Format("%.3f",m_Data->getSliceWidth()));
  m_Slicew->Enable(true);
  //m_Preview = new vuPreviewWin(this,200,200);
  /*  sizer->Add( m_Preview, 
	      1,           // make horizontally stretchable
	      wxALL,       // make border all around (implicit top alignment)
	      10 );        // set border width to 10
  */
}

//----------------------------------------------------------------------------
//------------------------- public: OnButtonRender() -------------------------
//----------------------------------------------------------------------------

void vuBCCSheetSplatter::OnButtonRender( wxCommandEvent& event)
{
  m_Data->doRefresh();
  m_glCanvas->redraw();
}


//----------------------------------------------------------------------------
//------------------------- protected: glInit() ------------------------------
//----------------------------------------------------------------------------

bool vuBCCSheetSplatter::glInit(void)
{
    if (m_Data == 0) return false;
  /*
    glClearColor(0.0f, 0.0f, 0.0f, 0.0f);

    glEnable(GL_LIGHTING);
    glEnable(GL_LIGHT0);
    glLightModeli(GL_LIGHT_MODEL_TWO_SIDE, GL_TRUE);
  */
    glEnable(GL_DEPTH_TEST);
    glDepthFunc(GL_LESS);
    m_Data->initOpenGL();
    
    useOpenGL(false);

    return true;
};

//----------------------------------------------------------------------------
//------------------------- protected: glRender() ----------------------------
//----------------------------------------------------------------------------

void vuBCCSheetSplatter::glRender()
{
    if( m_DrawBBox)
      {
	static int c = 0;
	if(c++<10) return;

	//Set the viewport.
	glViewport(0, int (m_glCanvas->getHeight() - m_Data->getCamera().getHeight()), (GLint)m_Data->getCamera().getWidth(), (GLint)m_Data->getCamera().getHeight());

	glEnable(GL_DEPTH_TEST);
	glDepthFunc(GL_LESS);
	//glEnable(GL_CULL_FACE);
	//glCullFace(GL_BACK);			//what a shit
	//glClear(GL_COLOR_BUFFER_BIT);
	glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);

	//Set the opengl projection matrix.
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	m_Data->getCamera().glInit();
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	m_Data->getCamera().gluLookAt();
	//vuMatrix cam = m_Data->getCamera().getViewMat();
	//glTranslatef(m_Data->center[0],m_Data->center[1],m_Data->center[2]);
	//glMultMatrixf(cam.getData());
	//glTranslatef(-m_Data->center[0],-m_Data->center[1],-m_Data->center[2]);
	//draw an axis aligned box
	vuVector dsize = m_Data->getCenter();
	dsize*=2;
	drawBox(dsize[0],dsize[1],dsize[2]);
      } else
      {
	wxStopWatch watch;
	watch.Start();

	m_Data->render();

	watch.Pause();
	SetStatusText(wxString("Render Time: ") + vuString(watch.Time()).c_str() + "ms");
      }
};

#if wxMINOR_VERSION < 5
void vuBCCSheetSplatter::OnChangeSliceWidth()
#else
void vuBCCSheetSplatter::OnChangeSliceWidth(wxCommandEvent&)
#endif
{
  double val;
  m_Slicew->GetValue().ToDouble(&val);
  m_Data->setSliceWidth(val);
  m_Slicew->SetValue(wxString::Format("%.2f",m_Data->getSliceWidth()));
}

#if wxMINOR_VERSION < 5
void vuBCCSheetSplatter::OnChangeSplatSize()
#else
void vuBCCSheetSplatter::OnChangeSplatSize(wxCommandEvent&)
#endif
{
  double val;
  m_Splats->GetValue().ToDouble(&val);
  m_Data->setFootprintSize(val);
  m_Splats->SetValue(wxString::Format("%.2f",m_Data->getFootprintSize()));
}

//----------------------------------------------------------------------------
//------------------------- protected: glResize() ----------------------------
//----------------------------------------------------------------------------

void vuBCCSheetSplatter::glResize()
{
  //Find the largest dimension of the data.
  dword max = m_Data->getDim1Size();
  if (m_Data->getDim2Size() > max)
    max = m_Data->getDim2Size();
  if (m_Data->getDim3Size() > max)
    max = m_Data->getDim3Size();
  vuParallelCamera *camera = (vuParallelCamera *)m_Data->getCameraPtr();

  float scale = camera->getXRange()/m_glCanvas->getWidth();
  //camera->setXRange(scale*m_glCanvas->getWidth());
  camera->setYRange(scale*m_glCanvas->getHeight());

  m_Data->setImageSize(m_glCanvas->getWidth(),m_glCanvas->getHeight());
  /*
    //Set the viewport.
    glViewport(0, 0, (GLint)m_glCanvas->getWidth(),(GLint)m_glCanvas->getHeight());

    //Find the largest dimension of the data.
    dword max = m_Data->getDim1Size();
    if (m_Data->getDim2Size() > max)
        max = m_Data->getDim2Size();
    if (m_Data->getDim3Size() > max)
        max = m_Data->getDim3Size();

    //Set the opengl projection matrix.
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    glOrtho((float)max/(-1.0f*m_ViewScale), (float)max/m_ViewScale,
            (float)max/(-1.0f*m_ViewScale), (float)max/m_ViewScale,
            10000.0f, -10000.0f);
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();

    //Set the opengl light info.
    float lpos[4] = {0.0, 0.0, 1024.0, 1.0};m_Data->m_Camera
    glLightfv(GL_LIGHT0, GL_POSITION, lpos);
  */
}

//----------------------------------------------------------------------------
//------------------------- protected: glOnMouse() ---------------------------
//----------------------------------------------------------------------------

void vuBCCSheetSplatter::glOnMouse(wxMouseEvent &ev)
{
    if(!m_Data) return;
    if (ev.LeftDown() || ev.RightDown())
    {
        //Store the click position.
        m_x = (int) ev.GetX();
        m_y = (int) ev.GetY();
    }
    else if (ev.LeftIsDown() && ev.Moving())
    {
        useOpenGL(true);
	m_DrawBBox = true;

        //Rotate the volume
	vuParallelCamera *camera = (vuParallelCamera *)m_Data->getCameraPtr();

        vuVector t = camera->getPosition()-m_Data->getCenter();
        float d = t.norm();
        camera->translateXYZ(0.0f, 0.0f, d);
	t = camera->getPosition();
	//use the arc ball
	vuArcBall ball;
	ball.attachCamera(m_Data->getCamera());
	ball.setWinSize(int (camera->getWidth()), int (camera->getHeight()));
	ball.turn(m_x, m_y, ev.GetX(), ev.GetY());
        //camera->rotateAboutUp(ev.GetX() - m_x);
        //camera->rotateAboutRight(ev.GetY() - m_y);
        camera->translateXYZ(0.0f, 0.0f, -d);
	camera->init();
        m_glCanvas->redraw();

        //Store the click position.
        m_x = (int) ev.GetX();
        m_y = (int) ev.GetY();
    }
    else if (ev.RightIsDown() && ev.Moving())
    {
      useOpenGL(true);
      m_DrawBBox = true;

        //distance from the volume.
        float s = ((float)ev.GetY() - m_y)/30.0f;
	if(fabs(s)>0.9) s=0;
        //float d = t.norm();
	vuParallelCamera *camera = (vuParallelCamera *)m_Data->getCameraPtr();

        camera->setXRange(camera->getXRange()*(1-s));
        camera->setYRange(camera->getYRange()*(1-s));
	//cout<<m_Data->getCamera().getXRange()<<endl;
        //glResize();
        m_glCanvas->redraw();

        //Store the click position.
        m_x = (int) ev.GetX();
        m_y = (int) ev.GetY();
    }
    else if (ev.LeftDClick())
    {
        //Pop up the transfer function editor
        vuTransferDialog dlg(this,m_TFunc);

        if (dlg.ShowModal() == wxID_OK)
        {
	    m_TFunc = dlg.getTransferFunc();
            m_Data->setTransferFunc(m_TFunc);
            m_glCanvas->redraw();
        }
    } else 
      {
	if(m_DrawBBox)
	  {
	    useOpenGL(false);
	    m_DrawBBox = false;
	    glResize();
	    m_glCanvas->redraw();
	  }
      }
}

void vuBCCSheetSplatter::drawBox(float sx, float sy, float sz)
{
  static GLfloat n[6][3] = {  /* Normals for the 6 faces of a cube. */
    {-1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {1.0, 0.0, 0.0},
    {0.0, -1.0, 0.0}, {0.0, 0.0, -1.0}, {0.0, 0.0, 1.0} };
  static GLint faces[6][4] = {  /* Vertex indices for the 6 faces of a cube. */
    {0, 1, 2, 3}, {3, 2, 6, 7}, {7, 6, 5, 4},
    {4, 5, 1, 0}, {5, 6, 2, 1}, {7, 4, 0, 3} };
  static GLfloat v[8][3];  /* Will be filled in with X,Y,Z vertexes. */
  
  /* Setup cube vertex data. */
  v[0][0] = v[1][0] = v[2][0] = v[3][0] = 0;
  v[4][0] = v[5][0] = v[6][0] = v[7][0] = sx;
  v[0][1] = v[1][1] = v[4][1] = v[5][1] = 0;
  v[2][1] = v[3][1] = v[6][1] = v[7][1] = sy;
  v[0][2] = v[3][2] = v[4][2] = v[7][2] = sz;
  v[1][2] = v[2][2] = v[5][2] = v[6][2] = 0;
  
  int i;
  for (i = 0; i < 6; i++) {
    glBegin(GL_QUADS);
    glNormal3fv(&n[i][0]);
    glColor3fv(v[faces[i][0]]);
    glVertex3fv(&v[faces[i][0]][0]);
    glColor3fv(v[faces[i][1]]);
    glVertex3fv(&v[faces[i][1]][0]);
    glColor3fv(v[faces[i][2]]);
    glVertex3fv(&v[faces[i][2]][0]);
    glColor3fv(v[faces[i][3]]);
    glVertex3fv(&v[faces[i][3]][0]);
    glEnd();
  }
}
